/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.LaunchServiceHandler;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.NameMappingServiceHandler;
import cpw.mods.modlauncher.ProtectionDomainHelper;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServicesHandler;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.INameMappingService;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.util.Supplier;

public class Launcher {
    public static Launcher INSTANCE;
    private final TypesafeMap blackboard;
    private final TransformationServicesHandler transformationServicesHandler;
    private final Environment environment;
    private final TransformStore transformStore;
    private final NameMappingServiceHandler nameMappingServiceHandler;
    private final ArgumentHandler argumentHandler;
    private final LaunchServiceHandler launchService;
    private final LaunchPluginHandler launchPlugins;
    private final ModuleLayerHandler moduleLayerHandler;
    private TransformingClassLoader classLoader;

    private Launcher() {
        INSTANCE = this;
        LogManager.getLogger().info(LogMarkers.MODLAUNCHER, "ModLauncher {} starting: java version {} by {}; OS {} arch {} version {}", new Supplier[]{() -> IEnvironment.class.getPackage().getImplementationVersion(), () -> System.getProperty("java.version"), () -> System.getProperty("java.vendor"), () -> System.getProperty("os.name"), () -> System.getProperty("os.arch"), () -> System.getProperty("os.version")});
        this.moduleLayerHandler = new ModuleLayerHandler();
        this.launchService = new LaunchServiceHandler(this.moduleLayerHandler);
        this.blackboard = new TypesafeMap();
        this.environment = new Environment(this);
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MLSPEC_VERSION.get(), s -> IEnvironment.class.getPackage().getSpecificationVersion());
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MLIMPL_VERSION.get(), s -> IEnvironment.class.getPackage().getImplementationVersion());
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MODLIST.get(), s -> new ArrayList());
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.SECURED_JARS_ENABLED.get(), k -> ProtectionDomainHelper.canHandleSecuredJars());
        this.transformStore = new TransformStore();
        this.transformationServicesHandler = new TransformationServicesHandler(this.transformStore, this.moduleLayerHandler);
        this.argumentHandler = new ArgumentHandler();
        this.nameMappingServiceHandler = new NameMappingServiceHandler(this.moduleLayerHandler);
        this.launchPlugins = new LaunchPluginHandler(this.moduleLayerHandler);
    }

    public static void main(String ... args) {
        if (System.getProperty("java.vm.name").contains("OpenJ9")) {
            System.err.printf("You are attempting to run with an unsupported Java Virtual Machine : %s\nPlease visit https://adoptopenjdk.net and install the HotSpot variant.\nOpenJ9 is incompatible with several of the transformation behaviours that we rely on to work.\n", System.getProperty("java.vm.name"));
            throw new IllegalStateException("Open J9 is not supported");
        }
        LogManager.getLogger().info(LogMarkers.MODLAUNCHER, "ModLauncher running: args {}", new Supplier[]{() -> LaunchServiceHandler.hideAccessToken(args)});
        new Launcher().run(args);
    }

    public final TypesafeMap blackboard() {
        return this.blackboard;
    }

    private void run(String ... args) {
        ArgumentHandler.DiscoveryData discoveryData = this.argumentHandler.setArgs(args);
        this.transformationServicesHandler.discoverServices(discoveryData);
        List<ITransformationService.Resource> scanResults = this.transformationServicesHandler.initializeTransformationServices(this.argumentHandler, this.environment, this.nameMappingServiceHandler);
        Map<IModuleLayerManager.Layer, List<ITransformationService.Resource>> bylayer = scanResults.stream().collect(Collectors.groupingBy(ITransformationService.Resource::target));
        bylayer.getOrDefault((Object)IModuleLayerManager.Layer.PLUGIN, List.of()).stream().mapMulti((resource, action) -> resource.resources().forEach(action)).forEach(np -> this.moduleLayerHandler.addToLayer(IModuleLayerManager.Layer.PLUGIN, (SecureJar)np));
        this.moduleLayerHandler.buildLayer(IModuleLayerManager.Layer.PLUGIN);
        List<ITransformationService.Resource> gameResults = this.transformationServicesHandler.triggerScanCompletion(this.moduleLayerHandler);
        bylayer = gameResults.stream().collect(Collectors.groupingBy(ITransformationService.Resource::target));
        List<SecureJar> gamecontents = bylayer.getOrDefault((Object)IModuleLayerManager.Layer.GAME, List.of()).stream().mapMulti((resource, action) -> resource.resources().forEach(action)).toList();
        gamecontents.forEach(j -> this.moduleLayerHandler.addToLayer(IModuleLayerManager.Layer.GAME, (SecureJar)j));
        this.transformationServicesHandler.initialiseServiceTransformers();
        this.launchPlugins.offerScanResultsToPlugins(gamecontents);
        this.launchService.validateLaunchTarget(this.argumentHandler);
        TransformingClassLoaderBuilder classLoaderBuilder = this.launchService.identifyTransformationTargets(this.argumentHandler);
        this.classLoader = this.transformationServicesHandler.buildTransformingClassLoader(this.launchPlugins, classLoaderBuilder, this.environment, this.moduleLayerHandler);
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.classLoader));
        this.launchService.launch(this.argumentHandler, this.moduleLayerHandler.getLayer(IModuleLayerManager.Layer.GAME).orElseThrow(), this.classLoader, this.launchPlugins);
    }

    public Environment environment() {
        return this.environment;
    }

    Optional<ILaunchPluginService> findLaunchPlugin(String name) {
        return this.launchPlugins.get(name);
    }

    Optional<ILaunchHandlerService> findLaunchHandler(String name) {
        return this.launchService.findLaunchHandler(name);
    }

    Optional<BiFunction<INameMappingService.Domain, String, String>> findNameMapping(String targetMapping) {
        return this.nameMappingServiceHandler.findNameTranslator(targetMapping);
    }

    public Optional<IModuleLayerManager> findLayerManager() {
        return Optional.ofNullable(this.moduleLayerHandler);
    }
}

