/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.slf4j.Logger;

public class ExplodedDirectoryLocator
implements IModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ExplodedMod> explodedMods = new ArrayList<ExplodedMod>();
    private final Map<ExplodedMod, IModFile> mods = new HashMap<ExplodedMod, IModFile>();

    public List<IModLocator.ModFileOrException> scanMods() {
        this.explodedMods.forEach(explodedMod -> ModJarMetadata.buildFile((IModLocator)this, jar -> jar.moduleDataProvider().findFile("/META-INF/mods.toml").isPresent(), null, (Path[])explodedMod.paths().toArray(Path[]::new)).ifPresentOrElse(f -> this.mods.put((ExplodedMod)explodedMod, (IModFile)f), () -> LOGGER.warn(LogMarkers.LOADING, "Failed to find exploded resource mods.toml in directory {}", (Object)explodedMod.paths().get(0).toString())));
        return this.mods.values().stream().map(mf -> new IModLocator.ModFileOrException(mf, null)).toList();
    }

    public String name() {
        return "exploded directory";
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning exploded directory {}", (Object)file.getFilePath().toString());
        try (Stream<Path> files = Files.find(file.getSecureJar().getRootPath(), Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            files.forEach(pathConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug(LogMarkers.SCAN, "Exploded directory scan complete {}", (Object)file.getFilePath().toString());
    }

    public String toString() {
        return "{ExplodedDir locator}";
    }

    public void initArguments(Map<String, ?> arguments) {
        List explodedTargets = (List)arguments.get("explodedTargets");
        if (explodedTargets != null && !explodedTargets.isEmpty()) {
            this.explodedMods.addAll(explodedTargets);
        }
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    public record ExplodedMod(String modid, List<Path> paths) {
    }
}

