/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.MavenCoordinateResolver;
import org.slf4j.Logger;

public class LibraryFinder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Path libsPath;

    static Path findLibsPath() {
        if (libsPath == null && !Files.isDirectory(libsPath = Path.of(System.getProperty("libraryDirectory", "crazysnowmannonsense/cheezwhizz"), new String[0]), new LinkOption[0])) {
            throw new IllegalStateException("Missing libraryDirectory system property, cannot continue");
        }
        return libsPath;
    }

    static Path getForgeLibraryPath(String mcVersion, String forgeVersion, String forgeGroup) {
        Path forgePath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(forgeGroup, "forge", "", "universal", mcVersion + "-" + forgeVersion));
        LOGGER.debug(LogMarkers.CORE, "Found forge path {} is {}", (Object)forgePath, (Object)LibraryFinder.pathStatus(forgePath));
        return forgePath;
    }

    static String pathStatus(Path path) {
        return Files.exists(path, new LinkOption[0]) ? "present" : "missing";
    }

    static Path[] getMCPaths(String mcVersion, String mcpVersion, String forgeVersion, String forgeGroup, String type) {
        Path srgMcPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get("net.minecraft", type, "", "srg", mcVersion + "-" + mcpVersion));
        Path mcExtrasPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get("net.minecraft", type, "", "extra", mcVersion + "-" + mcpVersion));
        Path patchedBinariesPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(forgeGroup, "forge", "", type, mcVersion + "-" + forgeVersion));
        LOGGER.debug(LogMarkers.CORE, "SRG MC at {} is {}", (Object)srgMcPath.toString(), (Object)LibraryFinder.pathStatus(srgMcPath));
        LOGGER.debug(LogMarkers.CORE, "MC Extras at {} is {}", (Object)mcExtrasPath.toString(), (Object)LibraryFinder.pathStatus(mcExtrasPath));
        LOGGER.debug(LogMarkers.CORE, "Forge patches at {} is {}", (Object)patchedBinariesPath.toString(), (Object)LibraryFinder.pathStatus(patchedBinariesPath));
        return new Path[]{patchedBinariesPath, mcExtrasPath, srgMcPath};
    }

    public static Path findPathForMaven(String group, String artifact, String extension, String classifier, String version) {
        return LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(group, artifact, extension, classifier, version));
    }

    public static Path findPathForMaven(String maven) {
        return LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(maven));
    }
}

