/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import org.berezka.berezka_api.Berezka_api;

public class BerezkaConfig {
    public String path = "";
    private static ConcurrentHashMap<String, Object> configValues = new ConcurrentHashMap();
    public String fileExtension = ".toml";

    public BerezkaConfig() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        this.path = String.valueOf(gameDir.resolve("config"));
        if (Berezka_api.debugMode.booleanValue()) {
            Berezka_api.LOGGER.info("[Berezka API] initializing config. data:{gameDir:%s, path:%s}".formatted(gameDir, this.path));
        }
    }

    public Object getValue(String key) {
        return configValues.getOrDefault(key, "404");
    }

    public boolean doesConfigExist(String fileName) {
        Path configPath = Paths.get(this.path + "/" + fileName + this.fileExtension, new String[0]);
        return Files.exists(configPath, new LinkOption[0]);
    }

    public void createConfig(String fileName, String data) {
        this.createFile(fileName, data);
    }

    public void readConfig(String name, String modId) {
        String strConfig = this.readFile(name);
        if (Berezka_api.debugMode.booleanValue()) {
            Berezka_api.LOGGER.info("[Berezka API] reading config: %s".formatted(strConfig));
        }
        for (String line : strConfig.split("\n")) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split("=");
            if (Berezka_api.debugMode.booleanValue()) {
                Berezka_api.LOGGER.info("[Berezka API] reading line. data:{count:%s, parts:%s, line:%s}".formatted(parts.length, parts, line));
            }
            if (parts.length > 1) {
                String key = "%s:%s".formatted(modId, parts[0]).replaceAll(" ", "");
                String value = parts[1].replaceFirst(" ", "");
                configValues.put(key, value);
                continue;
            }
            Berezka_api.LOGGER.warn("[Berezka API] skipping line: %s".formatted(line));
        }
        if (Berezka_api.debugMode.booleanValue()) {
            Berezka_api.LOGGER.info("[Berezka API] new configValues: %s".formatted(configValues));
        }
    }

    private File createFile(String fileName, String data) {
        File file = new File(this.path, fileName + this.fileExtension);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException("[Berezka API] failed to create File.");
        }
        if (Berezka_api.debugMode.booleanValue()) {
            Berezka_api.LOGGER.info("[Berezka API] created file. data:{path:%s}".formatted(file.getAbsolutePath()));
        }
        return file;
    }

    public String readFile(String fileName) {
        Path configPath = Paths.get(this.path + "/" + fileName + this.fileExtension, new String[0]);
        if (Berezka_api.debugMode.booleanValue()) {
            Berezka_api.LOGGER.info("[Berezka API] trying to read config. data:{configPath:%s}".formatted(configPath));
        }
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                return Files.readString(configPath);
            }
            catch (IOException e) {
                throw new RuntimeException("[Berezka API] error while reading config. data:{path:%s}".formatted(configPath));
            }
        }
        throw new RuntimeException("[Berezka API] error while searching config. data:{path:%s}".formatted(configPath));
    }

    public void addContentToConfig(String fileName, String data) {
        String originalConfig = this.readFile(fileName);
        String newConfig = originalConfig + data;
        if (Berezka_api.debugMode.booleanValue()) {
            Berezka_api.LOGGER.info("[Berezka API] updating config. data:{original:\n%s\nnew:\n%s}".formatted(originalConfig, newConfig));
        }
        this.createFile(fileName, newConfig);
    }

    public void loadConfig(String fileName, String modId, String data, HashMap<String, List<Object>> defaultConfigVariables) {
        boolean configExist = this.doesConfigExist(fileName);
        if (configExist) {
            this.readConfig(fileName, modId);
            String dataToAdd = "";
            for (String variable : defaultConfigVariables.keySet()) {
                if (!this.getValue(modId + ":" + variable).equals("404")) continue;
                List<Object> _default = defaultConfigVariables.get(variable);
                String description = _default.get(0).toString();
                String defaultValue = _default.get(1).toString();
                if (Berezka_api.debugMode.booleanValue()) {
                    Berezka_api.LOGGER.info("[Berezka API] variable %s was not found, adding... (data:{default:%s, description:%s})".formatted(variable, defaultValue, description));
                }
                dataToAdd = "%s#%s \n%s = %s \n".formatted(dataToAdd, description, variable, defaultValue);
            }
            this.addContentToConfig(fileName, dataToAdd);
        } else {
            this.createConfig(fileName, data);
            this.readConfig(fileName, modId);
        }
    }

    public List<String> strToList(String value) {
        value = value.replaceFirst("]", "").substring(1);
        return List.of(value.split(", "));
    }

    public boolean strToBool(String value) {
        return value.equals("true") || value.equals("True");
    }
}

