/*
 * Decompiled with CFR 0.152.
 */
package com.daniking.backtools;

import com.daniking.backtools.BackTools;
import com.daniking.backtools.ClientSetup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1819;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ConfigHandler {
    private static final HashMap<Class<?>, Integer> TOOL_ORIENTATIONS = new HashMap();
    private static final HashSet<class_2960> ENABLED_TOOLS = new HashSet();
    private static final Set<class_2960> DISABLED_TOOLS = new HashSet<class_2960>();
    private static boolean HELICOPTER_MODE = false;
    public static final HashSet<class_2960> BELT_TOOLS = new HashSet();

    public static int getToolOrientation(@NotNull class_1792 item) {
        return ConfigHandler.getToolOrientation(item.getClass());
    }

    public static int getToolOrientation(@NotNull Class<?> object) {
        if (object.equals(class_1792.class)) {
            return 0;
        }
        if (!TOOL_ORIENTATIONS.containsKey(object)) {
            TOOL_ORIENTATIONS.put(object, ConfigHandler.getToolOrientation(object.getSuperclass()));
        }
        return TOOL_ORIENTATIONS.get(object);
    }

    public static boolean isItemEnabled(class_1792 item) {
        class_2960 registryName = new class_2960(class_7923.field_41178.method_10221((Object)item).method_12836(), item.toString());
        if (!ENABLED_TOOLS.isEmpty()) {
            return ENABLED_TOOLS.contains(registryName);
        }
        if (DISABLED_TOOLS.contains(registryName)) {
            return false;
        }
        return item instanceof class_1766 || item instanceof class_1829 || item instanceof class_1819 || item instanceof class_1835 || item instanceof class_1753 || item instanceof class_1820 || item instanceof class_1764 || item instanceof class_1787;
    }

    public static boolean isBeltTool(class_1792 item) {
        class_2960 itemId = new class_2960(class_7923.field_41178.method_10221((Object)item).method_12836(), item.toString());
        ClientSetup.config.beltTools.forEach(beltTool -> BELT_TOOLS.add(new class_2960(beltTool)));
        return BELT_TOOLS.contains(itemId);
    }

    public static void init() {
        ENABLED_TOOLS.clear();
        ClientSetup.config.enabledTools.forEach(enabledTool -> ENABLED_TOOLS.add(new class_2960(enabledTool)));
        if (ENABLED_TOOLS.isEmpty()) {
            DISABLED_TOOLS.clear();
            ClientSetup.config.disabledTools.forEach(disabledTool -> DISABLED_TOOLS.add(new class_2960(disabledTool)));
        }
        ConfigHandler.parseOrientation();
        HELICOPTER_MODE = ClientSetup.config.helicopterMode;
    }

    private static void parseOrientation() {
        TOOL_ORIENTATIONS.clear();
        MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
        for (String configText : ClientSetup.config.toolOrientation) {
            String[] split = new String[2];
            int i = configText.indexOf(58);
            if (i == -1) {
                BackTools.LOGGER.error("[CONFIG_FILE]: Tool orientation class file and degrees must be separated with \":\"!");
            } else {
                split[0] = configText.substring(0, i);
                split[1] = configText.substring(i + 1);
            }
            Class<?> path = null;
            for (String namespace : resolver.getNamespaces()) {
                try {
                    path = Class.forName(resolver.unmapClassName(namespace, split[0]));
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (path != null) {
                try {
                    if (class_1792.class.isAssignableFrom(path)) {
                        TOOL_ORIENTATIONS.put(path, Integer.parseInt(split[1]));
                        continue;
                    }
                    BackTools.LOGGER.error("[CONFIG_FILE]: Invalid Tool class file: {}", (Object)split[0]);
                }
                catch (NumberFormatException e) {
                    BackTools.LOGGER.error("[CONFIG_FILE]: Could not parse text: {}", (Object)configText);
                }
                continue;
            }
            BackTools.LOGGER.error("[CONFIG_FILE]: Could not find class to add orientation: {}", (Object)split[0]);
        }
    }

    public static boolean isHelicopterModeOn() {
        return HELICOPTER_MODE;
    }
}

