/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.vines.AdjustableUtil;
import net.diebuddies.physics.vines.DoorSetting;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.HangingSignSetting;
import net.diebuddies.physics.vines.TrapdoorSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSetting;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import org.joml.Vector3f;

public final class ConfigVines {
    private static final String DIR = "config/physicsmod";
    private static final String CONFIG = "physics_vines_client_config.json";
    public static Map<class_2248, DynamicSetting> configSettings;

    public static void loadDefaultConfigSettings() {
        configSettings.clear();
        configSettings.put(class_2246.field_23078, new VineSetting(true, true, false, new Vector3f(1.0f), 2400.0f, 10.0f, true, class_2246.field_23079));
        configSettings.put(class_2246.field_9993, new VineSetting(true, false, false, new Vector3f(1.0f), 45.0f, 45.0f, true, class_2246.field_10463));
        configSettings.put(class_2246.field_22123, new VineSetting(false, false, false, new Vector3f(1.0f), 45.0f, 45.0f, true, class_2246.field_22124));
        configSettings.put(class_2246.field_28675, new VineSetting(false, false, false, new Vector3f(1.0f), 45.0f, 45.0f, true, class_2246.field_28676));
        configSettings.put(class_2246.field_10424, new VineSetting(true, true, false, new Vector3f(1.0f), 2300.0f, 90.0f, true, null));
        configSettings.put(class_2246.field_10597, new VineSetting(false, false, true, new Vector3f(1.0f), 45.0f, 45.0f, true, null));
        configSettings.put(class_2246.field_23985, new VineSetting(false, false, true, new Vector3f(1.5f, 1.0f, 1.5f), 60.0f, 40.0f, true, null));
        configSettings.put(class_2246.field_10430, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        configSettings.put(class_2246.field_10214, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        configSettings.put(class_2246.field_10313, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        configSettings.put(class_2246.field_10003, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        configSettings.put(class_2246.field_10378, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        configSettings.put(class_2246.field_10583, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        configSettings.put(class_2246.field_10238, new VineSetting(true, false, false, new Vector3f(1.0f), 110.0f, 48.0f, true, null));
        float scale = 0.85f;
        float stiffness = 1580.0f;
        float damping = 8.0f;
        configSettings.put(class_2246.field_10137, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10608, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10486, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10246, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10453, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10017, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10323, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_22095, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_22094, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_40285, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_37555, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_42740, new TrapdoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10149, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10232, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10352, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10403, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_9973, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10627, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_10521, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_22103, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_22102, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_40291, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_37566, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_42748, new DoorSetting(new Vector3f(scale), stiffness, damping, true, true));
        configSettings.put(class_2246.field_40262, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40265, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40264, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40267, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40266, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40263, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40269, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40268, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40271, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_40270, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
        configSettings.put(class_2246.field_42738, new HangingSignSetting(new Vector3f(0.9f, 0.9f, 0.9f), 45.0f, 45.0f, true));
    }

    public static void init() {
    }

    private static JsonObject createConfig() {
        JsonObject config = new JsonObject();
        JsonArray array = new JsonArray();
        for (Map.Entry<class_2248, DynamicSetting> entry : configSettings.entrySet()) {
            String id = PhysicsMod.registeredBlocks.get(entry.getKey());
            if (id == null) continue;
            JsonObject obj = new JsonObject();
            obj.add("blockID", (JsonElement)new JsonPrimitive(id));
            DynamicSetting setting = entry.getValue();
            AdjustableUtil.writeDynamicSetting(obj, setting);
            array.add((JsonElement)obj);
        }
        config.add("customizedDynamicBlocks", (JsonElement)array);
        return config;
    }

    public static void resetVines() {
        ConfigVines.loadDefaultConfigSettings();
        VineHelper.initFromConfigSettings();
        ConfigVines.save();
    }

    public static void save() {
        File configFile;
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((configFile = new File("config/physicsmod/physics_vines_client_config.json")).exists()) {
            configFile.delete();
        }
        JsonObject config = ConfigVines.createConfig();
        try {
            configFile.createNewFile();
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        File configFile;
        configSettings = new Object2ObjectOpenHashMap();
        ConfigVines.loadDefaultConfigSettings();
        JsonObject config = ConfigVines.createConfig();
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(configFile = new File("config/physicsmod/physics_vines_client_config.json")).exists()) {
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Gson gson = new Gson();
            try {
                config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            configSettings.clear();
            JsonArray array = config.get("customizedDynamicBlocks").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                class_2248 block = PhysicsMod.invRegisteredBlocks.get(obj.get("blockID").getAsString());
                DynamicSetting setting = AdjustableUtil.readDynamicSetting(obj);
                configSettings.put(block, setting);
            }
        }
        catch (Exception e) {
            ConfigVines.loadDefaultConfigSettings();
            ConfigVines.save();
        }
        VineHelper.initFromConfigSettings();
    }
}

