/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.snow.ChunkEntity;
import net.diebuddies.physics.snow.IChunk;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.render.MainRenderer;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;

public class SnowRenderer {
    public static final int SNOW_ENTITY_ID = 829925;
    private MainRenderer mainRenderer;
    private MultiDrawElementsBaseVertexCommand drawElementsCommand;
    private MultiDrawArraysCommand drawAraysCommands;
    private Matrix4f transformation = new Matrix4f();
    private Matrix4f currentPose = new Matrix4f();
    private Matrix3f tmp = new Matrix3f();

    public SnowRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
        this.drawElementsCommand = new MultiDrawElementsBaseVertexCommand();
        this.drawAraysCommands = new MultiDrawArraysCommand();
    }

    public void render(PhysicsWorld physics, class_638 level, class_4587 matrixStackIn, class_243 view) {
    }

    private void executeDrawCommands() {
        MemoryStack stack;
        int size = this.drawElementsCommand.size();
        if (size > 0) {
            stack = MemoryStack.stackPush();
            try {
                IntBuffer counts = stack.mallocInt(size);
                PointerBuffer pointers = stack.mallocPointer(size);
                IntBuffer baseVertices = stack.mallocInt(size);
                for (int i = 0; i < size; ++i) {
                    counts.put(i, this.drawElementsCommand.getCount(i));
                    pointers.put(i, this.drawElementsCommand.getPointer(i));
                    baseVertices.put(i, this.drawElementsCommand.getBaseVertex(i));
                }
                GL32C.glMultiDrawElementsBaseVertex((int)4, (IntBuffer)counts, (int)5125, (PointerBuffer)pointers, (IntBuffer)baseVertices);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
            this.drawElementsCommand.clear();
        }
        if ((size = this.drawAraysCommands.size()) > 0) {
            stack = MemoryStack.stackPush();
            try {
                IntBuffer firsts = stack.mallocInt(size);
                IntBuffer counts = stack.mallocInt(size);
                for (int i = 0; i < size; ++i) {
                    firsts.put(i, this.drawAraysCommands.getFirst(i));
                    counts.put(i, this.drawAraysCommands.getCount(i));
                }
                GL32C.glMultiDrawArrays((int)4, (IntBuffer)firsts, (IntBuffer)counts);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
            this.drawAraysCommands.clear();
        }
    }

    private void setupMatrices(class_5944 shader, Vector3i position, class_243 view, Matrix4f cameraRotation, Matrix3f normal) {
        float scale = 1.0f / (float)IChunk.CHUNK_MULTIPLE;
        this.transformation.setTranslation((float)(((double)(position.x * IChunk.CHUNK_SIZE) + 0.5) * (double)scale - view.field_1352), (float)(((double)(position.y * IChunk.CHUNK_SIZE) + 0.5) * (double)scale - view.field_1351), (float)(((double)(position.z * IChunk.CHUNK_SIZE) + 0.5) * (double)scale - view.field_1350));
        this.transformation.m00(scale);
        this.transformation.m11(scale);
        this.transformation.m22(scale);
        cameraRotation.mul((Matrix4fc)this.transformation, this.currentPose);
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(this.currentPose);
        } else {
            int location = shader.field_29470.method_35660();
            if (location != -1) {
                GL32C.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)this.currentPose.get(MainRenderer.matrixBuffer));
            }
            if (StarterClient.iris) {
                Iris.setNormalMatrix(shader, this.currentPose, normal);
            }
        }
    }

    private void renderSnow(SnowWorld snowWorld, class_1937 level, Matrix4f cameraRotationMatrix, Matrix3f normalMatrix, class_243 view, ChunkEntity snow) {
        AABB3D modelBoundingBox = snow.aabb;
        Vector3d start = modelBoundingBox.start;
        Vector3d end = modelBoundingBox.end;
        if (!this.mainRenderer.frustumInt.testAab((float)(start.x - view.field_1352), (float)(start.y - view.field_1351), (float)(start.z - view.field_1350), (float)(end.x - view.field_1352), (float)(end.y - view.field_1351), (float)(end.z - view.field_1350))) {
            return;
        }
        if (snowWorld.getSnowIndexData() == null) {
            ArenaBuffer.MemorySegment segment = snow.vertexSegment;
            this.drawAraysCommands.add(segment.offset / snowWorld.format.getStride(), segment.size / snowWorld.format.getStride());
        } else {
            ArenaBuffer.MemorySegment vertexSegment = snow.vertexSegment;
            ArenaBuffer.MemorySegment indexSegment = snow.indexSegment;
            int baseVertex = vertexSegment.offset / snowWorld.format.getStride();
            this.drawElementsCommand.add(indexSegment.size / 4, indexSegment.offset, baseVertex);
        }
    }

    private static class MultiDrawElementsBaseVertexCommand {
        public IntList count = new IntArrayList();
        public LongList pointer = new LongArrayList();
        public IntList baseVertex = new IntArrayList();

        public void add(int count, long pointer, int baseVertex) {
            this.count.add(count);
            this.pointer.add(pointer);
            this.baseVertex.add(baseVertex);
        }

        public int getCount(int index) {
            return this.count.getInt(index);
        }

        public long getPointer(int index) {
            return this.pointer.getLong(index);
        }

        public int getBaseVertex(int index) {
            return this.baseVertex.getInt(index);
        }

        public void clear() {
            this.count.clear();
            this.pointer.clear();
            this.baseVertex.clear();
        }

        public int size() {
            return this.count.size();
        }
    }

    private static class MultiDrawArraysCommand {
        public IntList first = new IntArrayList();
        public IntList count = new IntArrayList();

        public void add(int first, int count) {
            this.first.add(first);
            this.count.add(count);
        }

        public int getFirst(int index) {
            return this.first.getInt(index);
        }

        public int getCount(int index) {
            return this.count.getInt(index);
        }

        public void clear() {
            this.first.clear();
            this.count.clear();
        }

        public int size() {
            return this.count.size();
        }
    }
}

