/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class WarpPlateRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final class_1799 resultItem;
    private final class_1856 primaryIngredient;
    private final class_2371<class_1856> secondaryIngredients;
    private final class_2371<class_1856> combinedIngredients;

    public WarpPlateRecipe(class_2960 id, class_1799 resultItem, class_1856 primaryIngredient, class_2371<class_1856> secondaryIngredients) {
        this.id = id;
        this.resultItem = resultItem;
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredients = secondaryIngredients;
        this.combinedIngredients = class_2371.method_37434((int)5);
        this.combinedIngredients.add((Object)primaryIngredient);
        this.combinedIngredients.addAll(secondaryIngredients);
    }

    public boolean method_8115(class_1263 inventory, class_1937 level) {
        if (!this.primaryIngredient.method_8093(inventory.method_5438(0))) {
            return false;
        }
        class_1662 stackedContents = new class_1662();
        int foundInputs = 0;
        for (int i = 0; i < this.combinedIngredients.size(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            ++foundInputs;
            stackedContents.method_20478(itemStack, 1);
        }
        return foundInputs == this.combinedIngredients.size() && stackedContents.method_7402((class_1860)this, null);
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryAccess) {
        return this.resultItem.method_7972();
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.resultItem;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        return this.combinedIngredients;
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return "warp_plate";
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.warpPlate);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.warpPlateRecipeSerializer;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.warpPlateRecipeType;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    static class Serializer
    implements class_1865<WarpPlateRecipe> {
        Serializer() {
        }

        public WarpPlateRecipe fromJson(class_2960 id, JsonObject jsonObject) {
            class_1856 primaryIngredient = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"primary"));
            class_2371<class_1856> secondaryIngredients = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)jsonObject, (String)"secondary"));
            if (secondaryIngredients.isEmpty()) {
                throw new JsonParseException("No secondary ingredients for warp plate recipe");
            }
            if (secondaryIngredients.size() > 4) {
                throw new JsonParseException("Too many secondary ingredients for shapeless recipe");
            }
            class_1799 resultItem = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new WarpPlateRecipe(id, resultItem, primaryIngredient, secondaryIngredients);
        }

        private static class_2371<class_1856> itemsFromJson(JsonArray jsonArray) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)jsonArray.get(i), (boolean)false);
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        public WarpPlateRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_1799 resultItem = buf.method_10819();
            class_1856 primaryIngredient = class_1856.method_8086((class_2540)buf);
            int secondaryCount = buf.method_10816();
            class_2371 secondaryIngredients = class_2371.method_37434((int)secondaryCount);
            for (int i = 0; i < secondaryCount; ++i) {
                secondaryIngredients.add((Object)class_1856.method_8086((class_2540)buf));
            }
            return new WarpPlateRecipe(id, resultItem, primaryIngredient, (class_2371<class_1856>)secondaryIngredients);
        }

        public void toNetwork(class_2540 buf, WarpPlateRecipe recipe) {
            buf.method_10793(recipe.resultItem);
            recipe.primaryIngredient.method_8088(buf);
            buf.method_10804(recipe.secondaryIngredients.size());
            for (class_1856 ingredient : recipe.secondaryIngredients) {
                ingredient.method_8088(buf);
            }
        }
    }
}

