/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.xso;

import dev.isxander.xso.SodiumBinding;
import dev.isxander.xso.compat.Compat;
import dev.isxander.xso.compat.EntityViewDistanceCompat;
import dev.isxander.xso.compat.IrisCompat;
import dev.isxander.xso.compat.MoreCullingCompat;
import dev.isxander.xso.compat.SodiumExtraCompat;
import dev.isxander.xso.config.XsoConfig;
import dev.isxander.xso.mixins.CyclingControlAccessor;
import dev.isxander.xso.mixins.SliderControlAccessor;
import dev.isxander.xso.utils.ClassCapture;
import dev.isxander.xso.utils.DonationPrompt;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.impl.controller.EnumControllerBuilderImpl;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_403;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7291;

public class XandersSodiumOptions {
    private static boolean errorOccured = false;

    public static class_437 wrapSodiumScreen(SodiumOptionsGUI sodiumOptionsGUI, List<OptionPage> pages, class_437 prevScreen) {
        try {
            YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"Sodium Options"));
            for (OptionPage page : pages) {
                builder.category(XandersSodiumOptions.convertCategory(page, sodiumOptionsGUI));
            }
            builder.category(XsoConfig.getConfigCategory());
            builder.save(() -> {
                HashSet storages = new HashSet();
                pages.stream().flatMap(s -> s.getOptions().stream()).forEach(opt -> storages.add(opt.getStorage()));
                storages.forEach(OptionStorage::save);
                XsoConfig.INSTANCE.save();
            });
            SodiumGameOptions options = SodiumClientMod.options();
            if (!options.notifications.hasSeenDonationPrompt) {
                Instant threshold;
                Instant now;
                HashedFingerprint fingerprint = null;
                try {
                    fingerprint = HashedFingerprint.loadFromDisk();
                }
                catch (Throwable var5) {
                    Throwable t = var5;
                    SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
                }
                if (fingerprint != null && (now = Instant.now()).isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
                    options.notifications.hasSeenDonationPrompt = true;
                    try {
                        SodiumGameOptions.writeToDisk((SodiumGameOptions)options);
                    }
                    catch (IOException var4) {
                        IOException e = var4;
                        SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
                    }
                    return new DonationPrompt(builder.build().generateScreen(prevScreen));
                }
            }
            return builder.build().generateScreen(prevScreen);
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Failed to convert Sodium option screen to YACL with XSO!", e);
            if (((XsoConfig)XsoConfig.INSTANCE.getConfig()).hardCrash) {
                throw exception;
            }
            exception.printStackTrace();
            return new class_403(() -> {
                errorOccured = true;
                class_310.method_1551().method_1507((class_437)sodiumOptionsGUI);
                errorOccured = false;
            }, (class_2561)class_2561.method_43470((String)"Xander's Sodium Options failed"), (class_2561)class_2561.method_43470((String)"Whilst trying to convert Sodium's GUI to YACL with XSO mod, an error occured which prevented the conversion. This is most likely due to a third-party mod adding its own settings to Sodium's screen. XSO will now display the original GUI.\n\nThe error has been logged to latest.log file."), class_5244.field_24338, true);
        }
    }

    private static ConfigCategory convertCategory(OptionPage page, SodiumOptionsGUI sodiumOptionsGUI) {
        try {
            Optional<ConfigCategory> shaderPackPage;
            if (Compat.IRIS && (shaderPackPage = IrisCompat.replaceShaderPackPage(sodiumOptionsGUI, page)).isPresent()) {
                return shaderPackPage.get();
            }
            ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder().name(page.getName());
            for (OptionGroup group : page.getGroups()) {
                categoryBuilder.option((Option)LabelOption.create((class_2561)class_2561.method_43473()));
                for (me.jellysquid.mods.sodium.client.gui.options.Option option : group.getOptions()) {
                    categoryBuilder.option(XandersSodiumOptions.convertOption(option));
                }
            }
            if (Compat.MORE_CULLING) {
                MoreCullingCompat.extendMoreCullingPage(sodiumOptionsGUI, page, categoryBuilder);
            }
            return categoryBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert Sodium option page named '" + page.getName().getString() + "' to YACL config category.", e);
        }
    }

    private static <T> Option<?> convertOption(me.jellysquid.mods.sodium.client.gui.options.Option<T> sodiumOption) {
        try {
            Optional<Option<?>> fakeOption;
            if (sodiumOption.getName().method_44745(class_2561.method_30163((String)"Fullscreen Resolution"))) {
                System.out.println("debug");
            }
            if (Compat.ENTITY_VIEW_DIST && (fakeOption = EntityViewDistanceCompat.convertFakeOption(sodiumOption)).isPresent()) {
                return fakeOption.get();
            }
            if (!(sodiumOption instanceof ClassCapture)) {
                throw new IllegalStateException("Failed to capture class of sodium option! Likely due to custom Option implementation.");
            }
            class_5250 descText = sodiumOption.getTooltip().method_27661();
            Option.Builder builder = Option.createBuilder(((ClassCapture)sodiumOption).getCapturedClass()).name(sodiumOption.getName()).flags(XandersSodiumOptions.convertFlags(sodiumOption)).binding((Binding)(Compat.MORE_CULLING ? MoreCullingCompat.getBinding(sodiumOption) : new SodiumBinding(sodiumOption))).available(sodiumOption.isAvailable());
            if (sodiumOption.getImpact() != null) {
                descText = descText.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"sodium.options.performance_impact_string", (Object[])new Object[]{sodiumOption.getImpact().getLocalizedName()}).method_27692(class_124.field_1080));
            }
            builder.description(OptionDescription.of((class_2561[])new class_2561[]{descText}));
            XandersSodiumOptions.addController(builder, sodiumOption);
            Option built = builder.build();
            if (Compat.MORE_CULLING) {
                MoreCullingCompat.addAvailableCheck(built, sodiumOption);
            }
            return built;
        }
        catch (Exception e) {
            if (((XsoConfig)XsoConfig.INSTANCE.getConfig()).lenientOptions) {
                System.out.println("Failed: " + sodiumOption.getName().getString());
                e.printStackTrace();
                return ButtonOption.createBuilder().name(sodiumOption.getName()).description(OptionDescription.of((class_2561[])new class_2561[]{sodiumOption.getTooltip(), class_2561.method_43471((String)"xso.incompatible.tooltip").method_27692(class_124.field_1061)})).available(false).text((class_2561)class_2561.method_43471((String)"xso.incompatible.button").method_27692(class_124.field_1061)).action((screen, opt) -> {}).build();
            }
            throw new IllegalStateException("Failed to convert Sodium option named '" + sodiumOption.getName().getString() + "' to a YACL option!", e);
        }
    }

    private static <T> void addController(Option.Builder yaclOption, me.jellysquid.mods.sodium.client.gui.options.Option<T> sodiumOption) {
        Enum[] allowedValues;
        if (sodiumOption.getControl() instanceof TickBoxControl) {
            yaclOption.controller(opt -> TickBoxControllerBuilder.create((Option)((Option)opt)));
            return;
        }
        Control control = sodiumOption.getControl();
        if (control instanceof CyclingControl) {
            CyclingControl cyclingControl = (CyclingControl)control;
            allowedValues = ((CyclingControlAccessor)cyclingControl).getAllowedValues();
            Class<?> arrType = allowedValues.getClass().getComponentType();
            yaclOption.controller(opt -> new EnumControllerBuilderImpl((Option)opt).formatValue(value -> {
                if (value instanceof TextProvider) {
                    TextProvider textProvider = (TextProvider)value;
                    return textProvider.getLocalizedName();
                }
                if (value instanceof class_7291) {
                    class_7291 translatableOption = (class_7291)value;
                    return translatableOption.method_42627();
                }
                return class_2561.method_30163((String)((Enum)value).name());
            }).enumClass(arrType));
            return;
        }
        allowedValues = sodiumOption.getControl();
        if (allowedValues instanceof SliderControl) {
            SliderControl sliderControl = (SliderControl)allowedValues;
            SliderControlAccessor accessor = (SliderControlAccessor)sliderControl;
            yaclOption.controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)((Option)opt)).step((Number)accessor.getInterval())).range((Number)accessor.getMin(), (Number)accessor.getMax())).formatValue(value -> accessor.getMode().format(value.intValue())));
            return;
        }
        if (Compat.SODIUM_EXTRA && SodiumExtraCompat.convertControl(yaclOption, sodiumOption)) {
            return;
        }
        if (Compat.MORE_CULLING && MoreCullingCompat.convertControl(yaclOption, sodiumOption)) {
            return;
        }
        throw new IllegalStateException("Unsupported Sodium Controller: " + sodiumOption.getControl().getClass().getName());
    }

    private static List<dev.isxander.yacl3.api.OptionFlag> convertFlags(me.jellysquid.mods.sodium.client.gui.options.Option<?> sodiumOption) {
        ArrayList<dev.isxander.yacl3.api.OptionFlag> flags = new ArrayList<dev.isxander.yacl3.api.OptionFlag>();
        if (sodiumOption.getFlags().contains(OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            flags.add(dev.isxander.yacl3.api.OptionFlag.RELOAD_CHUNKS);
        } else if (sodiumOption.getFlags().contains(OptionFlag.REQUIRES_RENDERER_UPDATE)) {
            flags.add(dev.isxander.yacl3.api.OptionFlag.WORLD_RENDER_UPDATE);
        }
        if (sodiumOption.getFlags().contains(OptionFlag.REQUIRES_ASSET_RELOAD)) {
            flags.add(dev.isxander.yacl3.api.OptionFlag.ASSET_RELOAD);
        }
        if (sodiumOption.getFlags().contains(OptionFlag.REQUIRES_GAME_RESTART)) {
            flags.add(dev.isxander.yacl3.api.OptionFlag.GAME_RESTART);
        }
        return flags;
    }

    public static boolean shouldConvertGui() {
        return ((XsoConfig)XsoConfig.INSTANCE.getConfig()).enabled && !errorOccured;
    }
}

