/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.utils.IntelCorruptedProcessorChecker;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class IntelChipBugWarning {
    public static String microcodeVertionString = "UNDEFINED";
    public static long microcodeVersion = -1L;
    public static final long FIRST_NOT_AFFECTED_MICROCODE_VERSION = Long.parseLong("129", 16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showIfAffected(boolean debug) {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            if (!CrashAssistantConfig.getBoolean((String)"intel_corrupted.enabled")) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (!IntelCorruptedProcessorChecker.isAffectedProcessor() && !debug) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            IntelChipBugWarning.parseMicrocodeVersion();
            if (Objects.equals(CrashAssistantLocalConfig.get((String)"intel_corrupted.dont_show_again"), true)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            CrashAssistantApp.LOGGER.info("Showing IntelChipBugWarning");
            ControlPanel.stopMovingToTop = true;
            JDialog dialog = new JDialog((Frame)null, LanguageProvider.get((String)"gui.intel_corrupted_title"), true);
            dialog.setDefaultCloseOperation(2);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(3, 3, 3, 3);
            int colIndex = 0;
            HashMap<String, String> replacements = new HashMap<String, String>(){
                {
                    this.put("$LINK.INTEL_CHIP_BUG_FAQ$", "FAQ");
                }
            };
            String warningText = LanguageProvider.get((String)"gui.intel_corrupted_msg", (HashMap)replacements);
            Object microcodeText = "";
            if (microcodeVersion != -1L) {
                boolean isAffected = microcodeVersion < FIRST_NOT_AFFECTED_MICROCODE_VERSION;
                microcodeText = !isAffected ? "\n\n<span style='background-color:#EEFFEE;color:#006600;'>" + LanguageProvider.get((String)"gui.intel_corrupted_microcode_good", (HashMap)replacements) + "</span>" : "\n\n<span style='background-color:#FFEEEE;color:#990000;'>" + LanguageProvider.get((String)"gui.intel_corrupted_microcode_bad", (HashMap)replacements) + "</span>";
                microcodeText = ((String)microcodeText).replace("$MICROCODE_VERSION_CURRENT$", "<strong style='color: " + (isAffected ? "red" : "green") + ";'>" + microcodeVertionString + "</strong>");
                microcodeText = ((String)microcodeText).replace("$MICROCODE_VERSION_FIXED$", "<strong style='color: green;'>0x" + Long.toHexString(FIRST_NOT_AFFECTED_MICROCODE_VERSION) + "</strong>");
            }
            warningText = warningText.replace("$CURRENT_MICROCODE_TEXT$", (CharSequence)microcodeText);
            JEditorPane textPane = CrashAssistantGUI.getEditorPane(warningText, true, 600);
            JScrollPane scrollPane = new JScrollPane(textPane);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            gbc.gridx = colIndex;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            mainPanel.add((Component)scrollPane, gbc);
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
            JButton readMoreButton = new JButton(LanguageProvider.get((String)"gui.intel_corrupted_read_more"));
            readMoreButton.addActionListener(e -> {
                try {
                    Desktop.getDesktop().browse(new URI(LinksProvider.INTEL_CHIP_BUG_FAQ.getLink()));
                }
                catch (Exception ex) {
                    CrashAssistantApp.LOGGER.error("Error opening URL: ", (Throwable)ex);
                }
            });
            JButton okButton = new JButton("OK");
            okButton.addActionListener(e -> dialog.dispose());
            buttonPanel.add(readMoreButton);
            buttonPanel.add(okButton);
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.add((Component)buttonPanel, "Center");
            JCheckBox dontShowAgainCheck = new JCheckBox(LanguageProvider.get((String)"gui.intel_corrupted_dont_show_again"));
            dontShowAgainCheck.addActionListener(e -> CrashAssistantLocalConfig.set((String)"intel_corrupted.dont_show_again", (Object)dontShowAgainCheck.isSelected()));
            bottomPanel.add((Component)dontShowAgainCheck, "West");
            gbc.gridx = colIndex;
            gbc.gridy = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 10;
            mainPanel.add((Component)bottomPanel, gbc);
            dialog.setContentPane(mainPanel);
            dialog.pack();
            dialog.setSize(dialog.getPreferredSize().width, dialog.getPreferredSize().height);
            dialog.setLocationRelativeTo(null);
            if (debug) {
                dialog.setAlwaysOnTop(true);
            }
            dialog.setVisible(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            CrashAssistantApp.LOGGER.info("Shown IntelChipBugWarning");
            return;
        }
    }

    public static void parseMicrocodeVersion() {
        try {
            long rev;
            if (!PlatformHelp.isWindows()) {
                return;
            }
            byte[] cur = Advapi32Util.registryGetBinaryValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", (String)"Update Revision");
            if (cur == null || cur.length < 4) {
                throw new IllegalStateException("Update Revision missing/too short");
            }
            CrashAssistantApp.LOGGER.info("Update Revision bytes: {}", (Object)IntStream.range(0, cur.length).mapToObj(i -> String.format("%02X", cur[i] & 0xFF)).collect(Collectors.joining(" ")));
            ByteBuffer bb = ByteBuffer.wrap(cur).order(ByteOrder.LITTLE_ENDIAN);
            long d0 = (long)bb.getInt(0) & 0xFFFFFFFFL;
            long d1 = cur.length >= 8 ? (long)bb.getInt(4) & 0xFFFFFFFFL : 0L;
            long l = rev = d0 != 0L ? d0 : d1;
            if (rev == 0L) {
                microcodeVersion = -1L;
                microcodeVertionString = "UNKNOWN";
                CrashAssistantApp.LOGGER.warn("Microcode revision unreadable (both DWORDs zero).");
                return;
            }
            microcodeVersion = rev;
            microcodeVertionString = String.format("0x%X", microcodeVersion);
            CrashAssistantApp.LOGGER.info("Microcode version: " + microcodeVertionString);
        }
        catch (Throwable e) {
            microcodeVersion = -1L;
            microcodeVertionString = "ERROR - FAILED TO GET MICROCODE";
            CrashAssistantApp.LOGGER.error("Error getting microcode version: ", e);
        }
    }

    public static void main(String[] args) {
        IntelChipBugWarning.showIfAffected(true);
    }
}

