/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis.gml;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.AnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;

public class GroovyModLoaderAutoFixGUI
extends AnalysisGUIBase {
    private static final Map<String, String> MCP_MAPPINGS = new HashMap<String, String>(){
        {
            this.put("1.20.1", "20230612.114412");
            this.put("1.19.4", "20230314.122934");
            this.put("1.19.3", "20221207.122022");
            this.put("1.19.2", "20220805.130853");
        }
    };

    public GroovyModLoaderAutoFixGUI(JFrame parent) {
        super(parent, LanguageProvider.get((String)"gui.analysis.gml_autofix.title"), LanguageProvider.get((String)"gui.analysis.gml_autofix.header"));
    }

    @Override
    protected void performAnalysis() {
        try {
            SwingUtilities.invokeLater(() -> {
                this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.gml_autofix.status.starting"));
                this.progressBar.setIndeterminate(true);
            });
            String mcVersion = PlatformHelp.minecraftVersion;
            String mcpVersion = MCP_MAPPINGS.get(mcVersion);
            if (mcpVersion == null) {
                SwingUtilities.invokeLater(() -> {
                    JOptionPane.showMessageDialog(this.dialog, CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.analysis.gml_autofix.unsupported_version_error"), true), LanguageProvider.get((String)"gui.error"), 0);
                    this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.gml_autofix.status.failed"));
                    this.progressBar.setIndeterminate(false);
                });
                return;
            }
            SwingUtilities.invokeLater(() -> this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.gml_autofix.status.cleaning_cache")));
            this.appendStyledText("Cleaning old GML cache...\n", NORMAL_COLOR);
            File gmlFolder = new File("mod_data/gml");
            if (gmlFolder.exists()) {
                FileUtils.deleteDirectory((File)gmlFolder);
                this.appendStyledText("Old GML cache folder deleted.\n", NORMAL_COLOR);
                CrashAssistantApp.LOGGER.info("Old GML cache folder deleted.");
            } else {
                this.appendStyledText("No old GML cache folder found to delete.\n", NORMAL_COLOR);
            }
            SwingUtilities.invokeLater(() -> this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.gml_autofix.status.downloading")));
            this.appendStyledText("Starting mapping downloader for Minecraft " + mcVersion + " with MCP " + mcpVersion + "\n", NORMAL_COLOR);
            CrashAssistantApp.LOGGER.info("Starting mapping downloader for Minecraft {} with MCP {}", (Object)mcVersion, (Object)mcpVersion);
            String classpath = System.getProperty("java.class.path");
            ProcessBuilder pb = new ProcessBuilder(JavaBinaryLocator.getJavaBinary(), "-Djava.net.preferIPv4Stack=true", "-cp", classpath, "dev.kostromdan.mods.crash_assistant.app.gui.analysis.gml.GMLMappingDownloaderImpl", mcVersion, mcpVersion);
            Process process = pb.start();
            runningProcesses.add(process);
            CompletableFuture<Void> stdOutFuture = CompletableFuture.runAsync(() -> {
                block8: {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String finalLine = line;
                            SwingUtilities.invokeLater(() -> this.appendStyledText(finalLine + "\n", NORMAL_COLOR));
                        }
                    }
                    catch (Exception e) {
                        if (isCancelled) break block8;
                        CrashAssistantApp.LOGGER.error("Error reading stdout from downloader", (Throwable)e);
                    }
                }
            }, executor);
            CompletableFuture<Void> stdErrFuture = CompletableFuture.runAsync(() -> {
                block8: {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String finalLine = line;
                            SwingUtilities.invokeLater(() -> this.appendStyledText(finalLine + "\n", ERROR_COLOR));
                        }
                    }
                    catch (Exception e) {
                        if (isCancelled) break block8;
                        CrashAssistantApp.LOGGER.error("Error reading stderr from downloader", (Throwable)e);
                    }
                }
            }, executor);
            CompletableFuture.allOf(stdOutFuture, stdErrFuture).join();
            int exitCode = process.waitFor();
            runningProcesses.remove(process);
            if (isCancelled) {
                this.appendStyledText("\nAnalysis cancelled by user.\n", ERROR_COLOR);
                return;
            }
            if (exitCode != 0) {
                throw new RuntimeException("Mapping downloader process exited with code: " + exitCode);
            }
            this.appendStyledText("\nGML mapping download completed successfully.\n", MOD_COLOR);
            CrashAssistantApp.LOGGER.info("GML mapping download completed successfully.");
            SwingUtilities.invokeLater(() -> {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(100);
                this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.gml_autofix.status.success"));
                JOptionPane.showMessageDialog(this.dialog, CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.analysis.gml_autofix.success_message"), true), LanguageProvider.get((String)"gui.success"), 1);
                this.dialog.dispose();
            });
        }
        catch (Exception e) {
            if (isCancelled) {
                return;
            }
            CrashAssistantApp.LOGGER.error("GML AutoFix failed", (Throwable)e);
            this.appendStyledText("\nError during AutoFix: " + e.getMessage() + "\n", ERROR_COLOR);
            SwingUtilities.invokeLater(() -> {
                this.progressBar.setIndeterminate(false);
                this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.gml_autofix.status.failed"));
                String failureMessage = LanguageProvider.get((String)"gui.analysis.gml_autofix.failure_message") + "\n" + e.getMessage();
                JOptionPane.showMessageDialog(this.dialog, CrashAssistantGUI.getEditorPane(failureMessage, true), LanguageProvider.get((String)"gui.error"), 0);
            });
        }
    }

    public static void main(String[] args) {
        PlatformHelp.minecraftVersion = "1.20.1";
        SwingUtilities.invokeLater(() -> {
            JFrame testFrame = new JFrame("Test Frame");
            testFrame.setDefaultCloseOperation(3);
            testFrame.setSize(100, 100);
            testFrame.setLocationRelativeTo(null);
            new GroovyModLoaderAutoFixGUI(testFrame).start();
        });
    }
}

