/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.hs_err_parser.HsErrParser;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.VersionUtils;

public class JavaTooHigh
extends KnownCrashReason {
    public JavaTooHigh() {
        super(LogType.HS_ERR, LanguageProvider.get((String)"warnings.java_too_high").replace("$JAVA_VERSION$", PlatformHelp.javaVersion), new String[0]);
    }

    @Override
    public boolean matches(Log log) {
        if (PlatformHelp.isWindows()) {
            return false;
        }
        if (!VersionUtils.isGreaterThanOrEqual((String)PlatformHelp.javaVersion, (String)"22.0.0")) {
            return false;
        }
        return HsErrParser.hsErrContainsAllOfFrames(log, "spark-", "libasyncProfiler.so.tmp");
    }
}

