/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.hs_err;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.hs_err_parser.HsErrParser;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.VersionUtils;
import java.util.HashMap;

public class Jvm
extends KnownCrashReason {
    public Jvm() {
        super(LogType.HS_ERR, LanguageProvider.get((String)"warnings.jvm", (HashMap)new HashMap<String, String>(){
            {
                this.put("$LINK.RESULTS_OF_MEMORY_DIAGNOSTICS$", LanguageProvider.get((String)"warnings_common.instruction"));
            }
        }).replace("$HALF_OF_PROCESSORS$", String.valueOf(Runtime.getRuntime().availableProcessors() / 2)), new String[0]);
        this.conflictingReasons.add("AlLibAlcCleanup");
    }

    @Override
    public boolean matches(Log log) {
        if (!PlatformHelp.isWindows()) {
            return false;
        }
        if (!HsErrParser.hsErrContainsOneOfFrames(log, "jvm.dll")) {
            return false;
        }
        Object additionalInfo = "";
        if (VersionUtils.inRange((String)PlatformHelp.javaVersion, (String)"17.0.7", (String)"17.0.9")) {
            additionalInfo = (String)additionalInfo + LanguageProvider.get((String)"warnings.jvm.17_0_8", (HashMap)new HashMap<String, String>(){
                {
                    this.put("$LINK.ATL$", "ATLauncher");
                    this.put("$LINK.ADOPTIUM_JDK$", LanguageProvider.get((String)"warnings_common.here"));
                }
            });
        }
        if (!((String)additionalInfo).isEmpty()) {
            additionalInfo = "<span style=\"color:green\">" + (String)additionalInfo + "</span>\n";
        }
        this.message = this.message.replace("$FIRST_PRIORITY_WARNINGS$", (CharSequence)additionalInfo);
        return true;
    }
}

