/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.LogAnalysisResponse;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.McLogsAntiVersionCensorer;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.Problem;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.UploadLogResponse;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.UploadingApi;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ErrorUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class McLogsApi
implements UploadingApi {
    private static final String API_BASE_URL = "https://api.mclo.gs/1/";
    private static final String USER_AGENT = "CrashAssistant";
    private static final Gson GSON = new Gson();
    private final String userAgent;

    public McLogsApi() {
        this(USER_AGENT);
    }

    public McLogsApi(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public CompletableFuture<UploadLogResponse> uploadLog(String text, Consumer<Integer> onProgressChanged) {
        String finalText = text.isEmpty() ? "Log is empty." : McLogsAntiVersionCensorer.apply(text);
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (onProgressChanged != null) {
                    onProgressChanged.accept(0);
                }
                URL url = new URL("https://api.mclo.gs/1/log");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setDoOutput(true);
                String content = "content=" + URLEncoder.encode(finalText, StandardCharsets.UTF_8.name());
                byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
                int totalBytes = contentBytes.length;
                connection.setRequestProperty("Content-Length", String.valueOf(totalBytes));
                if (onProgressChanged != null) {
                    onProgressChanged.accept(0);
                }
                try (OutputStream os = connection.getOutputStream();){
                    int chunkSize;
                    int MIN_CHUNK = 4096;
                    int MAX_CHUNK = 65536;
                    int bytesPerPercent = (int)Math.ceil((double)totalBytes / 100.0);
                    for (chunkSize = Integer.highestOneBit(bytesPerPercent); chunkSize > bytesPerPercent && chunkSize > 4096; chunkSize >>= 1) {
                    }
                    chunkSize = Math.max(4096, Math.min(65536, chunkSize));
                    int bytesWritten = 0;
                    int lastPercent = 0;
                    while (bytesWritten < totalBytes) {
                        int len = Math.min(chunkSize, totalBytes - bytesWritten);
                        os.write(contentBytes, bytesWritten, len);
                        int percent = (int)((long)(bytesWritten += len) * 100L / (long)totalBytes);
                        if (percent <= lastPercent || onProgressChanged == null) continue;
                        onProgressChanged.accept(percent);
                        lastPercent = percent;
                    }
                    os.flush();
                }
                int responseCode = connection.getResponseCode();
                if (onProgressChanged != null) {
                    onProgressChanged.accept(100);
                }
                if (responseCode == 200) {
                    StringBuilder responseBody = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            responseBody.append(line);
                        }
                    }
                    JsonObject jsonResponse = JsonParser.parseString((String)responseBody.toString()).getAsJsonObject();
                    if (jsonResponse.get("success").getAsBoolean()) {
                        String id = jsonResponse.get("id").getAsString();
                        String responseUrl = jsonResponse.get("url").getAsString();
                        String rawUrl = jsonResponse.get("raw").getAsString();
                        return new UploadLogResponse(responseUrl, rawUrl, id);
                    }
                    String error = jsonResponse.get("error").getAsString();
                    return new UploadLogResponse(error);
                }
                return new UploadLogResponse("HTTP error: " + responseCode);
            }
            catch (Exception e) {
                return new UploadLogResponse("Error while uploading log to mclo.gs:\n" + ErrorUtils.getErrorMessageAndStackTrace((Throwable)e));
            }
        });
    }

    @Override
    public CompletableFuture<UploadLogResponse> uploadLog(String text) {
        return this.uploadLog(text, null);
    }

    @Override
    public CompletableFuture<LogAnalysisResponse> getProblemsAnalysis(String logUrl) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Pattern pattern = Pattern.compile("https://mclo\\.gs/([A-Za-z0-9]+)");
                Matcher matcher = pattern.matcher(logUrl);
                if (!matcher.find()) {
                    return new LogAnalysisResponse("Invalid log URL format");
                }
                String id = matcher.group(1);
                URL url = new URL("https://api.mclo.gs/1/insights/" + id);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", this.userAgent);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    StringBuilder responseBody = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            responseBody.append(line);
                        }
                    }
                    JsonObject jsonResponse = JsonParser.parseString((String)responseBody.toString()).getAsJsonObject();
                    if (jsonResponse.has("analysis") && jsonResponse.getAsJsonObject("analysis").has("problems")) {
                        JsonArray problemsArray = jsonResponse.getAsJsonObject("analysis").getAsJsonArray("problems");
                        ArrayList<Problem> problems = new ArrayList<Problem>();
                        for (JsonElement problemElement : problemsArray) {
                            JsonObject problemObject = problemElement.getAsJsonObject();
                            String problemMessage = problemObject.get("message").getAsString();
                            int lineNumber = 0;
                            if (problemObject.has("entry") && problemObject.getAsJsonObject("entry").has("lines") && problemObject.getAsJsonObject("entry").getAsJsonArray("lines").size() > 0) {
                                lineNumber = problemObject.getAsJsonObject("entry").getAsJsonArray("lines").get(0).getAsJsonObject().get("number").getAsInt();
                            }
                            ArrayList<String> solutions = new ArrayList<String>();
                            StringBuilder solutionBuilder = new StringBuilder();
                            if (problemObject.has("solutions")) {
                                JsonArray solutionsArray = problemObject.getAsJsonArray("solutions");
                                for (JsonElement solutionElement : solutionsArray) {
                                    if (solutionBuilder.length() > 0) {
                                        solutionBuilder.append("\n");
                                    }
                                    solutions.add(solutionElement.getAsJsonObject().get("message").getAsString());
                                }
                            }
                            problems.add(new Problem(lineNumber, problemMessage, solutions));
                        }
                        return new LogAnalysisResponse(problems);
                    }
                    return new LogAnalysisResponse("No problems found in the log");
                }
                return new LogAnalysisResponse("HTTP error: " + responseCode);
            }
            catch (Exception e) {
                return new LogAnalysisResponse("Error: " + e.getMessage());
            }
        });
    }
}

