/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.attributefix.Constants;
import net.darkhax.attributefix.mixin.AccessorRangedAttribute;
import net.darkhax.attributefix.temp.RegistryHelper;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_2960;
import net.minecraft.class_5134;

public class AttributeConfig {
    @Expose
    private Map<String, Entry> attributes = new HashMap<String, Entry>();
    private static final Map<class_1320, Double> NEW_DEFAULT_VALUES = ImmutableMap.of((Object)class_5134.field_23716, (Object)1000000.0, (Object)class_5134.field_23724, (Object)1000000.0, (Object)class_5134.field_23725, (Object)1000000.0, (Object)class_5134.field_23721, (Object)1000000.0, (Object)class_5134.field_23722, (Object)1000000.0);

    public void applyChanges(RegistryHelper<class_1320> registry) {
        Constants.LOG.info("Applying changes for {} attributes.", (Object)this.attributes.size());
        for (Map.Entry<String, Entry> configEntry : this.attributes.entrySet()) {
            class_1320 attribute;
            class_2960 attributeId = class_2960.method_12829((String)configEntry.getKey());
            if (attributeId == null || !registry.exists(attributeId) || !((attribute = registry.get(attributeId)) instanceof class_1329)) continue;
            class_1329 ranged = (class_1329)attribute;
            double minValue = configEntry.getValue().min.value;
            double maxValue = configEntry.getValue().max.value;
            if (minValue > maxValue) {
                Constants.LOG.error("Attribute {} was configured to have a minimum value higher than it's maximum. This is not permitted!", (Object)attributeId);
                continue;
            }
            AccessorRangedAttribute accessor = (AccessorRangedAttribute)attribute;
            if (minValue != ranged.method_35061()) {
                Constants.LOG.debug("Modifying minimum value for {} from {} to {}.", new Object[]{attributeId, Constants.FORMAT.format(ranged.method_35061()), Constants.FORMAT.format(minValue)});
                accessor.attributefix$setMinValue(minValue);
            }
            if (maxValue == ranged.method_35062()) continue;
            Constants.LOG.debug("Modifying maximum value for {} from {} to {}.", new Object[]{attributeId, Constants.FORMAT.format(ranged.method_35062()), Constants.FORMAT.format(maxValue)});
            accessor.attributefix$setMaxValue(maxValue);
        }
    }

    public static AttributeConfig load(File configFile, RegistryHelper<class_1320> registry) {
        AttributeConfig config = new AttributeConfig();
        for (class_1320 attribute : registry.getValues()) {
            if (!(attribute instanceof class_1329)) continue;
            class_1329 ranged = (class_1329)attribute;
            class_2960 id = registry.getId(attribute);
            config.attributes.put(id.toString(), new Entry(id, ranged));
        }
        Constants.LOG.info("Loaded values for {} compatible attributes.", (Object)config.attributes.size());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                Map<String, Entry> configValues = ((AttributeConfig)Constants.GSON.fromJson((Reader)reader, AttributeConfig.class)).attributes;
                for (Map.Entry<String, Entry> configEntry : configValues.entrySet()) {
                    class_2960 attributeId = class_2960.method_12829((String)configEntry.getKey());
                    if (attributeId == null) {
                        Constants.LOG.error("Attribute ID '{}' is not a valid. This entry will be ignored.", (Object)configEntry.getKey());
                    } else if (!registry.exists(attributeId)) {
                        Constants.LOG.error("Attribute ID '{}' does not belong to a known attribute. This entry will be ignored.", (Object)configEntry.getKey());
                    }
                    if (configEntry.getValue().min.value > configEntry.getValue().max.value) {
                        Constants.LOG.error("Attribute ID '{}' has a max value that is less than its minimum value!", (Object)configEntry.getKey());
                    }
                    config.attributes.put(configEntry.getKey(), configEntry.getValue());
                }
                Constants.LOG.info("Loaded {} values from config.", (Object)configValues.size());
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.trace("Failed to read config file.", (Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            Constants.GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saving config file. {} entries.", (Object)config.attributes.size());
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.trace("Failed to read config file.", (Throwable)e);
        }
        return config;
    }

    public static class Entry {
        @Expose
        private boolean enabled;
        @Expose
        private DoubleValue min;
        @Expose
        private DoubleValue max;

        public Entry(class_2960 id, class_1329 attribute) {
            this.enabled = "minecraft".equals(id.method_12836());
            this.min = new DoubleValue(attribute.method_35061(), attribute.method_35061());
            this.max = new DoubleValue(attribute.method_35062(), NEW_DEFAULT_VALUES.getOrDefault(attribute, attribute.method_35062()));
        }

        public boolean isEnabled() {
            return this.isEnabled();
        }
    }

    public static class DoubleValue {
        @Expose
        @SerializedName(value="default")
        private double defaultValue;
        @Expose
        private double value;

        public DoubleValue(double defaultValue, double value) {
            this.defaultValue = defaultValue;
            this.value = value;
        }
    }
}

