/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.effect;

import com.bawnorton.bettertrims.client.compat.yacl.CyclingItemImageRenderer;
import com.bawnorton.bettertrims.effect.attribute.TrimAttribute;
import com.bawnorton.bettertrims.registry.TrimRegistries;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8054;
import org.jetbrains.annotations.Nullable;

public abstract class TrimEffect {
    private final class_6862<class_1792> materials;
    private final List<TrimAttribute> entityAttributes;

    public TrimEffect(class_6862<class_1792> materials) {
        this.materials = materials;
        this.entityAttributes = new ArrayList<TrimAttribute>();
        this.addAttributes(this.entityAttributes::add);
        TrimRegistries.TRIM_EFFECTS.method_40269((Object)this);
    }

    protected abstract void addAttributes(Consumer<TrimAttribute> var1);

    protected abstract boolean isEnabled();

    public class_6862<class_1792> getMaterials() {
        return this.materials;
    }

    public Set<UUID> getEffectIds(class_1304 slot) {
        return this.entityAttributes.stream().map(attribute -> attribute.getSlotId(slot)).collect(Collectors.toSet());
    }

    public void forEachAttribute(class_1304 slot, BiConsumer<class_1320, class_1322> biConsumer) {
        this.entityAttributes.forEach(attribute -> {
            class_1322 modifier = this.getAttributeModifier((TrimAttribute)attribute, slot);
            if (modifier != null) {
                biConsumer.accept(attribute.entry().get(), modifier);
            }
        });
    }

    @Nullable
    private class_1322 getAttributeModifier(TrimAttribute attribute, class_1304 slot) {
        if (attribute.slotPredicate().test(slot)) {
            String slotId = attribute.getSlotId(slot).toString();
            return new class_1322(UUID.fromString(slotId), slotId, attribute.value(), attribute.operation());
        }
        return null;
    }

    public boolean matchesMaterial(class_6880<class_8054> material) {
        if (!this.isEnabled()) {
            return false;
        }
        return ((class_8054)material.comp_349()).comp_1209().method_40220(this.materials);
    }

    public void readNbt(class_1309 entity, class_2487 nbt) {
    }

    public class_2487 writeNbt(class_1309 entity, class_2487 nbt) {
        return nbt;
    }

    public class_2960 getId() {
        return TrimRegistries.TRIM_EFFECTS.method_10221((Object)this);
    }

    public static CompletableFuture<Optional<ImageRenderer>> getImageFor(class_6862<class_1792> materials) {
        return CompletableFuture.completedFuture(class_7923.field_41178.method_40266(materials).map(named -> named.method_40239().map(itemEntry -> ((class_1792)itemEntry.comp_349()).method_7854()).toList()).map(CyclingItemImageRenderer::new));
    }

    public static interface Factory<T extends TrimEffect> {
        public T create(class_6862<class_1792> var1);
    }
}

