/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.entity;

import com.bawnorton.bettertrims.effect.attribute.AttributeSettings;
import com.bawnorton.bettertrims.mixin.accessor.ItemAccessor;
import com.bawnorton.bettertrims.util.Memoized;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class AncientSkeletonEntity
extends class_1321 {
    public static final Memoized<List<class_1792>> WEAPONS = Memoized.of(() -> class_7923.field_41178.method_10220().filter(item -> {
        class_1799 stack = item.method_7854();
        Multimap attributeModifiers = stack.method_7926(class_1304.field_6173);
        if (attributeModifiers == null) {
            return false;
        }
        Collection attackDamageModifiers = attributeModifiers.get((Object)class_5134.field_23721);
        class_1322 attackDamage = attackDamageModifiers.stream().filter(modifier -> modifier.method_6189().equals(ItemAccessor.getAttackDamageModifierId())).findFirst().orElse(null);
        if (attackDamage == null) {
            return false;
        }
        double amount = attackDamage.method_6186();
        return amount > (double)AttributeSettings.WarriorsOfOld.minWeaponDamage && amount <= (double)AttributeSettings.WarriorsOfOld.maxWeaponDamage;
    }).toList());
    public static final Memoized<Map<class_1741, List<class_1799>>> ARMOUR_ITEMS = Memoized.of(() -> {
        List<class_1738> armourItems = class_7923.field_41178.method_10220().filter(item -> item instanceof class_1738).map(class_1738.class::cast).toList();
        HashMap armourMaterialLookup = new HashMap();
        armourItems.forEach(item -> {
            boolean suitable;
            class_1741 material = item.method_7686();
            boolean bl = suitable = Arrays.stream(class_1738.class_8051.values()).mapToInt(arg_0 -> ((class_1741)material).method_48403(arg_0)).sum() < AttributeSettings.WarriorsOfOld.armourStrength;
            if (!suitable) {
                return;
            }
            armourMaterialLookup.computeIfAbsent(material, k -> new ArrayList()).add(item.method_7854());
        });
        return armourMaterialLookup;
    });
    private int ticksAlive = 0;

    public AncientSkeletonEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createAncientSkeletonAttributes() {
        return class_1308.method_26828().method_26867(class_5134.field_23721).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.6, false));
        this.field_6201.method_6277(2, (class_1352)new class_1350((class_1321)this, 2.0, 10.0f, 2.0f, false));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1588.class, 10, true, false, null));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    public void method_5773() {
        ++this.ticksAlive;
        if (AttributeSettings.WarriorsOfOld.decayRate != 0 && this.ticksAlive % 20 * (100 - AttributeSettings.WarriorsOfOld.decayRate) == 0) {
            this.method_6033(this.method_6032() - 1.0f);
        }
        if (this.method_29504()) {
            this.field_6213 = 20;
        }
        super.method_5773();
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        super.method_5964(random, localDifficulty);
        class_1799 weapon = WEAPONS.get().get(random.method_43048(WEAPONS.get().size())).method_7854();
        class_1890.method_8233((class_5819)random, (class_1799)weapon, (int)AttributeSettings.WarriorsOfOld.weaponEnchantLevel, (boolean)false);
        this.method_5673(class_1304.field_6173, weapon);
        ArrayList<List<class_1799>> armourSets = new ArrayList<List<class_1799>>(ARMOUR_ITEMS.get().values());
        List armourItems = (List)armourSets.get(random.method_43048(armourSets.size()));
        armourItems.removeIf(stack -> armourItems.size() > 1 && random.method_43056());
        armourItems.forEach(stack -> class_1890.method_8233((class_5819)random, (class_1799)stack, (int)AttributeSettings.WarriorsOfOld.armourEnchantLevel, (boolean)false));
        armourItems.forEach(stack -> this.method_5673(((class_5151)stack.method_7909()).method_7685(), (class_1799)stack));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        this.method_5964(world.method_8409(), difficulty);
        return entityData;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.ticksAlive = nbt.method_10550("ticksAlive");
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("ticksAlive", this.ticksAlive);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14548, 0.15f, 1.0f);
    }

    @Nullable
    protected class_3414 method_5994() {
        return class_3417.field_15200;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15069;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14877;
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }
}

