/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.attributes.brewers_dream;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.effect.attribute.AttributeSettings;
import com.bawnorton.bettertrims.extend.ModifiedTimeHolder;
import com.bawnorton.bettertrims.networking.packet.s2c.StatusEffectDurationModifiedS2CPacket;
import com.bawnorton.bettertrims.registry.content.TrimCriteria;
import com.bawnorton.bettertrims.registry.content.TrimEntityAttributes;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1293.class})
public abstract class StatusEffectInstanceMixin
implements ModifiedTimeHolder {
    @Shadow
    @Final
    private class_1291 field_5896;
    @Unique
    private static final ThreadLocal<class_1309> bettertrims$ENTITY_CAPTURE = new ThreadLocal();
    @Unique
    private static final ThreadLocal<class_1291> bettertrims$STATUS_EFFECT_CAPTURE = new ThreadLocal();
    @Unique
    private static final ThreadLocal<class_1293> bettertrims$INSTANCE_CAPTURE = new ThreadLocal();
    @Unique
    private int bettertrims$modifiedTime;

    @ModifyExpressionValue(method={"method_48560"}, at={@At(value="CONSTANT", args={"intValue=1"})})
    private static int applyBrewersDreamToDuration(int original) {
        class_1309 entity = bettertrims$ENTITY_CAPTURE.get();
        class_1291 effect = bettertrims$STATUS_EFFECT_CAPTURE.get();
        int level = (int)entity.method_26825(TrimEntityAttributes.BREWERS_DREAM);
        float chance = (float)level * AttributeSettings.BrewersDream.modificationChance;
        int modified = effect != null && BetterTrims.PROBABILITIES.passes(chance) ? (effect.method_5573() ? 0 : 2) : 1;
        class_1293 instance = bettertrims$INSTANCE_CAPTURE.get();
        if (instance.method_5584() - modified < 0) {
            return original;
        }
        if (modified != 1 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ((ModifiedTimeHolder)instance).bettertrims$incrementModifiedTime();
            int modifiedTime = ((ModifiedTimeHolder)instance).bettertrims$getModifiedTime();
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)new StatusEffectDurationModifiedS2CPacket(effect, modifiedTime));
            if (modifiedTime / 20 > 60) {
                TrimCriteria.BREWERS_DREAM_EXTENDED.trigger(player);
            }
        }
        return modified;
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectInstance;updateDuration()I")})
    private void captureData(class_1309 entity, Runnable overwriteCallback, CallbackInfoReturnable<Boolean> cir) {
        bettertrims$ENTITY_CAPTURE.set(entity);
        bettertrims$STATUS_EFFECT_CAPTURE.set(this.field_5896);
        bettertrims$INSTANCE_CAPTURE.set((class_1293)this);
    }

    @Override
    public void bettertrims$incrementModifiedTime() {
        ++this.bettertrims$modifiedTime;
    }

    @Override
    public void bettertrims$setModifiedTime(int modifiedTime) {
        this.bettertrims$modifiedTime = modifiedTime;
    }

    @Override
    public int bettertrims$getModifiedTime() {
        return this.bettertrims$modifiedTime;
    }

    @Inject(method={"writeTypelessNbt"}, at={@At(value="TAIL")})
    private void writeModifiedTime(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("bettertrims$modifiedTime", this.bettertrims$modifiedTime);
    }

    @ModifyReturnValue(method={"fromNbt(Lnet/minecraft/entity/effect/StatusEffect;Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/entity/effect/StatusEffectInstance;"}, at={@At(value="RETURN")})
    private static class_1293 readModifiedTime(class_1293 original, class_1291 statusEffect, class_2487 nbt) {
        int modifedTime = nbt.method_10550("bettertrims$modifiedTime");
        ((ModifiedTimeHolder)original).bettertrims$setModifiedTime(modifedTime);
        return original;
    }
}

