/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.attributes.echoing;

import com.bawnorton.bettertrims.effect.EchoShardTrimEffect;
import com.bawnorton.bettertrims.effect.attribute.AttributeSettings;
import com.bawnorton.bettertrims.networking.packet.s2c.EchoTriggeredS2CPacket;
import com.bawnorton.bettertrims.networking.packet.s2c.EntityEchoedS2CPacket;
import com.bawnorton.bettertrims.registry.content.TrimCriteria;
import com.bawnorton.bettertrims.registry.content.TrimEffects;
import com.bawnorton.bettertrims.registry.content.TrimEntityAttributes;
import com.bawnorton.bettertrims.registry.content.TrimSoundEvents;
import com.bawnorton.bettertrims.registry.content.TrimStatusEffects;
import com.google.common.collect.EvictingQueue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    public abstract float method_6032();

    @Shadow
    public abstract float method_5791();

    @Shadow
    public abstract void method_6033(float var1);

    @Shadow
    public abstract boolean method_6012();

    @Shadow
    public abstract double method_26825(class_1320 var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @WrapOperation(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z")})
    private boolean applyEchoing(class_1309 instance, class_1282 source, Operation<Boolean> original) {
        if (((Boolean)original.call(new Object[]{instance, source})).booleanValue()) {
            return true;
        }
        if (source.method_48789(class_8103.field_42242)) {
            return false;
        }
        EvictingQueue<EchoShardTrimEffect.Echo> echoes = TrimEffects.ECHO_SHARD.getEchoes(instance);
        if (echoes == null || echoes.isEmpty()) {
            return false;
        }
        EchoShardTrimEffect.Echo oldest = (EchoShardTrimEffect.Echo)echoes.peek();
        if (oldest == null) {
            return false;
        }
        echoes.clear();
        class_243 pos = oldest.pos();
        class_243 oldPos = this.method_19538();
        class_3218 world = (class_3218)this.method_37908();
        this.method_48105(world, pos.field_1352, pos.field_1351, pos.field_1350, class_2709.field_40710, oldest.yaw(), oldest.pitch());
        this.method_6033(oldest.health());
        List players = world.method_18456();
        players.forEach(player -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)new EntityEchoedS2CPacket(oldPos, oldest));
            }
        });
        int echoingLevel = (int)this.method_26825(TrimEntityAttributes.ECHOING);
        this.method_6092(new class_1293(TrimStatusEffects.DAMPENED, 20 * (AttributeSettings.Echoing.baseDampeningDuration - AttributeSettings.Echoing.dampeningReduction * echoingLevel), 0));
        for (int i = 5; i > 0; --i) {
            float pitch = (float)i * 0.1f;
            CompletableFuture.delayedExecutor(50L * (long)i, TimeUnit.MILLISECONDS).execute(() -> world.method_8503().execute(() -> {
                world.method_45445((class_1297)((class_1309)this), class_2338.method_49638((class_2374)pos), TrimSoundEvents.ECHO_REWIND, class_3419.field_15248, 2.0f, pitch);
                world.method_45445((class_1297)((class_1309)this), class_2338.method_49638((class_2374)oldPos), TrimSoundEvents.ECHO_REWIND, class_3419.field_15248, 2.0f, pitch);
            }));
        }
        if (instance instanceof class_3222) {
            class_3222 player2 = (class_3222)instance;
            ServerPlayNetworking.send((class_3222)player2, (FabricPacket)new EchoTriggeredS2CPacket(oldest));
            TrimCriteria.ECHOING_TRIGGERED.trigger(player2);
        }
        return true;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;sendEquipmentChanges()V")})
    private void createEcho(CallbackInfo ci) {
        TrimEffects.ECHO_SHARD.createEcho((class_1309)this, this.method_19538(), this.method_36455(), this.method_5791(), this.method_6032());
    }
}

