/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.util;

import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Plane {
    private static final Random rand = new Random();
    private final Vector3d point1;
    private final Vector3d point2;
    private final Vector3d point3;
    private final Vector3d point4;

    public Plane(Vector3d point1, Vector3d point2, Vector3d normal) {
        this.point1 = point1;
        this.point2 = point2;
        Vector3d v = new Vector3d((Vector3dc)point1).sub((Vector3dc)point2);
        Vector3d n = new Vector3d((Vector3dc)normal);
        Vector3d u = new Vector3d((Vector3dc)v).cross((Vector3dc)n).normalize();
        double length = v.length();
        Vector3d m = new Vector3d((Vector3dc)point1).add((Vector3dc)point2).div(2.0);
        this.point3 = new Vector3d((Vector3dc)m).add((Vector3dc)new Vector3d((Vector3dc)u).mul(length / 2.0));
        this.point4 = new Vector3d((Vector3dc)m).sub((Vector3dc)new Vector3d((Vector3dc)u).mul(length / 2.0));
    }

    public static Plane fromSideOfBox(class_238 box, class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> new Plane(new Vector3d(box.field_1323, box.field_1325, box.field_1321), new Vector3d(box.field_1320, box.field_1325, box.field_1324), new Vector3d(0.0, 1.0, 0.0));
            case class_2350.field_11033 -> new Plane(new Vector3d(box.field_1323, box.field_1322, box.field_1321), new Vector3d(box.field_1320, box.field_1322, box.field_1324), new Vector3d(0.0, -1.0, 0.0));
            case class_2350.field_11034 -> new Plane(new Vector3d(box.field_1320, box.field_1322, box.field_1321), new Vector3d(box.field_1320, box.field_1325, box.field_1324), new Vector3d(1.0, 0.0, 0.0));
            case class_2350.field_11039 -> new Plane(new Vector3d(box.field_1323, box.field_1322, box.field_1321), new Vector3d(box.field_1323, box.field_1325, box.field_1324), new Vector3d(-1.0, 0.0, 0.0));
            case class_2350.field_11043 -> new Plane(new Vector3d(box.field_1323, box.field_1322, box.field_1321), new Vector3d(box.field_1320, box.field_1325, box.field_1321), new Vector3d(0.0, 0.0, -1.0));
            case class_2350.field_11035 -> new Plane(new Vector3d(box.field_1323, box.field_1322, box.field_1324), new Vector3d(box.field_1320, box.field_1325, box.field_1324), new Vector3d(0.0, 0.0, 1.0));
        };
    }

    public static Plane fromBlockPos(class_2338 pos, class_2350 direction) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        return Plane.fromSideOfBox(new class_238((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)), direction);
    }

    public Vector3d getRandPointOnPlane() {
        Vector3d v1 = new Vector3d((Vector3dc)this.point3).sub((Vector3dc)this.point1);
        Vector3d v2 = new Vector3d((Vector3dc)this.point4).sub((Vector3dc)this.point2);
        double r1 = rand.nextDouble();
        double r2 = rand.nextDouble();
        double x = this.point1.x + r1 * v1.x + r2 * v2.x;
        double y = this.point1.y + r1 * v1.y + r2 * v2.y;
        double z = this.point1.z + r1 * v1.z + r2 * v2.z;
        return new Vector3d(x, y, z);
    }

    public String toString() {
        return "Plane[%s -> %s]".formatted(this.point1, this.point2);
    }
}

