/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.LootEvent;
import it.hurts.octostudios.cardiac.common.entities.LifeOrb;
import it.hurts.octostudios.cardiac.common.init.ConfigRegistry;
import it.hurts.octostudios.cardiac.common.init.DispenserBehaviorRegistry;
import it.hurts.octostudios.cardiac.common.init.EnchantmentRegistry;
import it.hurts.octostudios.cardiac.common.init.EntityRegistry;
import it.hurts.octostudios.cardiac.common.init.ItemRegistry;
import it.hurts.octostudios.cardiac.common.init.SoundRegistry;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_117;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_141;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_219;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_5819;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;

public class Cardiac {
    public static final String MODID = "cardiac";

    public static void init() {
        EnchantmentRegistry.registerCommon();
        EntityRegistry.registerCommon();
        SoundRegistry.registerCommon();
        ItemRegistry.registerCommon();
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            double toDrop;
            class_1297 killer = source.method_5529();
            if (!(killer instanceof class_1657) && ConfigRegistry.CONFIG.isShouldBeKilledByPlayer()) {
                return EventResult.pass();
            }
            class_1937 level = entity.method_5770();
            class_5819 random = entity.method_6051();
            double basePercentage = 0.0;
            String entityId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
            for (Map.Entry<String, Double> entry : ConfigRegistry.CONFIG.getGeneralPercentages().entrySet()) {
                String pattern = entry.getKey();
                Double percentage = entry.getValue();
                if (percentage == 0.0) continue;
                try {
                    if (!entityId.matches(pattern)) continue;
                    basePercentage = percentage;
                }
                catch (PatternSyntaxException exception) {
                    if (!entityId.equals(pattern)) continue;
                    basePercentage = percentage;
                }
            }
            double lifestealPercentage = 0.0;
            if (killer instanceof class_1309) {
                class_1309 livingEntity = (class_1309)killer;
                int enchantment = class_1890.method_8225((class_1887)((class_1887)EnchantmentRegistry.LIFESTEAL.get()), (class_1799)livingEntity.method_6047());
                if (enchantment > 0) {
                    for (Map.Entry<String, Double> entry : ConfigRegistry.CONFIG.getLifestealPercentages().entrySet()) {
                        String pattern = entry.getKey();
                        Double percentage = entry.getValue();
                        if (percentage == 0.0) continue;
                        try {
                            if (!entityId.matches(pattern)) continue;
                            lifestealPercentage = percentage;
                        }
                        catch (PatternSyntaxException exception) {
                            if (!entityId.equals(pattern)) continue;
                            lifestealPercentage = percentage;
                        }
                    }
                }
            }
            if ((toDrop = (double)entity.method_6063() * (basePercentage + lifestealPercentage)) == 0.0) {
                return EventResult.pass();
            }
            int steps = ConfigRegistry.CONFIG.getMinOrbsAmount() + random.method_43048((int)Math.ceil(toDrop));
            for (int i = 0; i < steps; ++i) {
                LifeOrb orb = new LifeOrb((class_1299<? extends LifeOrb>)((class_1299)EntityRegistry.LIFE_ORB.get()), level);
                orb.setLife((float)(toDrop / (double)steps));
                orb.method_33574(entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0));
                orb.method_18800((-1.0f + 2.0f * random.method_43057()) * 0.15f, 0.1f + random.method_43057() * 0.3f, (-1.0f + 2.0f * random.method_43057()) * 0.15f);
                level.method_8649((class_1297)orb);
            }
            return EventResult.pass();
        });
        LootEvent.MODIFY_LOOT_TABLE.register((lootDataManager, id, context, builtin) -> {
            if (id.method_12832().matches(".*chests.*")) {
                context.addPool(class_55.method_347().method_351((class_79.class_80)((class_85.class_86)class_77.method_411((class_1935)((class_1935)ItemRegistry.LIFE_BOTTLE.get())).method_437(5).method_421(class_219.method_932((float)0.2f))).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)))));
            }
        });
        LifecycleEvent.SETUP.register(() -> {
            DispenserBehaviorRegistry.registerCommon();
            ConfigRegistry.registerCommon();
        });
    }
}

