/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.generator;

import com.bawnorton.configurable.ap.generator.ConfigurableGenerator;
import com.bawnorton.configurable.ap.tree.ConfigurableElement;
import com.bawnorton.configurable.ap.tree.ConfigurableHolder;
import com.bawnorton.configurable.load.ConfigurableSettings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class ConfigGenerator
extends ConfigurableGenerator {
    private static final String CONFIG_SPEC = "\npackage <configurable_package>;\n\n<imports>\nimport com.bawnorton.configurable.ConfigurableMain;\nimport com.bawnorton.configurable.generated.GeneratedConfig;\nimport com.bawnorton.configurable.ref.constraint.*;\nimport com.bawnorton.configurable.ref.Reference;\n\npublic final class Config implements GeneratedConfig {\n<content>\n    @Override\n    public void update(boolean fromServer) {\n        boolean serverEnforces = ConfigurableMain.getWrappers(\"<name>\").get(\"<source_set>\").serverEnforces();\n<validator>\n    }\n}\n";
    public Map<ConfigurableElement, String> externalReferenceMap = new HashMap<ConfigurableElement, String>();

    public ConfigGenerator(Filer filer, Types types, Messager messager, ConfigurableSettings settings) {
        super(filer, types, messager, settings);
    }

    public void generateConfig(List<ConfigurableElement> roots) throws IOException {
        StringBuilder validator = new StringBuilder();
        StringBuilder content = new StringBuilder();
        HashSet neededImports = new HashSet();
        roots.forEach(root -> this.addElement(content, (ConfigurableElement)root, validator, neededImports, "config", 1));
        String spec = CONFIG_SPEC;
        spec = spec.replaceAll("<content>", content.toString());
        spec = spec.replaceAll("<validator>", validator.toString());
        StringBuilder importBuilder = new StringBuilder();
        for (String neededImport : neededImports) {
            importBuilder.append("import ").append(neededImport).append(";\n");
        }
        spec = spec.replaceAll("<imports>", importBuilder.toString());
        spec = this.applyReplacements(spec);
        JavaFileObject config = this.filer.createSourceFile(this.settings.fullyQualifiedConfig(), new Element[0]);
        try (PrintWriter out = new PrintWriter(config.openWriter());){
            out.println(spec);
        }
    }

    private void addElement(StringBuilder builder, ConfigurableElement element, StringBuilder validator, Set<String> neededImports, String externalParent, int depth) {
        if (element.childless()) {
            this.addReference(builder, element, validator, neededImports, externalParent, depth);
        } else {
            this.addContainer(builder, element, validator, neededImports, externalParent, depth);
        }
    }

    private void addContainer(StringBuilder builder, ConfigurableElement element, StringBuilder validator, Set<String> neededImports, String externalParent, int depth) {
        String container = "%1$spublic final %2$s %3$s = new %2$s();\n\n%1$spublic static class %2$s {\n<comment>\n<content>\n%1$s}\n".formatted("\t".repeat(depth), element.getElementConfigName(), element.getKey());
        StringBuilder contentBuilder = new StringBuilder();
        for (ConfigurableElement child : element.children()) {
            this.addElement(contentBuilder, child, validator, neededImports, "%s.%s".formatted(externalParent, element.getKey()), depth + 1);
        }
        container = container.replaceAll("<content>", contentBuilder.toString().replaceAll("\\r?\\n$", ""));
        container = container.replaceAll("<comment>", "%spublic static final String CONFIGURABLE_COMMENT = \"\"\"\n%s\"\"\".trim();".formatted("\t".repeat(depth), element.comment()));
        builder.append(container);
    }

    private void addReference(StringBuilder builder, ConfigurableElement element, StringBuilder validator, Set<String> neededImports, String externalParent, int depth) {
        String reference = "public final Reference<%s> %s = new Reference<>(\"%s\", %s.class, %s.class, \"\"\"\n%s\"\"\".trim(), %s);".formatted(element.getBoxedType(this.types), element.getKey(), element.getElementName(), element.getOwnerName(), element.getTypeName(), element.comment(), this.createConstraintSet(element));
        neededImports.add(element.getFullyQualifiedTypeName(this.types));
        neededImports.add(element.getFullyQualifiedOwnerName(this.types));
        builder.append("\t".repeat(depth)).append(reference).append("\n");
        String externalReference = "%s.%s".formatted(externalParent, element.getKey());
        this.externalReferenceMap.put(element, externalReference);
        String internalReference = externalReference.substring(externalReference.indexOf(".") + 1);
        validator.append("\t".repeat(2));
        if (element.defaultServerEnforces()) {
            validator.append("%1$s.update(fromServer, serverEnforces);".formatted(internalReference));
        } else {
            validator.append("%1$s.update(fromServer, %2$s);".formatted(internalReference, element.annotationHolder().serverEnforces()));
        }
        validator.append("\n");
    }

    private String createConstraintSet(ConfigurableElement element) {
        ConfigurableHolder holder = element.annotationHolder();
        StringBuilder constraintSet = new StringBuilder("ConstraintSet.builder()");
        this.addPredicateConstraint(element, constraintSet);
        this.addRegexConstraint(holder, constraintSet);
        this.addClampedConstraint(holder, element.element(), constraintSet);
        return constraintSet.toString();
    }

    private void addPredicateConstraint(ConfigurableElement element, StringBuilder constraintSet) {
        String predicate = element.annotationHolder().predicate();
        if (predicate.isEmpty()) {
            return;
        }
        if (predicate.contains("#")) {
            String[] parts = predicate.split("#");
            String owner = parts[0];
            String methodName = parts[1];
            constraintSet.append(".addPredicate(value -> %s.%s((%s) value))".formatted(owner, methodName, element.getTypeName()));
        } else {
            String owner = element.getFullyQualifiedOwnerName(this.types);
            constraintSet.append(".addPredicate(value -> %s.%s((%s) value))".formatted(owner, predicate, element.getTypeName()));
        }
    }

    private void addRegexConstraint(ConfigurableHolder holder, StringBuilder constraintSet) {
        String regex = holder.regex();
        if (!regex.isEmpty()) {
            constraintSet.append(".addRegex(\"%s\")".formatted(regex));
        }
    }

    private void addClampedConstraint(ConfigurableHolder holder, Element element, StringBuilder constraintSet) {
        if (holder.isMaxSet() || holder.isMinSet()) {
            double max;
            double min = holder.min();
            if (min > (max = holder.max())) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "min must be smaller than or equal to the max", element);
            }
            constraintSet.append(".addClamped(%s, %s)".formatted(min, max));
        }
    }

    public String getExternalReference(ConfigurableElement element) {
        return this.externalReferenceMap.get(element);
    }
}

