/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.sourceprovider;

import com.bawnorton.configurable.ap.sourceprovider.FabricSourceProvider;
import com.bawnorton.configurable.ap.sourceprovider.SourceProvider;
import com.bawnorton.configurable.ap.sourceprovider.SourceProviderFactory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Filer;

public final class SourceProviders {
    private static final Set<SourceProviderFactory> factories = new HashSet<SourceProviderFactory>();

    public static void registerDefaultSourceProviders() {
        SourceProviders.registerSourceProvider(FabricSourceProvider::new);
    }

    public static void registerSourceProvider(SourceProviderFactory factory) {
        factories.add(factory);
    }

    public static SourceProvider getSourceProvider(Filer filer, Path buildPath) {
        for (SourceProviderFactory factory : factories) {
            SourceProvider provier = factory.create(filer, buildPath);
            if (!provier.matches()) continue;
            return provier;
        }
        return null;
    }
}

