/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.tree;

import com.bawnorton.configurable.Configurable;
import com.bawnorton.configurable.ControllerType;
import com.bawnorton.configurable.Image;
import com.bawnorton.configurable.OptionType;
import com.bawnorton.configurable.ap.helper.AnnotationHelper;
import com.bawnorton.configurable.ap.tree.ConfigurableOverrides;
import javax.lang.model.element.AnnotationMirror;

public final class ConfigurableHolder {
    private final Configurable annotation;
    private final AnnotationMirror configurableMirror;
    private final AnnotationMirror yaclMirror;
    private final AnnotationMirror imageMirror;
    private ConfigurableOverrides overrides;

    public ConfigurableHolder(Configurable annotation, AnnotationMirror configurableMirror) {
        this.annotation = annotation;
        this.configurableMirror = configurableMirror;
        this.yaclMirror = AnnotationHelper.getSubAnnotation(configurableMirror, "yacl").orElse(null);
        this.imageMirror = AnnotationHelper.getSubAnnotation(this.yaclMirror, "image").orElse(null);
    }

    public void setOverrides(ConfigurableOverrides overrides) {
        this.overrides = overrides;
    }

    public Configurable annotation() {
        return this.annotation;
    }

    public AnnotationMirror getConfigurableMirror() {
        return this.configurableMirror;
    }

    public AnnotationMirror getYaclMirror() {
        return this.yaclMirror;
    }

    public AnnotationMirror getImageMirror() {
        return this.imageMirror;
    }

    public boolean serverEnforces() {
        return this.overrides == null ? this.annotation().serverEnforces() : this.overrides.getServerEnforces();
    }

    public boolean exclude() {
        return this.overrides == null ? this.annotation().yacl().exclude() : this.overrides.getExclude();
    }

    public String category() {
        return this.overrides == null ? this.annotation().yacl().category() : this.overrides.getCategory();
    }

    public OptionType[] type() {
        return this.overrides == null ? this.annotation().yacl().type() : this.overrides.getOptionType();
    }

    public Image image() {
        return this.overrides == null ? this.annotation().yacl().image() : this.overrides.getImage();
    }

    public boolean inheritedImage() {
        if (this.overrides == null) {
            return false;
        }
        return this.overrides.imageOverridden();
    }

    public String value() {
        return this.annotation.value();
    }

    public String regex() {
        return this.annotation().regex();
    }

    public String predicate() {
        return this.annotation().predicate();
    }

    public double min() {
        return this.annotation.min();
    }

    public double max() {
        return this.annotation.max();
    }

    public ControllerType controller() {
        return this.annotation().yacl().controller();
    }

    public String customController() {
        return this.annotation().yacl().customController();
    }

    public String formatter() {
        return this.annotation().yacl().formatter();
    }

    public String descriptioner() {
        return this.annotation().yacl().descriptioner();
    }

    public String[] listener() {
        return this.annotation().yacl().listener();
    }

    public boolean collapsed() {
        return this.annotation.yacl().collapsed();
    }

    public boolean isMinSet() {
        return !AnnotationHelper.isDefaultValue(this.configurableMirror, "min");
    }

    public boolean isMaxSet() {
        return !AnnotationHelper.isDefaultValue(this.configurableMirror, "max");
    }
}

