/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.tree;

import com.bawnorton.configurable.Image;
import com.bawnorton.configurable.OptionType;
import com.bawnorton.configurable.ap.helper.AnnotationHelper;
import com.bawnorton.configurable.ap.tree.ConfigurableHolder;
import com.bawnorton.configurable.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;

public final class ConfigurableOverrides {
    private final Map<String, Pair<Boolean, Supplier<?>>> overrides = new HashMap();

    public ConfigurableOverrides(Map<String, Pair<Boolean, Supplier<?>>> overrides) {
        this.overrides.putAll(overrides);
    }

    public static void create(ConfigurableHolder parent, ConfigurableHolder child) {
        AnnotationMirror configurableMirror = child.getConfigurableMirror();
        AnnotationMirror yaclMirror = child.getYaclMirror();
        child.setOverrides(ConfigurableOverrides.builder().addOverride(configurableMirror, "serverEnforces", parent::serverEnforces, () -> child.annotation().serverEnforces()).addOverride(yaclMirror, "category", parent::category, () -> child.annotation().yacl().category()).addOverride(yaclMirror, "exclude", parent::exclude, () -> child.annotation().yacl().exclude()).addOverride(yaclMirror, "type", parent::type, () -> child.annotation().yacl().type()).addOverride(yaclMirror, "image", parent::image, () -> child.annotation().yacl().image()).build());
    }

    public boolean getServerEnforces() {
        return (Boolean)this.overrides.get("serverEnforces").second().get();
    }

    public String getCategory() {
        return (String)this.overrides.get("category").second().get();
    }

    public boolean getExclude() {
        return (Boolean)this.overrides.get("exclude").second().get();
    }

    public OptionType[] getOptionType() {
        return (OptionType[])this.overrides.get("type").second().get();
    }

    public Image getImage() {
        return (Image)this.overrides.get("image").second().get();
    }

    public boolean imageOverridden() {
        return this.overrides.get("image").first();
    }

    private static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private final Map<String, Pair<Boolean, Supplier<?>>> overrides = new HashMap();

        private Builder() {
        }

        public <T> Builder addOverride(AnnotationMirror mirror, String name, Supplier<T> override, Supplier<T> natural) {
            boolean isDefaultValue = AnnotationHelper.isDefaultValue(mirror, name);
            this.overrides.put(name, Pair.of(isDefaultValue, isDefaultValue ? override : natural));
            return this;
        }

        public ConfigurableOverrides build() {
            return new ConfigurableOverrides(this.overrides);
        }
    }
}

