/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.tree;

import com.bawnorton.configurable.Configurable;
import com.bawnorton.configurable.ap.tree.ConfigurableElement;
import com.bawnorton.configurable.ap.tree.ConfigurableHolder;
import com.bawnorton.configurable.ap.tree.ConfigurableOverrides;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public final class ConfigurableTree {
    private final Messager messager;
    private final Elements elementUtils;
    private final List<ConfigurableElement> roots;

    public ConfigurableTree(Messager messager, Elements elementUtil, Set<? extends Element> elements) {
        this.messager = messager;
        this.elementUtils = elementUtil;
        this.roots = this.constructRoots(elements);
        this.applyOverrides(this.roots);
    }

    private void applyOverrides(List<ConfigurableElement> roots) {
        roots.forEach(this::applyOverrides);
    }

    private void applyOverrides(ConfigurableElement root) {
        ConfigurableHolder parentHolder = root.annotationHolder();
        for (ConfigurableElement child : root.children()) {
            ConfigurableHolder childHolder = child.annotationHolder();
            ConfigurableOverrides.create(parentHolder, childHolder);
            if (child.children().isEmpty()) continue;
            this.applyOverrides(child);
        }
    }

    public List<ConfigurableElement> getRoots() {
        return this.roots;
    }

    private List<ConfigurableElement> constructRoots(Set<? extends Element> elements) {
        HashSet<ConfigurableElement> rootElements = new HashSet<ConfigurableElement>();
        HashSet<Element> orphanedClasses = new HashSet<Element>();
        HashSet<Element> orphanedFields = new HashSet<Element>();
        for (Element element : elements) {
            if (!element.getKind().isClass()) {
                orphanedFields.add(element);
                continue;
            }
            Element enclosing = element.getEnclosingElement();
            if (enclosing.getKind().isClass()) {
                orphanedClasses.add(element);
                continue;
            }
            ConfigurableElement configurableElement = this.createConfigurableElement(element);
            rootElements.add(configurableElement);
        }
        this.addOrphaned(rootElements, orphanedClasses);
        this.addOrphaned(rootElements, orphanedFields);
        ArrayList<ConfigurableElement> sorted = new ArrayList<ConfigurableElement>(rootElements);
        sorted.sort(Comparator.comparing(ConfigurableElement::getKey));
        return sorted;
    }

    private void addOrphaned(Set<ConfigurableElement> rootElements, Set<Element> orphaned) {
        while (!orphaned.isEmpty()) {
            Set visited = rootElements.stream().flatMap(element -> {
                List<ConfigurableElement> relevant = element.getAllChildren();
                relevant.add((ConfigurableElement)element);
                return relevant.stream();
            }).map(ConfigurableElement::element).collect(Collectors.toSet());
            orphaned.removeAll(visited);
            for (Element orphan : orphaned) {
                ConfigurableElement configurableElement = this.createConfigurableElement(orphan);
                rootElements.add(configurableElement);
            }
        }
    }

    private ConfigurableElement createConfigurableElement(Element element) {
        String comment;
        Configurable annotation = element.getAnnotation(Configurable.class);
        ConfigurableHolder holder = new ConfigurableHolder(annotation, this.getAnnotationMirror(element, Configurable.class.getCanonicalName()));
        if (annotation == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Element \"%s\" does not have Configurable annotation".formatted(element.getSimpleName()), element);
            throw new RuntimeException();
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (element.getKind().isField()) {
            if (modifiers.contains((Object)Modifier.FINAL)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Configurable field \"%s\" cannot be final".formatted(element.getSimpleName()), element);
                throw new RuntimeException();
            }
            if (!modifiers.contains((Object)Modifier.STATIC)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Configurable field \"%s\" must be static".formatted(element.getSimpleName()), element);
                throw new RuntimeException();
            }
            if (annotation.yacl().collapsed()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Configurable field \"%s\" cannot be collapsed, only classes allowed".formatted(element.getSimpleName()), element);
                throw new RuntimeException();
            }
        } else if (element.getKind().isClass() && modifiers.contains((Object)Modifier.PRIVATE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Configurable class \"%s\" cannot be private".formatted(element.getSimpleName()), element);
            throw new RuntimeException();
        }
        List<ConfigurableElement> children = element.getEnclosedElements().stream().filter(e -> e.getAnnotation(Configurable.class) != null).map(this::createConfigurableElement).sorted(Comparator.comparing(ConfigurableElement::getKey)).toList();
        if (element.getKind().isClass() && children.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Configurable class \"%s\" must have at least one Configurable field or class".formatted(element.getSimpleName()), element);
            throw new RuntimeException();
        }
        Element topMost = this.getTopMostClass(element);
        if (topMost != null) {
            topMost.getAnnotationMirrors().stream().filter(mirror -> mirror.getAnnotationType().asElement().asType().toString().equals("org.spongepowered.asm.mixin.Mixin")).findFirst().ifPresent(mirror -> {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Configurable element \"%s\" must be outside a mixin class".formatted(element.getSimpleName()), element);
                throw new RuntimeException();
            });
        }
        return new ConfigurableElement(element, (comment = this.elementUtils.getDocComment(element)) == null ? "" : comment, holder, children);
    }

    private AnnotationMirror getAnnotationMirror(Element element, String annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation)) continue;
            return annotationMirror;
        }
        throw new IllegalStateException("No annotation mirror found for %s".formatted(element));
    }

    private Element getTopMostClass(Element element) {
        Element enclosing = element.getEnclosingElement();
        while (enclosing.asType().getKind() != TypeKind.PACKAGE) {
            element = enclosing;
            if ((enclosing = enclosing.getEnclosingElement()) != null) continue;
            break;
        }
        return element;
    }
}

