/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.yacl;

import com.bawnorton.configurable.ap.helper.MappingsHelper;
import com.bawnorton.configurable.ap.yacl.YaclElement;
import java.util.function.Consumer;

public abstract class YaclOptionController
extends YaclElement {
    protected final YaclElement valueFormatter;

    protected YaclOptionController(YaclElement valueFormatter) {
        this.valueFormatter = valueFormatter;
    }

    @Override
    protected void addNeededImports(Consumer<String> adder) {
        if (this.valueFormatter != null) {
            this.valueFormatter.addNeededImports(adder);
        }
    }

    @Override
    protected String getSpec(int depth) {
        String controllerSpec = this.getControllerSpec(depth + 1);
        if (this.valueFormatter == null) {
            return "option -> %s".formatted(controllerSpec).trim();
        }
        return "option -> %2$s\n%1$s.formatValue(value -> %3$s)\n".formatted("\t".repeat(depth + 1), controllerSpec, this.valueFormatter.getSpec(depth + 1)).trim();
    }

    protected abstract String getControllerSpec(int var1);

    private static abstract class NumberSlider<T extends Number>
    extends YaclOptionController {
        private final String name;
        private final String suffix;
        private final T min;
        private final T max;

        protected NumberSlider(YaclElement valueFormatter, String name, String suffix, T min, T max) {
            super(valueFormatter);
            this.name = name;
            this.suffix = suffix;
            this.min = min;
            this.max = max;
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.%sSliderControllerBuilder".formatted(this.name));
        }

        protected abstract String getStep(T var1);

        @Override
        protected String getControllerSpec(int depth) {
            return "%2$sSliderControllerBuilder.create(option)\n%1$s.range(%3$s, %4$s)\n%1$s.step(%5$s)\n".formatted("\t".repeat(depth), this.name, String.valueOf(this.min) + this.suffix, String.valueOf(this.max) + this.suffix, this.getStep(this.max)).trim();
        }
    }

    private static abstract class NumberField<T extends Number>
    extends YaclOptionController {
        private final String name;
        private final String suffix;
        private final T min;
        private final T max;

        protected NumberField(YaclElement valueFormatter, String name, String suffix, T min, T max) {
            super(valueFormatter);
            this.name = name;
            this.suffix = suffix;
            this.min = min;
            this.max = max;
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.%sFieldControllerBuilder".formatted(this.name));
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "%2$sFieldControllerBuilder.create(option)\n%1$s.range(%3$s, %4$s)\n".formatted("\t".repeat(depth), this.name, String.valueOf(this.min) + this.suffix, String.valueOf(this.max) + this.suffix).trim();
        }
    }

    public static class TickBox
    extends YaclOptionController {
        public TickBox() {
            super(null);
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.TickBoxControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "TickBoxControllerBuilder.create(option)";
        }
    }

    public static class StringField
    extends YaclOptionController {
        public StringField() {
            super(null);
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.StringControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "StringControllerBuilder.create(option)";
        }
    }

    public static class LongSlider
    extends NumberSlider<Long> {
        public LongSlider(YaclElement valueFormatter, long min, long max) {
            super(valueFormatter, "Long", "L", min, max);
        }

        @Override
        protected String getStep(Long max) {
            return "Math.min(1, Math.max(1, %sL / 100))".formatted(max);
        }
    }

    public static class LongField
    extends NumberField<Long> {
        public LongField(YaclElement valueFormatter, long min, long max) {
            super(valueFormatter, "Long", "L", min, max);
        }
    }

    public static class Item
    extends YaclOptionController {
        public Item() {
            super(null);
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.ItemControllerBuilder");
            adder.accept(MappingsHelper.getItem());
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "ItemControllerBuilder.create(option)";
        }
    }

    public static class IntegerSlider
    extends NumberSlider<Integer> {
        public IntegerSlider(YaclElement valueFormatter, int min, int max) {
            super(valueFormatter, "Integer", "", min, max);
        }

        @Override
        protected String getStep(Integer max) {
            return "Math.min(1, Math.max(1, %s / 100))".formatted(max);
        }
    }

    public static class IntegerField
    extends NumberField<Integer> {
        public IntegerField(YaclElement valueFormatter, int min, int max) {
            super(valueFormatter, "Integer", "", min, max);
        }
    }

    public static class FloatSlider
    extends NumberSlider<Float> {
        public FloatSlider(YaclElement valueFormatter, float min, float max) {
            super(valueFormatter, "Float", "F", Float.valueOf(min), Float.valueOf(max));
        }

        @Override
        protected String getStep(Float max) {
            return "%sF / 100".formatted(max);
        }
    }

    public static class FloatField
    extends NumberField<Float> {
        public FloatField(YaclElement valueFormatter, float min, float max) {
            super(valueFormatter, "Float", "F", Float.valueOf(min), Float.valueOf(max));
        }
    }

    public static class EnumDropdown
    extends YaclOptionController {
        public EnumDropdown(YaclElement valueFormatter) {
            super(valueFormatter);
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.EnumDropdownControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "EnumDropdownControllerBuilder.create(option)";
        }
    }

    public static class CyclingEnum
    extends YaclOptionController {
        private final String enumClass;

        public CyclingEnum(YaclElement valueFormatter, String enumClass) {
            super(valueFormatter);
            this.enumClass = enumClass;
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept(this.enumClass);
            adder.accept("dev.isxander.yacl3.api.controller.EnumControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "EnumControllerBuilder.create(option)\n%1$s.enumClass(%2$s.class)\n".formatted("\t".repeat(depth), this.enumClass.substring(this.enumClass.lastIndexOf(".") + 1)).trim();
        }
    }

    public static class DoubleSlider
    extends NumberSlider<Double> {
        public DoubleSlider(YaclElement valueFormatter, double min, double max) {
            super(valueFormatter, "Double", "", min, max);
        }

        @Override
        protected String getStep(Double max) {
            return "%s / 100".formatted(max);
        }
    }

    public static class DoubleField
    extends NumberField<Double> {
        public DoubleField(YaclElement valueFormatter, double min, double max) {
            super(valueFormatter, "Double", "", min, max);
        }
    }

    public static class CyclingList
    extends YaclOptionController {
        private final String values;

        public CyclingList(YaclElement valueFormatter, String values) {
            super(valueFormatter);
            this.values = values;
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.CyclingListControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "CyclingListControllerBuilder.create(option)\n%1$s.values(%2$s)\n".formatted("\t".repeat(depth), this.values).trim();
        }
    }

    public static class Color
    extends YaclOptionController {
        private final boolean allowAlpha;

        public Color(boolean allowAlpha) {
            super(null);
            this.allowAlpha = allowAlpha;
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.ColorControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "ColorControllerBuilder.create(option)\n%1$s.allowAlpha(%2$s)\n".formatted("\t".repeat(depth), this.allowAlpha).trim();
        }
    }

    public static class Bool
    extends YaclOptionController {
        public Bool(YaclElement valueFormatter) {
            super(valueFormatter);
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            super.addNeededImports(adder);
            adder.accept("dev.isxander.yacl3.api.controller.BooleanControllerBuilder");
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "BooleanControllerBuilder.create(option)";
        }
    }

    public static class Custom
    extends YaclOptionController {
        private final String owner;
        private final String methodName;
        private final boolean builder;

        public Custom(String owner, String methodName, boolean builder) {
            super(null);
            this.owner = owner;
            this.methodName = methodName;
            this.builder = builder;
        }

        public boolean isBuilder() {
            return this.builder;
        }

        @Override
        protected void addNeededImports(Consumer<String> adder) {
            adder.accept(this.owner);
        }

        @Override
        protected String getControllerSpec(int depth) {
            return "%s.%s(option)".formatted(this.owner, this.methodName);
        }
    }
}

