/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ref.constraint;

import com.bawnorton.configurable.ref.constraint.ReferenceConstraint;

public class ClampedReferenceConstraint
extends ReferenceConstraint {
    protected final double min;
    protected final double max;

    public ClampedReferenceConstraint(double min, double max, Class<?> refHolder, Class<?> refType) {
        super(refHolder, refType);
        this.min = min;
        this.max = max;
    }

    @Override
    public Object apply(Object value) {
        try {
            double num = Double.parseDouble(value.toString());
            return num > this.max ? DEFAULT : (num < this.min ? DEFAULT : value);
        }
        catch (NumberFormatException e) {
            return DEFAULT;
        }
    }
}

