/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ref.constraint;

import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.ref.constraint.ReferenceConstraint;
import java.util.function.Predicate;

public class PredicateReferenceConstraint
extends ReferenceConstraint {
    private final Predicate<Object> predicate;

    public PredicateReferenceConstraint(Predicate<Object> predicate, Class<?> refHolder, Class<?> refType) {
        super(refHolder, refType);
        this.predicate = predicate;
    }

    @Override
    public Object apply(Object value) {
        if (this.predicate == null) {
            return value;
        }
        try {
            if (this.predicate.test(value)) {
                return value;
            }
        }
        catch (Throwable t) {
            ConfigurableMain.LOGGER.error("Could not apply predicate in \"%s\" to \"%s\"".formatted(this.refHolder, value), t);
        }
        return DEFAULT;
    }
}

