/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.minecraft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.Node;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.parser.Parser;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.parser.Rule;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.simple.SimpleMarkdownRules;
import shadow.hypherionmc.mcdiscordformatter.renderer.NodeRenderer;
import shadow.hypherionmc.mcdiscordformatter.renderer.implementation.DefaultMinecraftRenderer;
import shadow.hypherionmc.mcdiscordformatter.rules.DiscordMarkdownRules;

public class MinecraftSerializerOptions<O> {
    @NotNull
    private final Parser<Object, Node<Object>, Object> parser;
    private final List<Rule<Object, Node<Object>, Object>> rules;
    @NotNull
    private final List<NodeRenderer<O>> renderers;
    private final boolean debuggingEnabled;

    public MinecraftSerializerOptions(@NotNull Parser<Object, Node<Object>, Object> parser, List<Rule<Object, Node<Object>, Object>> rules, @NotNull List<NodeRenderer<O>> renderers, boolean debuggingEnabled) {
        this.parser = parser;
        this.rules = rules;
        this.renderers = renderers;
        this.debuggingEnabled = debuggingEnabled;
    }

    public static MinecraftSerializerOptions<class_5250> defaults() {
        return new MinecraftSerializerOptions<class_5250>(new Parser<Object, Node<Object>, Object>(), DiscordMarkdownRules.createAllRulesForDiscord(true), Collections.emptyList(), false);
    }

    public static MinecraftSerializerOptions<String> escapeDefaults() {
        ArrayList<Rule<Object, Node<Object>, Object>> rules = new ArrayList<Rule<Object, Node<Object>, Object>>();
        rules.addAll(SimpleMarkdownRules.createSimpleMarkdownRules(false));
        rules.addAll(DiscordMarkdownRules.createStyleRules());
        rules.add(SimpleMarkdownRules.createTextRule());
        return new MinecraftSerializerOptions<String>(new Parser<Object, Node<Object>, Object>(), rules, Collections.emptyList(), false);
    }

    public MinecraftSerializerOptions<O> addRenderer(NodeRenderer<O> renderer) {
        if (this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is already included in this options instance");
        }
        if (renderer.getClass().equals(DefaultMinecraftRenderer.class)) {
            throw new IllegalArgumentException("DefaultMinecraftRenderer cannot be added to serializer options");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.add(renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    public MinecraftSerializerOptions<O> addRenderer(int index, NodeRenderer<O> renderer) {
        if (this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is already included in this options instance");
        }
        if (renderer.getClass().equals(DefaultMinecraftRenderer.class)) {
            throw new IllegalArgumentException("DefaultMinecraftRenderer cannot be added to serializer options");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.add(index, renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    public MinecraftSerializerOptions<O> removeRenderer(NodeRenderer<O> renderer) {
        if (!this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is not included in this options instance");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.remove(renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    public List<NodeRenderer<O>> getRenderers() {
        return Collections.unmodifiableList(this.renderers);
    }

    public String toString() {
        return "MinecraftSerializerOptions(parser=" + this.parser + ", rules=" + this.rules + ", renderers=" + this.getRenderers() + ", debuggingEnabled=" + this.debuggingEnabled + ")";
    }

    @NotNull
    public Parser<Object, Node<Object>, Object> getParser() {
        return this.parser;
    }

    public List<Rule<Object, Node<Object>, Object>> getRules() {
        return this.rules;
    }

    public boolean isDebuggingEnabled() {
        return this.debuggingEnabled;
    }

    public MinecraftSerializerOptions<O> withParser(@NotNull Parser<Object, Node<Object>, Object> parser) {
        return this.parser == parser ? this : new MinecraftSerializerOptions<O>(parser, this.rules, this.renderers, this.debuggingEnabled);
    }

    public MinecraftSerializerOptions<O> withRules(List<Rule<Object, Node<Object>, Object>> rules) {
        return this.rules == rules ? this : new MinecraftSerializerOptions<O>(this.parser, rules, this.renderers, this.debuggingEnabled);
    }

    public MinecraftSerializerOptions<O> withDebuggingEnabled(boolean debuggingEnabled) {
        return this.debuggingEnabled == debuggingEnabled ? this : new MinecraftSerializerOptions<O>(this.parser, this.rules, this.renderers, debuggingEnabled);
    }
}

