/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.forge_imitate.event.client.ClientTickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_591;
import net.minecraft.class_7833;

public class DTNClientDogSleepOnManager {
    public static final DTNClientDogSleepOnManager INSTANCE = new DTNClientDogSleepOnManager();
    private final Map<UUID, Dog> sleeperMap = Maps.newHashMap();
    private final List<UUID> toRemove = new ArrayList<UUID>();

    public static DTNClientDogSleepOnManager get() {
        return INSTANCE;
    }

    private DTNClientDogSleepOnManager() {
    }

    public void tickClient(ClientTickEvent event) {
        if (event.phase != ClientTickEvent.Phase.END) {
            return;
        }
        this.invalidateSleeperCache();
    }

    public void invalidateSleeperCache() {
        if (this.sleeperMap.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, Dog> entry : this.sleeperMap.entrySet()) {
            Dog dog = entry.getValue();
            if (dog.method_5805()) continue;
            this.toRemove.add(entry.getKey());
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (UUID player : this.toRemove) {
            this.sleeperMap.remove(player);
        }
        this.toRemove.clear();
    }

    public void onDogSleepOnDataUpdated(Dog dog, DogSleepOnManager.DogSleepOnState state) {
        if (!state.is_sleeping()) {
            this.clearPlayerSleepOnFor(dog);
            return;
        }
        this.sleeperMap.putIfAbsent(state.sleeper(), dog);
        Optional<class_1657> sleeper_optional = DogSleepOnManager.getSleeperFromDog(dog, state);
        if (!sleeper_optional.isPresent()) {
            return;
        }
        class_1657 sleeper = sleeper_optional.get();
        if (sleeper == class_310.method_1551().field_1724) {
            DogSleepOnManager.rotatePlayerYRotToDog(dog, sleeper, state.sleep_yrot());
        }
    }

    public void clearPlayerSleepOnFor(Dog dog) {
        if (this.sleeperMap.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Dog> entry : this.sleeperMap.entrySet()) {
            if (entry.getValue() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.sleeperMap.remove(key);
        }
    }

    public boolean onLivingModelSetupRotation(class_1309 living, class_4587 stack, float anim_timeline, float yrot, float pticks) {
        Optional<class_1657> player_optional = this.checkIsSleepingOnDog((class_1297)living);
        if (!player_optional.isPresent()) {
            return false;
        }
        class_1657 player = player_optional.get();
        float facing = player.method_36454() - 180.0f;
        class_243 translate = this.calclateSleepTranslate(player);
        stack.method_22904(translate.field_1352, 0.0, translate.field_1350);
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - facing));
        stack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        return true;
    }

    private class_243 calclateSleepTranslate(class_1657 player) {
        UUID uuid = player.method_5667();
        Dog dog = this.sleeperMap.get(uuid);
        if (dog == null) {
            return class_243.field_1353;
        }
        class_243 view_vec = player.method_5828(1.0f);
        float translate_amount = player.method_18381(class_4050.field_18076) - 0.1f;
        return view_vec.method_1029().method_1021((double)(-translate_amount));
    }

    public void afterPlayerModelSetupAnim(class_1309 living, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, class_591<?> model) {
        Optional<class_1657> player_optional = this.checkIsSleepingOnDog((class_1297)living);
        if (!player_optional.isPresent()) {
            return;
        }
        model.field_3398.field_3654 += 0.6981317f;
    }

    private Optional<class_1657> checkIsSleepingOnDog(class_1297 entity) {
        if (!entity.method_41328(class_4050.field_18078)) {
            return Optional.empty();
        }
        if (this.sleeperMap.isEmpty()) {
            return Optional.empty();
        }
        if (!(entity instanceof class_1657)) {
            return Optional.empty();
        }
        class_1657 player = (class_1657)entity;
        Dog sleep_on = this.sleeperMap.get(player.method_5667());
        if (sleep_on == null) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public void afterCameraSetup(class_4184 camera, class_1297 entity) {
        if (this.sleeperMap.isEmpty()) {
            return;
        }
        Optional<class_1657> player_optional = this.checkIsSleepingOnDog(entity);
        if (!player_optional.isPresent()) {
            return;
        }
        class_1657 player = player_optional.get();
        Dog dog = this.sleeperMap.get(player.method_5667());
        camera.method_19325(dog.getSleepOnState().sleep_yrot(), 0.0f);
    }
}

