/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7184;
import net.minecraft.class_7187;
import net.minecraft.class_7833;
import org.joml.Vector3f;

public class DogModel
extends class_583<Dog> {
    public static final float[] MANE_LYING_OFF = new float[]{0.0f, 6.0f, 1.0f};
    public static final float[] MANE_SITTING_OFF = new float[]{0.0f, 2.0f, 0.0f};
    public static final float[] TAIL_LYING_OFF = new float[]{0.0f, 6.0f, 0.0f};
    public static final float[] TAIL_SITTING_OFF = new float[]{0.0f, 9.0f, -2.0f};
    public static final Vector3f DEFAULT_ROOT_PIVOT = new Vector3f(0.0f, 15.0f, 0.0f);
    public class_630 head;
    public class_630 realHead;
    public class_630 body;
    public class_630 mane;
    public class_630 legBackRight;
    public class_630 legBackLeft;
    public class_630 legFrontRight;
    public class_630 legFrontLeft;
    public class_630 tail;
    public class_630 realTail;
    public class_630 root;
    public Optional<class_630> earLeft;
    public Optional<class_630> earRight;
    Vector3f vecObj = new Vector3f();
    private float headXRot0 = 0.0f;
    private float headYRot0 = 0.0f;
    private float realHeadZRot0 = 0.0f;
    private AccessoryState accessoryState = AccessoryState.HAVE_NOT_TESTED;
    protected float wetShade = 1.0f;

    public DogModel(class_630 box) {
        this.root = box;
        this.head = box.method_32086("head");
        this.realHead = this.head.method_32086("real_head");
        this.body = box.method_32086("body");
        this.mane = box.method_32086("upper_body");
        this.legBackRight = box.method_32086("right_hind_leg");
        this.legBackLeft = box.method_32086("left_hind_leg");
        this.legFrontRight = box.method_32086("right_front_leg");
        this.legFrontLeft = box.method_32086("left_front_leg");
        this.tail = box.method_32086("tail");
        this.realTail = this.tail.method_32086("real_tail");
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    public DogModel(class_630 box, Function<class_2960, class_1921> renderType) {
        super(renderType);
        this.root = box;
        this.head = box.method_32086("head");
        this.realHead = this.head.method_32086("real_head");
        this.body = box.method_32086("body");
        this.mane = box.method_32086("upper_body");
        this.legBackRight = box.method_32086("right_hind_leg");
        this.legBackLeft = box.method_32086("left_hind_leg");
        this.legFrontRight = box.method_32086("right_front_leg");
        this.legFrontLeft = box.method_32086("left_front_leg");
        this.tail = box.method_32086("tail");
        this.realTail = this.tail.method_32086("real_tail");
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    protected void addOptionalParts(class_630 box) {
        this.earLeft = this.getChildIfPresent(this.realHead, "left_ear");
        this.earRight = this.getChildIfPresent(this.realHead, "right_ear");
    }

    protected Optional<class_630> getChildIfPresent(class_630 box, String name) {
        if (!box.method_41919(name)) {
            return Optional.empty();
        }
        return Optional.of(box.method_32086(name));
    }

    public static class_5607 createBodyLayer() {
        return DogModel.createBodyLayerInternal(class_5605.field_27715);
    }

    public boolean useDefaultModelForAccessories() {
        return false;
    }

    private static class_5607 createBodyLayerInternal(class_5605 scale) {
        class_5609 var0 = new class_5609();
        class_5610 var1 = var0.method_32111();
        float var2 = 13.5f;
        class_5610 var3 = var1.method_32117("head", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)13.5f, (float)-7.0f));
        class_5610 real_head = var3.method_32117("real_head", class_5606.method_32108().method_32101(0, 0).method_32098(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).method_32101(0, 10).method_32098(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), class_5603.field_27701);
        real_head.method_32117("right_ear", class_5606.method_32108().method_32101(16, 14).method_32098(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.method_32117("left_ear", class_5606.method_32108().method_32101(16, 14).method_32098(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.method_32117("body", class_5606.method_32108().method_32101(18, 14).method_32098(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), class_5603.method_32091((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.method_32117("upper_body", class_5606.method_32108().method_32101(21, 0).method_32098(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), class_5603.method_32091((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        class_5606 var4 = class_5606.method_32108().method_32101(0, 18).method_32098(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.method_32117("right_hind_leg", var4, class_5603.method_32090((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.method_32117("left_hind_leg", var4, class_5603.method_32090((float)1.5f, (float)16.0f, (float)7.0f));
        var1.method_32117("right_front_leg", var4, class_5603.method_32090((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.method_32117("left_front_leg", var4, class_5603.method_32090((float)1.5f, (float)16.0f, (float)-4.0f));
        class_5610 var5 = var1.method_32117("tail", class_5606.method_32108(), class_5603.method_32091((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.method_32117("real_tail", class_5606.method_32108().method_32101(9, 18).method_32098(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), class_5603.field_27701);
        return class_5607.method_32110((class_5609)var0, (int)64, (int)32);
    }

    public void prepareMobModel(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.resetAllPose();
        DogPose pose = dog.getDogPose();
        DogAnimation anim = dog.getAnim();
        if (anim != DogAnimation.NONE) {
            if (anim.freeHead() && pose.canBeg) {
                this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
            return;
        }
        switch (pose) {
            case FAINTED: {
                this.setupFaintPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case FAINTED_2: {
                this.setupFaintPose2(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case SIT: {
                this.setUpSitPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case REST: {
                this.setupRestPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case LYING_2: {
                this.setupLyingPose2(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case DROWN: {
                this.setupDrownPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case FLYING: {
                this.setupFlyPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case REST_BELLY: {
                this.setupRestBellyPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            default: {
                this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
        }
        if (pose.canShake) {
            this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canBeg) {
            this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
    }

    public void setUpStandPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = class_3532.method_15362((float)(limbSwing * 0.6662f));
        float w1 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI));
        float swing = class_3532.method_15363((float)limbSwingAmount, (float)0.0f, (float)1.0f);
        float modifier = 2.5f;
        this.body.field_3654 += this.getAnimateWalkingValue(w, swing, modifier * -5.0f * ((float)Math.PI / 180));
        this.body.field_3656 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.body.field_3655 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.mane.field_3654 += this.getAnimateWalkingValue(w, swing, modifier * 2.5f * ((float)Math.PI / 180));
        this.mane.field_3656 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.head.field_3656 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.tail.field_3656 += this.getAnimateWalkingValue(w, swing, 0.5f * modifier);
        this.tail.field_3655 += this.getAnimateWalkingValue(w, swing, -0.5f * modifier);
        if (this.earRight.isPresent()) {
            this.earRight.get().field_3654 += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earRight.get().field_3674 += this.getAnimateWalkingValue(w, swing, -0.47996554f);
            this.earRight.get().field_3656 += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().field_3654 += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earLeft.get().field_3674 += this.getAnimateWalkingValue(w, swing, 0.47996554f);
            this.earLeft.get().field_3656 += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        this.legBackRight.field_3654 += w * 1.4f * limbSwingAmount;
        this.legBackLeft.field_3654 += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.field_3654 += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.field_3654 += w * 1.4f * limbSwingAmount;
    }

    private float getAnimateWalkingValue(float w, float swingAmount, float amplitude) {
        int sign = class_3532.method_17822((double)amplitude);
        amplitude = Math.abs(amplitude);
        return (float)sign * Math.abs(amplitude * swingAmount * w);
    }

    public void setUpSitPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-9.0f, (float)-2.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.method_41920(class_7187.method_41823((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.mane.method_41922(class_7187.method_41829((float)-18.0f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-2.0f, (float)0.0f));
        this.body.method_41922(class_7187.method_41829((float)-45.0f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-4.0f, (float)-2.0f));
        this.head.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f));
    }

    public void setupFaintPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.method_41922(class_7187.method_41829((float)6.2f, (float)4.97f, (float)-2.04f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)-1.0f, (float)-0.5f));
        this.body.method_41922(class_7187.method_41829((float)2.5f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)-22.5f));
        this.legBackRight.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)-15.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)-30.0f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)-1.0f, (float)-1.0f, (float)0.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)-7.5f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)1.0f, (float)-0.25f, (float)0.0f));
        this.tail.method_41922(class_7187.method_41829((float)162.35f, (float)11.59f, (float)38.36f));
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-0.29f, (float)0.15f));
        this.mane.method_41922(class_7187.method_41829((float)7.5f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-1.0f, (float)0.75f));
        this.root.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)90.0f));
        this.root.method_41920(class_7187.method_41823((float)0.0f, (float)-5.0f, (float)0.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().method_41922(class_7187.method_41829((float)40.11192f, (float)-29.43433f, (float)-3.24563f));
            this.earRight.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.25f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().method_41922(class_7187.method_41829((float)38.7522f, (float)-4.33973f, (float)12.33768f));
            this.earLeft.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.25f, (float)0.0f));
        }
    }

    public void setupFaintPose2(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.method_41922(class_7187.method_41829((float)4.34f, (float)-4.46f, (float)16.94f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)-7.0f, (float)0.25f));
        this.body.method_41922(class_7187.method_41829((float)-7.5f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-6.5f, (float)-1.5f));
        this.mane.method_41922(class_7187.method_41829((float)-5.0f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)0.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)87.38f, (float)-17.48f, (float)0.79f));
        this.legBackRight.method_41920(class_7187.method_41823((float)0.0f, (float)-7.5f, (float)-1.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)90.0f, (float)22.5f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-7.5f, (float)-1.25f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-88.01f, (float)24.9f, (float)-2.33f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)0.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-91.14f, (float)-29.72f, (float)4.31f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-7.0f, (float)0.0f));
        this.tail.field_3654 = dog.getTailRotation();
        this.tail.method_41922(class_7187.method_41829((float)62.36f, (float)-4.65f, (float)2.29f));
        this.tail.method_41920(class_7187.method_41823((float)0.17f, (float)-7.48f, (float)-1.35f));
        if (this.earRight.isPresent()) {
            this.earRight.get().method_41922(class_7187.method_41829((float)51.29f, (float)23.61f, (float)-14.74f));
            this.earRight.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().method_41922(class_7187.method_41829((float)53.71f, (float)-14.26f, (float)10.25f));
            this.earLeft.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupRestPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.method_41922(class_7187.method_41829((float)-7.54f, (float)0.76f, (float)2.5f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)-5.0f, (float)2.0f));
        this.body.method_41922(class_7187.method_41829((float)0.5f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-6.5f, (float)0.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)-90.0f, (float)22.5f, (float)0.0f));
        this.legBackRight.method_41920(class_7187.method_41823((float)-0.5f, (float)-7.0f, (float)1.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)-90.0f, (float)-22.5f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.5f, (float)-7.0f, (float)1.0f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-87.41193f, (float)14.98539f, (float)0.66963f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)2.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-87.41193f, (float)-14.98539f, (float)-0.66963f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)2.0f));
        this.tail.field_3654 = dog.getTailRotation();
        this.tail.method_41922(class_7187.method_41829((float)0.0f, (float)-40.0f, (float)0.0f));
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-7.0f, (float)-0.25f));
        this.mane.method_41922(class_7187.method_41829((float)-2.5f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-6.5f, (float)2.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().method_41922(class_7187.method_41829((float)26.57f, (float)14.48f, (float)-26.57f));
            this.earRight.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().method_41922(class_7187.method_41829((float)26.57f, (float)-14.48f, (float)26.57f));
            this.earLeft.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupLyingPose2(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)27.5f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)2.0f));
        this.body.method_41922(class_7187.method_41829((float)0.5f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-6.5f, (float)0.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)-90.0f, (float)22.5f, (float)0.0f));
        this.legBackRight.method_41920(class_7187.method_41823((float)-0.5f, (float)-7.0f, (float)1.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)-90.0f, (float)-22.5f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.5f, (float)-7.0f, (float)1.0f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-87.41193f, (float)14.98539f, (float)0.66963f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)2.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-87.41193f, (float)-14.98539f, (float)-0.66963f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-6.75f, (float)2.0f));
        this.tail.field_3654 = dog.getTailRotation();
        this.tail.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-7.0f, (float)-0.25f));
        this.mane.method_41922(class_7187.method_41829((float)-2.5f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-6.5f, (float)2.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().method_41922(class_7187.method_41829((float)26.57f, (float)14.48f, (float)-26.57f));
            this.earRight.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().method_41922(class_7187.method_41829((float)26.57f, (float)-14.48f, (float)26.57f));
            this.earLeft.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupFlyPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.method_41922(class_7187.method_41829((float)84.84f, (float)-5.13f, (float)-5.65f));
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-1.18f, (float)-1.63f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-84.33f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-1.21f, (float)0.0f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-100.98f, (float)0.0f, (float)0.0f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.0f, (float)-1.21f, (float)0.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)78.49f, (float)0.0f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)-1.85f));
        this.legBackRight.method_41922(class_7187.method_41829((float)59.61f, (float)0.0f, (float)0.0f));
        this.legBackRight.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)-1.85f));
        this.mane.method_41922(class_7187.method_41829((float)-9.67f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-1.21f, (float)0.46f));
        this.head.method_41922(class_7187.method_41829((float)-13.12f, (float)0.0f, (float)0.0f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f));
        this.root.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.root.method_41920(class_7187.method_41823((float)0.0f, (float)2.03f, (float)0.0f));
        this.body.method_41922(class_7187.method_41829((float)1.02f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-1.03f, (float)-1.32f));
        if (this.earRight.isPresent()) {
            this.earRight.get().method_41922(class_7187.method_41829((float)-55.69f, (float)2.98f, (float)-3.43f));
            this.earRight.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.35f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().method_41922(class_7187.method_41829((float)-55.69f, (float)-2.98f, (float)3.43f));
            this.earLeft.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.35f, (float)0.0f));
        }
    }

    public void setupDrownPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.method_41922(class_7187.method_41829((float)35.0f, (float)0.0f, (float)0.0f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)0.25f));
        this.body.method_41922(class_7187.method_41829((float)-22.5f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)1.5f, (float)-2.5f));
        this.mane.method_41922(class_7187.method_41829((float)10.0f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)-3.5f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)-3.5f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.0f, (float)2.0f, (float)0.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f));
        this.tail.field_3654 = dog.getTailRotation();
        this.tail.method_41922(class_7187.method_41829((float)10.0f, (float)0.0f, (float)0.0f));
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-0.5f, (float)-2.0f));
    }

    public void setupRestBellyPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.method_41922(class_7187.method_41829((float)-38.87f, (float)-25.09f, (float)-23.41f));
        this.head.method_41920(class_7187.method_41823((float)-0.01f, (float)-1.9f, (float)0.36f));
        this.body.method_41922(class_7187.method_41829((float)-18.36f, (float)14.74f, (float)22.42f));
        this.body.method_41920(class_7187.method_41823((float)0.21f, (float)-3.81f, (float)-0.83f));
        this.legBackRight.method_41922(class_7187.method_41829((float)-26.7f, (float)14.23f, (float)47.53f));
        this.legBackRight.method_41920(class_7187.method_41823((float)-0.09f, (float)-3.49f, (float)-0.65f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)-38.05f, (float)-3.87f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.09f, (float)-6.17f, (float)-2.3f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-42.32f, (float)19.74f, (float)41.58f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)-0.5f, (float)-2.0f, (float)1.18f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-29.77f, (float)2.06f, (float)-2.6f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-2.0f, (float)0.35f));
        this.tail.method_41922(class_7187.method_41829((float)0.0f, (float)29.9f, (float)0.0f));
        this.tail.method_41920(class_7187.method_41823((float)1.24f, (float)-6.7f, (float)-1.49f));
        this.mane.method_41922(class_7187.method_41829((float)-12.78f, (float)7.97f, (float)26.29f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-2.79f, (float)0.35f));
        this.root.method_41922(class_7187.method_41829((float)22.48072f, (float)-0.95645f, (float)132.3099f));
        this.root.method_41920(class_7187.method_41823((float)2.0f, (float)-8.0f, (float)0.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().method_41922(class_7187.method_41829((float)37.09314f, (float)13.50103f, (float)-46.63682f));
            this.earRight.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.12f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().method_41922(class_7187.method_41829((float)32.49638f, (float)13.81807f, (float)-32.61916f));
            this.earLeft.get().method_41920(class_7187.method_41823((float)0.0f, (float)-0.51f, (float)0.0f));
        }
    }

    public void translateShakingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.field_3674 = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.field_3674 = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.field_3674 = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.field_3674 = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogPose pose = dog.getDogPose();
        DogAnimationManager animationManager = dog.animationManager;
        if (dog.isDogInAnimDebug() && dog.getAnim().isNone()) {
            this.setDogUpDebugAnim(dog);
            return;
        }
        if (pose.freeHead) {
            this.head.field_3654 += headPitch * ((float)Math.PI / 180);
            this.head.field_3675 = this.head.field_3675 + netHeadYaw * (dog.method_6172() && dog.isLying() ? 0.005f : (float)Math.PI / 180);
        }
        if (pose.freeTail) {
            this.tail.field_3654 = dog.getTailRotation();
            this.tail.field_3675 = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
        }
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        class_7184 sequence = this.getAnimationSequence(anim);
        if (sequence == null) {
            return;
        }
        if (pose.freeHead && anim.freeHead()) {
            this.headXRot0 = this.head.field_3654;
            this.headYRot0 = this.head.field_3675;
            this.realHeadZRot0 = this.realHead.field_3674;
        } else if (pose.freeHead && anim.freeHeadXRotOnly()) {
            this.headXRot0 = this.head.field_3654;
        }
        anim.rootRotation().ifPresent(x -> this.root.field_3675 += x.floatValue() * ((float)Math.PI / 180));
        if (animState.isStarted()) {
            animState.updateTime(ageInTicks, anim.getSpeedModifier());
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    private void setDogUpDebugAnim(Dog dog) {
        this.resetAllPose();
        DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
        DogAnimation dog_anim = debug_state.anim();
        class_7184 sequence = DogAnimationRegistry.getSequence(dog_anim);
        if (sequence == null) {
            return;
        }
        long timestamp_millis = Util.tickMayWithPartialToMillis(debug_state.timestamp());
        DogKeyframeAnimations.animate(this, dog, sequence, timestamp_millis, 1.0f, this.vecObj);
    }

    protected class_7184 getAnimationSequence(DogAnimation anim) {
        return DogAnimationRegistry.getSequence(anim);
    }

    public void resetAllPose() {
        this.root.method_32088().forEach(x -> x.method_41923());
        this.realHead.method_41923();
        this.realTail.method_41923();
        this.earLeft.ifPresent(ear -> ear.method_41923());
        this.earRight.ifPresent(ear -> ear.method_41923());
    }

    public void copyFrom(DogModel dogModel) {
        this.root.method_17138(dogModel.root);
        this.head.method_17138(dogModel.head);
        this.realHead.method_17138(dogModel.realHead);
        this.body.method_17138(dogModel.body);
        this.mane.method_17138(dogModel.mane);
        this.legBackRight.method_17138(dogModel.legBackRight);
        this.legBackLeft.method_17138(dogModel.legBackLeft);
        this.legFrontRight.method_17138(dogModel.legFrontRight);
        this.legFrontLeft.method_17138(dogModel.legFrontLeft);
        this.tail.method_17138(dogModel.tail);
        this.realTail.method_17138(dogModel.realTail);
    }

    public void resetPart(class_630 part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail()) {
            this.tail.method_41923();
            this.tail.field_3654 = dog.getTailRotation();
            return;
        }
        if (part == this.head && dog.getAnim().freeHead() && dog.getDogPose().freeHead) {
            this.head.method_41923();
            this.head.field_3654 = this.headXRot0;
            this.head.field_3675 = this.headYRot0;
            this.realHead.method_41923();
            this.realHead.field_3674 = this.realHeadZRot0;
            return;
        }
        if (part == this.head && dog.getAnim().convertHeadZRot()) {
            this.head.method_41923();
            this.head.field_3654 = this.headXRot0;
            return;
        }
        part.method_41923();
    }

    public void adjustAnimatedPart(class_630 part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail() && part.field_3654 > 3.0f) {
            part.field_3654 = 3.0f;
        }
        if (part == this.head && part.field_3674 != 0.0f && dog.getAnim().convertHeadZRot()) {
            this.realHead.field_3674 = part.field_3674;
            part.field_3674 = 0.0f;
        }
    }

    public Optional<class_630> searchForPartWithName(String name) {
        return DogKeyframeAnimations.searchForPartWithName(this.root, name);
    }

    protected void correctInitalPose() {
        class_5603 tailPose = this.tail.method_41921();
        float tailX = tailPose.field_27702;
        float tailY = tailPose.field_27703;
        float tailZ = tailPose.field_27704;
        this.tail.method_41918(class_5603.method_32090((float)tailX, (float)tailY, (float)tailZ));
    }

    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        return true;
    }

    public boolean armorShouldRender(Dog dog) {
        return true;
    }

    public boolean incapShouldRender(Dog dog) {
        return true;
    }

    public boolean scaleBabyDog() {
        return true;
    }

    public boolean warnAccessory(Dog dog, Accessory inst) {
        return false;
    }

    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return null;
    }

    public boolean hasDefaultScale() {
        return false;
    }

    public float getDefaultScale() {
        return 1.0f;
    }

    public AccessoryState getAccessoryState() {
        return this.accessoryState;
    }

    public DogModel setAccessoryState(AccessoryState state) {
        if (state == null) {
            state = AccessoryState.HAVE_NOT_TESTED;
        }
        this.accessoryState = state;
        return this;
    }

    public void setVisible(boolean visible) {
        this.head.field_3665 = visible;
        this.body.field_3665 = visible;
        this.legBackRight.field_3665 = visible;
        this.legBackLeft.field_3665 = visible;
        this.legFrontRight.field_3665 = visible;
        this.legFrontLeft.field_3665 = visible;
        this.tail.field_3665 = visible;
        this.mane.field_3665 = visible;
    }

    public void method_17081(class_583<Dog> model) {
        super.method_17081(model);
        if (!this.scaleBabyDog()) {
            model.field_3448 = false;
        }
    }

    public void setWetShade(float shade) {
        this.wetShade = shade;
    }

    public void resetWetShade() {
        this.wetShade = 1.0f;
    }

    public void method_2828(class_4587 p_102034_, class_4588 p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        p_102038_ *= this.wetShade;
        p_102039_ *= this.wetShade;
        p_102040_ *= this.wetShade;
        Vector3f pivot = DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = this.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            pivot = custom_pivot;
        }
        p_102034_.method_22903();
        p_102034_.method_22904((double)(this.root.field_3657 / 16.0f), (double)(this.root.field_3656 / 16.0f), (double)(this.root.field_3655 / 16.0f));
        p_102034_.method_22904((double)(pivot.x / 16.0f), (double)(pivot.y / 16.0f), (double)(pivot.z / 16.0f));
        if (this.root.field_3674 != 0.0f) {
            p_102034_.method_22907(class_7833.field_40718.rotation(this.root.field_3674));
        }
        if (this.root.field_3675 != 0.0f) {
            p_102034_.method_22907(class_7833.field_40716.rotation(this.root.field_3675));
        }
        if (this.root.field_3654 != 0.0f) {
            p_102034_.method_22907(class_7833.field_40714.rotation(this.root.field_3654));
        }
        float xRot0 = this.root.field_3654;
        float yRot0 = this.root.field_3675;
        float zRot0 = this.root.field_3674;
        float x0 = this.root.field_3657;
        float y0 = this.root.field_3656;
        float z0 = this.root.field_3655;
        this.root.field_3654 = 0.0f;
        this.root.field_3675 = 0.0f;
        this.root.field_3674 = 0.0f;
        this.root.field_3657 = 0.0f;
        this.root.field_3656 = 0.0f;
        this.root.field_3655 = 0.0f;
        p_102034_.method_22903();
        p_102034_.method_22904((double)(-pivot.x / 16.0f), (double)(-pivot.y / 16.0f), (double)(-pivot.z / 16.0f));
        if (this.field_3448 && this.scaleBabyDog()) {
            boolean headVisible0 = this.head.field_3665;
            this.head.field_3665 = false;
            p_102034_.method_22903();
            this.root.method_22699(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.method_22909();
            this.head.field_3665 = headVisible0;
            p_102034_.method_22903();
            p_102034_.method_22905(2.0f, 2.0f, 2.0f);
            p_102034_.method_22904(0.0, -0.5, 0.15);
            this.head.method_22699(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
            p_102034_.method_22909();
        } else {
            this.root.method_22699(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
        }
        p_102034_.method_22909();
        p_102034_.method_22909();
        this.root.field_3654 = xRot0;
        this.root.field_3675 = yRot0;
        this.root.field_3674 = zRot0;
        this.root.field_3657 = x0;
        this.root.field_3656 = y0;
        this.root.field_3655 = z0;
    }

    public static enum AccessoryState {
        NON_COMPATIBLE,
        SOME_WILL_FIT,
        HAVE_NOT_TESTED,
        RECOMMENDED,
        MODEL_ONLY;

    }
}

