/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.world;

import doggytalents.client.entity.render.RenderUtil;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.event.client.ClientTickEvent;
import doggytalents.forge_imitate.event.client.RenderLevelStageEvent;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class CanineTrackerLocateRenderer {
    private static class_2960 DEFAULT_0 = new class_2960("default/0");
    private static boolean locating;
    private static UUID locatingUUID;
    private static String locatingName;
    private static class_2338 locatingPos;
    private static int locateColor;
    private static WeakReference<Dog> cachedDog;

    public static void onWorldRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!locating) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_7325()) {
            return;
        }
        class_243 dog_pos = null;
        if (cachedDog.get() != null) {
            double d0 = class_3532.method_16436((double)event.getPartialTick(), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).field_6038, (double)((Dog)cachedDog.get()).method_23317());
            double d1 = class_3532.method_16436((double)event.getPartialTick(), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).field_5971, (double)((Dog)cachedDog.get()).method_23318());
            double d2 = class_3532.method_16436((double)event.getPartialTick(), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).field_5989, (double)((Dog)cachedDog.get()).method_23321());
            dog_pos = new class_243(d0, d1 + 1.0, d2);
        } else {
            dog_pos = new class_243((double)locatingPos.method_10263(), (double)(locatingPos.method_10264() + 1), (double)locatingPos.method_10260());
        }
        class_4184 camera = event.getCamera();
        class_243 camera_pos = camera.method_19326().method_1031(0.0, -0.2, 0.0);
        class_243 off_dog_camera = dog_pos.method_1020(camera_pos);
        double d_dog_camera = off_dog_camera.method_1033();
        class_243 off_txt = off_dog_camera;
        if (d_dog_camera > 5.0) {
            off_txt = off_txt.method_1029().method_1021(5.0);
        }
        CanineTrackerLocateRenderer.drawFloatingDistanceText(locatingName, event.getPoseStack(), d_dog_camera, off_txt, camera);
    }

    public static void onWorldLogOut() {
        CanineTrackerLocateRenderer.stopLocating();
    }

    public static void drawFloatingDistanceText(String name, class_4587 stack, double distance, class_243 off_from_player, class_4184 camera) {
        stack.method_22903();
        stack.method_22904(off_from_player.method_10216(), off_from_player.method_10214(), off_from_player.method_10215());
        stack.method_22907(camera.method_23767());
        stack.method_22905(-0.02f, -0.02f, 0.02f);
        class_327 font = class_310.method_1551().field_1772;
        Object dog_name = name;
        if (((String)dog_name).length() > 14) {
            dog_name = ((String)dog_name).substring(0, 14) + "..";
        }
        int hl_color = CanineTrackerLocateRenderer.getHighlightColor(distance);
        class_5250 line1 = class_2561.method_43469((String)"item.doggytalents.radar.locate.line1", (Object[])new Object[]{class_2561.method_43470((String)dog_name).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)))});
        class_5250 line2 = null;
        line2 = distance < 5.0 ? class_2561.method_43471((String)"item.doggytalents.radar.locate.line2.close").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(hl_color)) : class_2561.method_43469((String)"item.doggytalents.radar.locate.line2.far", (Object[])new Object[]{class_2561.method_43470((String)("" + class_3532.method_15384((double)distance))).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(hl_color))});
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        bufferSource.getBuffer(class_1921.method_23028((class_2960)Resources.SMALL_WIDGETS));
        float tX = -font.method_27525((class_5348)line1) / 2;
        float tY = 0.0f;
        font.method_30882((class_2561)line1, tX, tY, -1, false, stack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        tX = -font.method_27525((class_5348)line2) / 2;
        Objects.requireNonNull(font);
        font.method_30882((class_2561)line2, tX, tY += (float)(9 + 3), -1, false, stack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        bufferSource.method_37104();
        stack.method_22909();
    }

    public static int getHighlightColor(double distance) {
        int main_color = locateColor == 0 ? -5586 : locateColor;
        int[] main_color3 = Util.rgbIntToIntArray(main_color);
        if (distance >= 160.0) {
            return -1;
        }
        if ((distance -= 32.0) <= 0.0) {
            return main_color;
        }
        double progress = class_3532.method_15350((double)((128.0 - distance) / 128.0), (double)0.0, (double)1.0);
        int[] color = new int[]{255, 255, 255};
        color[0] = (int)((double)color[0] + (double)(main_color3[0] - 255) * progress);
        color[1] = (int)((double)color[1] + (double)(main_color3[1] - 255) * progress);
        color[2] = (int)((double)color[2] + (double)(main_color3[2] - 255) * progress);
        return 0xFF000000 | RenderUtil.rgbToInt(color);
    }

    public static void tickUpdate(ClientTickEvent event) {
        if (event.phase != ClientTickEvent.Phase.END) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1687 == null) {
            return;
        }
        if (player.field_6012 % 4 != 0) {
            return;
        }
        Optional<class_2487> tagOptional = CanineTrackerLocateRenderer.getRadarTagIfHoldingAndExist((class_1657)player);
        if (locating) {
            if (tagOptional.isEmpty()) {
                CanineTrackerLocateRenderer.stopLocating();
                return;
            }
            class_2487 tag = tagOptional.get();
            if (!tag.method_25926("uuid").equals(locatingUUID)) {
                CanineTrackerLocateRenderer.setLocating(tag);
            }
            CanineTrackerLocateRenderer.updateCache((class_1657)player);
            if (player.field_6012 % 256 == 0) {
                CanineTrackerLocateRenderer.requestServerForPosUpdate();
            }
        } else {
            if (tagOptional.isEmpty()) {
                return;
            }
            class_2487 tag = tagOptional.get();
            CanineTrackerLocateRenderer.setLocating(tag);
        }
    }

    private static void updateCache(class_1657 player) {
        if (cachedDog.get() != null && (((Dog)cachedDog.get()).method_31481() || !((Dog)cachedDog.get()).method_5667().equals(locatingUUID))) {
            cachedDog = new WeakReference<Object>(null);
        }
        if (locatingUUID == null || player.field_6012 % 8 != 0) {
            return;
        }
        List dogs = player.method_37908().method_8390(Dog.class, player.method_5829().method_1009(24.0, 8.0, 24.0), dog -> dog.method_5667().equals(locatingUUID));
        if (!dogs.isEmpty()) {
            cachedDog = new WeakReference<Dog>((Dog)dogs.get(0));
        }
    }

    private static Optional<class_2487> getRadarTagIfHoldingAndExist(class_1657 player) {
        class_1799 item_main = player.method_5998(class_1268.field_5808);
        class_1799 item_off = player.method_5998(class_1268.field_5810);
        class_1799 radar = null;
        if (item_main.method_7909() instanceof CanineTrackerItem) {
            radar = item_main;
        } else if (item_off.method_7909() instanceof CanineTrackerItem) {
            radar = item_off;
        }
        if (radar == null) {
            return Optional.empty();
        }
        if (!radar.method_7985()) {
            return Optional.empty();
        }
        class_2487 tag = radar.method_7969();
        if (tag == null || !tag.method_25928("uuid")) {
            return Optional.empty();
        }
        return Optional.of(tag);
    }

    private static void requestServerForPosUpdate() {
        if (locatingUUID == null) {
            return;
        }
        if (locatingPos == null) {
            return;
        }
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestPosUpdateData(locatingUUID, locatingPos));
    }

    public static void correctPos(UUID uuid, class_2338 pos) {
        if (!locating) {
            return;
        }
        if (uuid == null) {
            return;
        }
        if (!uuid.equals(locatingUUID)) {
            return;
        }
        locatingPos = pos;
    }

    public static void setLocating(class_2487 tag) {
        UUID uuid = tag.method_25926("uuid");
        String name = tag.method_10558("name");
        int posX = tag.method_10550("posX");
        int posY = tag.method_10550("posY");
        int posZ = tag.method_10550("posZ");
        int color = tag.method_10550("locateColor");
        CanineTrackerLocateRenderer.setLocating(uuid, name, new class_2338(posX, posY, posZ), color);
    }

    public static void setLocating(UUID id, String name, class_2338 pos, int color) {
        if (id == null || name == null || pos == null) {
            return;
        }
        locating = true;
        locatingUUID = id;
        locatingName = name;
        locatingPos = pos;
        locateColor = color;
        if (cachedDog.get() != null && (((Dog)cachedDog.get()).method_31481() || !((Dog)cachedDog.get()).method_5667().equals(locatingUUID))) {
            cachedDog = new WeakReference<Object>(null);
        }
    }

    public static void stopLocating() {
        locating = false;
        locatingUUID = null;
        locatingName = null;
        locatingPos = null;
        locateColor = 0;
        cachedDog = new WeakReference<Object>(null);
    }

    static {
        cachedDog = new WeakReference<Object>(null);
    }
}

