/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByNameData;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class HeelByNameScreen
extends StringEntrySelectScreen {
    private final class_1657 player;
    private final List<String> dogNameList = new ArrayList<String>();
    private final List<Integer> dogIdList = new ArrayList<Integer>();
    private boolean showUuid = false;
    private boolean heelAndSit = false;
    private boolean softHeel = false;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;

    public HeelByNameScreen(class_1657 player, boolean softHeel) {
        super((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name"));
        this.player = player;
        this.softHeel = softHeel;
        List<Dog> dogsList = class_310.method_1551().field_1687.method_8390(Dog.class, this.player.method_5829().method_1009(100.0, 50.0, 100.0), d -> d.method_6171((class_1309)player));
        dogsList = FrequentHeelStore.get(this).sortDogList(dogsList);
        for (Dog d2 : dogsList) {
            this.dogNameList.add(d2.method_5477().getString());
            this.dogIdList.add(d2.method_5628());
        }
        this.updateEntries(this.dogNameList);
    }

    public static void open() {
        HeelByNameScreen.open(0);
    }

    public static void open(int blockCharInputMillis) {
        class_310 mc = class_310.method_1551();
        class_1799 stack = mc.field_1724.method_5998(class_1268.field_5808);
        if (stack == null) {
            return;
        }
        if (!(stack.method_7909() instanceof WhistleItem)) {
            return;
        }
        boolean softHeel = false;
        if (stack.method_7985()) {
            softHeel = stack.method_7969().method_10577("soft_heel");
        }
        HeelByNameScreen screen = new HeelByNameScreen((class_1657)mc.field_1724, softHeel);
        screen.setBlockCharInputTime(blockCharInputMillis);
        mc.method_1507((class_437)screen);
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.field_22789 / 2;
        int mY = this.field_22790 / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(0, pY, 60, 20, (class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.method_25355((class_2561)class_2561.method_43471((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        showUuid.method_46421(mX - 100 - showUuid.method_25368() - 2);
        String soft_heel_title_id = "doggytalents.screen.whistler.heel_by_name.soft_heel";
        class_5250 inital_softHeel_c1 = this.softHeel ? class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").method_27696(class_2583.field_24360.method_36139(this.getHightlightSelectedColor())) : class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.soft_heel");
        FlatButton softHeel = new FlatButton(0, pY += showUuid.method_25364() + 2, 60, 20, (class_2561)inital_softHeel_c1, b -> {
            boolean bl = this.softHeel = !this.softHeel;
            if (this.softHeel) {
                b.method_25355((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").method_27696(class_2583.field_24360.method_36139(this.getHightlightSelectedColor())));
            } else {
                b.method_25355((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.soft_heel"));
            }
        }){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float pTicks) {
                super.method_25394(graphics, mouseX, mouseY, pTicks);
                if (!this.field_22762) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                String str = class_1074.method_4662((String)"doggytalents.screen.whistler.heel_by_name.soft_heel.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByNameScreen.this.field_22793));
                graphics.method_51434(HeelByNameScreen.this.field_22793, list, mouseX, mouseY);
            }
        };
        softHeel.method_46421(mX - 100 - softHeel.method_25368() - 2);
        FlatButton help = new FlatButton(0, pY += softHeel.method_25364() + 2, 20, 20, (class_2561)class_2561.method_43470((String)"?"), b -> {}){

            @Override
            public void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
                super.method_48579(graphics, mouseX, mouseY, pTicks);
                if (!this.field_22762) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(class_2561.method_43471((String)"doggytalents.screen.whistler.heel_by_name.help_title").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                String base_help = class_1074.method_4662((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(base_help, 150, HeelByNameScreen.this.field_22793));
                String additional_help = class_1074.method_4662((String)"doggytalents.screen.whistler.heel_by_name.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(additional_help, 150, HeelByNameScreen.this.field_22793));
                graphics.method_51434(HeelByNameScreen.this.field_22793, list, mouseX, mouseY);
            }
        };
        help.method_46421(mX - 100 - help.method_25368() - 2);
        this.method_37063((class_364)showUuid);
        this.method_37063((class_364)help);
        this.method_37063((class_364)softHeel);
    }

    @Override
    protected void drawNoEntryMsg(class_332 graphics, int x, int y) {
        graphics.method_25303(this.field_22793, class_1074.method_4662((String)"doggytalents.screen.whistler.heel_by_name.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected class_2561 modifyEntryText(class_2561 entryText, int entryId, boolean is_selected) {
        if (this.heelAndSit && is_selected) {
            entryText = entryText.method_27661().method_27696(class_2583.field_24360.method_36139(0xFF6F00));
        }
        return entryText;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        Integer dog_id = this.dogIdList.get(entry_id);
        class_1297 dog = this.field_22787.field_1687.method_8469(dog_id.intValue());
        if (dog == null) {
            return;
        }
        String uuid = dog.method_5845();
        if (uuid == null) {
            return;
        }
        class_5250 uuid_c1 = class_2561.method_43470((String)uuid.toString()).method_27692(class_124.field_1080);
        if (this.field_22790 >= 273) {
            int mX = this.field_22789 / 2;
            int mY = this.field_22790 / 2;
            int uuid_width = this.field_22793.method_27525((class_5348)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.method_27535(this.field_22793, (class_2561)uuid_c1, tX, tY, -1);
        } else {
            graphics.method_51434(this.field_22793, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestHeel(this.dogIdList.get(id));
        class_310.method_1551().method_1507(null);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private void requestHeel(int id) {
        FrequentHeelStore.get(this).pushDogToFrequentStack(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByNameData(id, this.heelAndSit, this.softHeel));
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private static class FrequentHeelStore {
        private static FrequentHeelStore INSTANCE;
        private ArrayList<UUID> dogFrequentStack = new ArrayList();
        private class_437 screen;
        private ToIntFunction<Dog> GET_FREQ_COUNT = d -> this.getFrequentWeightFor((Dog)d);
        private static final int STORE_CAP = 32;

        private FrequentHeelStore(class_437 screen) {
            this.screen = screen;
        }

        public void pushDogToFrequentStack(int id) {
            class_1297 dog = class_310.method_1551().field_1687.method_8469(id);
            if (dog == null) {
                return;
            }
            String uuid_str = dog.method_5845();
            if (uuid_str == null) {
                return;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            if (indx > 0) {
                if (indx >= this.dogFrequentStack.size() - 1) {
                    return;
                }
                this.dogFrequentStack.remove(uuid);
            }
            this.dogFrequentStack.add(uuid);
            if (this.dogFrequentStack.size() > 32) {
                this.dogFrequentStack.remove(0);
            }
        }

        public int getFrequentWeightFor(Dog dog) {
            String uuid_str = dog.method_5845();
            if (uuid_str == null) {
                return 0;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return 0;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            return Math.max(0, indx + 1);
        }

        public List<Dog> sortDogList(List<Dog> dogList) {
            return dogList.stream().sorted(Comparator.comparingInt(this.GET_FREQ_COUNT).reversed()).collect(Collectors.toList());
        }

        public static FrequentHeelStore get(class_437 screen) {
            if (INSTANCE == null) {
                INSTANCE = new FrequentHeelStore(screen);
            }
            if (FrequentHeelStore.INSTANCE.screen != screen) {
                FrequentHeelStore.INSTANCE.screen = screen;
            }
            return INSTANCE;
        }
    }
}

