/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.element;

import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import java.util.List;
import net.minecraft.class_3532;
import net.minecraft.class_364;

public class ElementSize {
    AbstractElement element;
    int width;
    int height;
    float widthRatio;
    float heightRatio;
    SizeType type;
    boolean isDynamic = false;

    private ElementSize(AbstractElement element) {
        this.element = element;
    }

    public ElementSize(AbstractElement element, int width, int height) {
        this.element = element;
        this.type = SizeType.ABSOLUTE;
        this.width = width;
        this.height = height;
    }

    public ElementSize(AbstractElement element, float ratioX, float ratioY) {
        this.element = element;
        this.type = SizeType.RELATIVE;
        this.widthRatio = ratioX;
        this.heightRatio = ratioY;
        AbstractElement p = element.getParent();
        if (p != null) {
            this.width = class_3532.method_15375((float)((float)p.getSize().width * this.widthRatio));
            this.height = class_3532.method_15375((float)((float)p.getSize().height * this.heightRatio));
        }
    }

    public ElementSize(AbstractElement element, int width, float ratioY) {
        this.element = element;
        this.type = SizeType.RELATIVE;
        this.heightRatio = ratioY;
        AbstractElement p = element.getParent();
        if (p != null) {
            this.height = class_3532.method_15375((float)((float)p.getSize().height * this.heightRatio));
        }
        this.width = width;
    }

    public ElementSize(AbstractElement element, float ratioX, int height) {
        this.element = element;
        this.type = SizeType.RELATIVE;
        this.widthRatio = ratioX;
        AbstractElement p = element.getParent();
        if (p != null) {
            this.width = class_3532.method_15375((float)((float)p.getSize().width * this.widthRatio));
        }
        this.height = height;
    }

    public ElementSize(AbstractElement element, int size) {
        this.element = element;
        this.type = SizeType.ABSOLUTE;
        this.width = size;
        this.height = size;
    }

    public static ElementSize createDynamicX(AbstractElement element, int sizeY) {
        ElementSize ret = new ElementSize(element);
        ret.type = SizeType.DYNAMIC_X;
        ret.height = sizeY;
        ret.isDynamic = true;
        return ret;
    }

    public static ElementSize createDynamicY(AbstractElement element, int sizeX) {
        ElementSize ret = new ElementSize(element);
        ret.type = SizeType.DYNAMIC_Y;
        ret.width = sizeX;
        ret.isDynamic = true;
        return ret;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void updateSize() {
        if (this.type == SizeType.DYNAMIC_X) {
            this.width = 0;
            List<? extends class_364> childs = this.element.method_25396();
            for (class_364 class_3642 : childs) {
                AbstractElement element;
                if (!(class_3642 instanceof AbstractElement) || (element = (AbstractElement)class_3642).getPosition().getType() != ElementPosition.PosType.RELATIVE) continue;
                this.width += element.getSizeX();
            }
            AbstractElement p = this.element.getParent();
            if (p == null) {
                return;
            }
            ElementSize elementSize = p.getSize();
            if (elementSize.isDynamic()) {
                elementSize.updateSize();
            }
        } else if (this.type == SizeType.DYNAMIC_Y) {
            this.height = 0;
            List<? extends class_364> childs = this.element.method_25396();
            for (class_364 class_3643 : childs) {
                AbstractElement element;
                if (!(class_3643 instanceof AbstractElement) || (element = (AbstractElement)class_3643).getPosition().getType() != ElementPosition.PosType.RELATIVE) continue;
                this.height += element.getSizeY();
            }
            AbstractElement p = this.element.getParent();
            if (p == null) {
                return;
            }
            ElementSize elementSize = p.getSize();
            if (elementSize.isDynamic()) {
                elementSize.updateSize();
            }
        }
    }

    public static ElementSize getDefault(AbstractElement element) {
        return new ElementSize(element, 0);
    }

    public static enum SizeType {
        ABSOLUTE,
        RELATIVE,
        DYNAMIC_X,
        DYNAMIC_Y;

    }
}

