/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;

public class DogBathBlockEntity
extends class_2586 {
    public int tickTillProvoke = 10;

    public DogBathBlockEntity(class_2338 pos, class_2680 blockState) {
        super(DoggyTileEntityTypes.DOG_BATH.get(), pos, blockState);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 blockState, class_2586 blockEntity) {
        if (level == null) {
            return;
        }
        if (level.field_9236) {
            return;
        }
        if (!(blockEntity instanceof DogBathBlockEntity)) {
            return;
        }
        DogBathBlockEntity bath = (DogBathBlockEntity)blockEntity;
        if (--bath.tickTillProvoke > 0) {
            return;
        }
        bath.tickTillProvoke = 10;
        List dogList = level.method_18467(Dog.class, new class_238(pos).method_1009(5.0, 3.0, 5.0));
        if (dogList.isEmpty()) {
            return;
        }
        for (Dog dog : dogList) {
            if (dog.isBusy() || !dog.isDoingFine() || dog.method_24345() || dog.method_6172() || dog.getAnim() != DogAnimation.NONE || (double)dog.method_6051().method_43057() >= 0.02) continue;
            dog.triggerAction(new DogDrinkFromFoodBowl(dog, bath));
            bath.tickTillProvoke += 40 + dog.method_6051().method_43048(61);
            break;
        }
    }

    public static class DogDrinkFromFoodBowl
    extends TriggerableAction {
        private final DogBathBlockEntity bath;
        private int tickTillPathRecalc;
        private int goToBowlTimeout = 0;
        private boolean isDoingAnim;
        private int stopTick;
        private int animTick;

        public DogDrinkFromFoodBowl(Dog dog, DogBathBlockEntity bath) {
            super(dog, false, false);
            this.bath = bath;
        }

        @Override
        public void onStart() {
            this.goToBowlTimeout = 200;
            this.isDoingAnim = false;
            this.animTick = 0;
        }

        @Override
        public void tick() {
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isDoingAnim) {
                if (!this.stillInDrinkDistance()) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
                if (this.dog.getAnim() != DogAnimation.DRINK_WATER) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
                if (this.dog.field_6012 >= this.stopTick) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            } else {
                boolean dist_can_start_drinking = this.distCanStartDrinking();
                if (!dist_can_start_drinking) {
                    --this.goToBowlTimeout;
                }
                if (this.goToBowlTimeout <= 0 && !dist_can_start_drinking) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            }
            class_243 bowlPos = this.getBowPos();
            this.dog.method_5988().method_6230(bowlPos.field_1352, bowlPos.field_1351, bowlPos.field_1350, 10.0f, (float)this.dog.method_5978());
            if (this.isDoingAnim) {
                this.doAnim();
            } else {
                this.moveToBowl(this.distCanStartDrinking());
            }
        }

        private void moveToBowl(boolean is_close_to_bowl) {
            if (is_close_to_bowl) {
                this.isDoingAnim = true;
                this.dog.setAnim(DogAnimation.DRINK_WATER);
                this.stopTick = this.dog.field_6012 + DogAnimation.DRINK_WATER.getLengthTicks();
                this.dog.method_5942().method_6340();
                return;
            }
            class_243 bowlPos = this.getBowPos();
            if (--this.tickTillPathRecalc <= 0) {
                this.tickTillPathRecalc = 10;
                if (!this.dog.method_5934() && !this.dog.method_5765()) {
                    this.dog.method_5942().method_6337(bowlPos.field_1352, bowlPos.field_1351, bowlPos.field_1350, (double)this.dog.getUrgentSpeedModifier());
                }
            }
        }

        private void doAnim() {
            class_1937 class_19372;
            ++this.animTick;
            if (5 <= this.animTick && this.animTick <= 35 && this.animTick % 4 == 0) {
                this.dog.method_5783(class_3417.field_20613, 0.2f, this.dog.method_37908().field_9229.method_43057() * 0.1f + 0.9f);
            }
            if (this.animTick == 50 && (class_19372 = this.dog.method_37908()) instanceof class_3218) {
                class_3218 sLevel = (class_3218)class_19372;
                sLevel.method_14199((class_2394)class_2398.field_11202, this.dog.method_23317(), this.dog.method_23318(), this.dog.method_23321(), 10, (double)this.dog.method_17681(), (double)0.8f, (double)this.dog.method_17681(), 0.1);
            }
            float backward_strafe_dist = 0.6f;
            if (this.getBowlDistanceSqr() < (double)(backward_strafe_dist * backward_strafe_dist)) {
                this.dog.method_5962().method_6243(-0.5f, 0.0f);
            }
        }

        @Override
        public void onStop() {
            if (this.dog.getAnim() == DogAnimation.DRINK_WATER) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }

        private boolean stillValidTarget() {
            if (this.bath.method_11015()) {
                return false;
            }
            return !(this.getBowlDistanceSqr() > 256.0);
        }

        private boolean distCanStartDrinking() {
            double max_dist = (double)(this.dog.method_17681() / 2.0f) + 0.5;
            return this.getBowlDistanceSqr() <= max_dist * max_dist;
        }

        private boolean stillInDrinkDistance() {
            double max_dist = (double)(this.dog.method_17681() / 2.0f) + 0.5 + 0.3;
            return this.getBowlDistanceSqr() <= max_dist * max_dist;
        }

        private double getBowlDistanceSqr() {
            class_243 bowlPos = this.getBowPos();
            return this.dog.method_5707(bowlPos);
        }

        private class_243 getBowPos() {
            return class_243.method_24955((class_2382)this.bath.method_11016());
        }
    }
}

