/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.util.DogFoodUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;

public class FoodBowlTileEntity
extends PlacedTileEntity
implements class_3908 {
    private final ItemStackHandler inventory = new ItemStackHandler(5){

        @Override
        protected void onContentsChanged() {
            FoodBowlTileEntity.this.method_5431();
        }

        @Override
        public boolean method_5437(int slotId, @Nonnull class_1799 stack) {
            return FoodHandler.isFood(stack).isPresent();
        }
    };
    public int timeoutCounter;

    public FoodBowlTileEntity(class_2338 pos, class_2680 blockState) {
        super(DoggyTileEntityTypes.FOOD_BOWL.get(), pos, blockState);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.inventory.deserializeNBT(compound);
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10543(this.inventory.serializeNBT());
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 blockState, class_2586 blockEntity) {
        if (level == null) {
            return;
        }
        if (level.field_9236) {
            return;
        }
        if (!(blockEntity instanceof FoodBowlTileEntity)) {
            return;
        }
        FoodBowlTileEntity bowl = (FoodBowlTileEntity)blockEntity;
        if (++bowl.timeoutCounter < 20) {
            return;
        }
        List dogList = level.method_18467(Dog.class, new class_238(pos).method_1009(5.0, 5.0, 5.0));
        for (Dog dog : dogList) {
            if (!dog.isDoingFine()) continue;
            UUID placerId = bowl.getPlacerId();
            if (placerId != null && !dog.getBowlPos().isPresent() && placerId.equals(dog.method_6139())) {
                dog.setBowlPos(bowl.method_11016());
            }
            if (!bowl.shouldFeed(dog)) continue;
            dog.triggerAction(new DogEatFromFoodBowl(dog, bowl));
        }
        bowl.timeoutCounter = 0;
    }

    private boolean shouldFeed(Dog target) {
        if (target.isBusy()) {
            return false;
        }
        if (target.method_6172()) {
            return false;
        }
        if (target.method_24345()) {
            return false;
        }
        if (!this.hasFood(target)) {
            return false;
        }
        return this.isHungryDog(target);
    }

    private boolean isHungryDog(Dog dog) {
        return dog.isDoingFine() && dog.getDogHunger() < 25.0f;
    }

    public boolean hasFood(Dog dog) {
        return DogFoodUtil.dogFindFoodInInv(dog, false, this.getInventory()) >= 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.doggytalents.food_bowl");
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 playerIn) {
        return new FoodBowlContainer(windowId, this.field_11863, this.field_11867, playerInventory, playerIn);
    }

    public static class DogEatFromFoodBowl
    extends TriggerableAction {
        private final FoodBowlTileEntity bowl;
        private int tickTillPathRecalc;
        private boolean enoughHealingFood = false;
        private int goToBowlTimeout = 0;
        private int feedCooldown = 0;
        private boolean failedEating = false;

        public DogEatFromFoodBowl(Dog dog, FoodBowlTileEntity bowl) {
            super(dog, false, false);
            this.bowl = bowl;
        }

        @Override
        public void onStart() {
            this.goToBowlTimeout = 200;
        }

        @Override
        public void tick() {
            boolean is_close_to_bowl;
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.enoughEating()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.failedEating) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = is_close_to_bowl = this.getBowlDistanceSqr() <= 2.25;
            if (!is_close_to_bowl) {
                --this.goToBowlTimeout;
            }
            if (this.goToBowlTimeout <= 0 && !is_close_to_bowl) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.feedCooldown > 0) {
                --this.feedCooldown;
            }
            if (!is_close_to_bowl) {
                class_243 bowlPos = this.getBowPos();
                this.dog.method_5988().method_6230(bowlPos.field_1352, bowlPos.field_1351, bowlPos.field_1350, 10.0f, (float)this.dog.method_5978());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.method_5934() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6337(bowlPos.field_1352, bowlPos.field_1351, bowlPos.field_1350, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.method_5942().method_6340();
                this.checkAndEat();
            }
        }

        @Override
        public void onStop() {
        }

        private boolean enoughEating() {
            float hunger = this.dog.getDogHunger();
            if (hunger < 80.0f) {
                return false;
            }
            return !this.dog.isDogLowHealth() || !(hunger < this.dog.getMaxHunger());
        }

        private void checkAndEat() {
            boolean dogNeedsHealing;
            if (this.feedCooldown > 0) {
                return;
            }
            boolean bl = dogNeedsHealing = this.dog.isDogLowHealth() && !this.dog.method_6059(class_1294.field_5924);
            if (!this.enoughHealingFood && dogNeedsHealing) {
                this.enoughHealingFood = true;
                this.failedEating = !DogFoodUtil.tryFeed(this.dog, true, this.bowl.getInventory());
            } else {
                this.failedEating = !DogFoodUtil.tryFeed(this.dog, false, this.bowl.getInventory());
            }
            this.feedCooldown = this.dog.method_6051().method_43048(11);
        }

        private boolean stillValidTarget() {
            if (this.bowl.method_11015()) {
                return false;
            }
            if (this.getBowlDistanceSqr() > 256.0) {
                return false;
            }
            return this.bowl.hasFood(this.dog);
        }

        private double getBowlDistanceSqr() {
            class_243 bowlPos = this.getBowPos();
            return this.dog.method_5707(bowlPos);
        }

        private class_243 getBowPos() {
            return class_243.method_24955((class_2382)this.bowl.method_11016());
        }
    }
}

