/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEffects;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DogGender;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogMode;
import doggytalents.api.feature.DogSize;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.impl.DogArmorItemHandler;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.DTNClientPettingManager;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.artifacts.DoggyArtifact;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.DogAllyCheck;
import doggytalents.common.entity.DogAttackManager;
import doggytalents.common.entity.DogAvoidGoingInFrontOfOwnerManager;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.entity.DogHungerManager;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.DogMoodManager;
import doggytalents.common.entity.DogOwnerDistanceManager;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.entity.DogPushAvoidManager;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.DogSoundManager;
import doggytalents.common.entity.DogSwimmingManager;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.entity.ai.nav.DogBodyRotationControl;
import doggytalents.common.entity.ai.nav.DogJumpControl;
import doggytalents.common.entity.ai.nav.DogMoveControl;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.entity.datasync.DogDataSyncManager;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.entity.texture.DogSkinData;
import doggytalents.common.event.EventHandler;
import doggytalents.common.fabric_helper.entity.DogFabricHelper;
import doggytalents.common.fabric_helper.entity.network.SyncTypes;
import doggytalents.common.fabric_helper.util.FabricUtil;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import doggytalents.forge_imitate.atrrib.ForgeMod;
import doggytalents.forge_imitate.network.PacketDistributor;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1330;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1548;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.apache.commons.lang3.ObjectUtils;

public class Dog
extends AbstractDog {
    private static final class_2940<Optional<class_2561>> LAST_KNOWN_NAME = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13325);
    private static final class_2940<Integer> DOG_FLAGS = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> HUNGER_INT = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_1799> BONE_VARIANT = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> INCAP_VAL = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANIMATION = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANIM_SYNC_TIME = class_2945.method_12791(Dog.class, (class_2941)class_2943.field_13327);
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final DogAnimationManager animationManager = new DogAnimationManager(this);
    private DogSkin clientSkin = DogSkin.CLASSICAL;
    private ArrayList<AccessoryInstance> clientAccessories = new ArrayList();
    public final StatsTracker statsTracker = new StatsTracker();
    public final DogDataSyncManager dogSyncedDataManager = new DogDataSyncManager(this);
    public final DogOwnerDistanceManager dogOwnerDistanceManager = new DogOwnerDistanceManager(this);
    public final DogAvoidGoingInFrontOfOwnerManager avoidGoInFrontOfOwnerManager = new DogAvoidGoingInFrontOfOwnerManager(this);
    public final DogGroupsManager dogGroupsManager = new DogGroupsManager();
    public final DogIncapacitatedMananger incapacitatedMananger = new DogIncapacitatedMananger(this);
    private final DogHungerManager hungerManager = new DogHungerManager(this);
    public final DogPettingManager pettingManager = new DogPettingManager(this);
    public final DogSleepOnManager.PerDog sleepOnManager = new DogSleepOnManager.PerDog(this);
    public final DogSwimmingManager dogSwimmingManager = new DogSwimmingManager(this);
    public final DogPushAvoidManager dogPushAvoidManager = new DogPushAvoidManager(this);
    public final DogAttackManager dogAttackManager = new DogAttackManager(this);
    public final DogAiManager dogAi;
    public final DogMoodManager dogMood = new DogMoodManager(this);
    public final DogSoundManager dogSoundManager = new DogSoundManager(this);
    private DogAlterationProps alterationProps = new DogAlterationProps();
    private IDogRangedAttackManager dogRangedAttackManager = IDogRangedAttackManager.NONE;
    private final DogArmorItemHandler dogArmors = new DogArmorItemHandler(this);
    private class_1799 mouthStack = class_1799.field_8037;
    private class_1799 wolfArmorStack = class_1799.field_8037;
    protected final class_1408 defaultNavigation;
    protected final class_1335 defaultMoveControl;
    @Nullable
    protected IDogNavLock navigationLock;
    protected class_1408 currentNavigation;
    protected int switchNavCooldown = 0;
    private Optional<class_2338> lastSitPos = Optional.empty();
    private int lastSitPosSaveTimestamp = 0;
    private int healingTick;
    private int wanderCooldown = 0;
    private int drunkTickLeft = 0;
    private int silentTickLeft = 0;
    private float headRotationCourse;
    private float headRotationCourseOld;
    @Nonnull
    private WetSource wetSource = WetSource.NONE;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int tickUntilRest;
    private int onFireSmokeTick;
    private boolean shakeFire = false;
    private float percentDecreasePerHealthLost;
    private float maxHealth0;
    protected boolean dogJumping;
    protected float jumpPower;
    protected boolean isDogSwimming;
    protected boolean isDogRunningAwayFromFire;
    public int lastOrderedToSitTick;
    private int tickChopinTail;
    private boolean dogAnimHurtImpules = false;
    private int idleAnimHurtCooldown = 0;
    private class_4048 visualDimension = null;
    private boolean isProtesting = false;
    private boolean ridingAuthorized = false;
    private boolean authorizedChangingOwner = false;
    private boolean authorizedChangingName = false;
    public static int MAX_NAME_LEN = 32;
    private boolean changeDimensionAuthorized = false;
    public boolean locationUpdatedUponRemove = false;
    private Optional<class_1282> dogDeathCause = Optional.empty();
    private boolean detectedDuplicateVertified = false;
    private boolean DTN_dogChangingDim = false;
    private UUID cachedSessionUUID = null;
    private DogAnimation sitAnim = DogAnimation.SIT_DOWN;
    private DogAnimation standAnim = DogAnimation.STAND_QUICK;
    private boolean isDogFollowingSomeone;
    private boolean isDogResistingPush;
    private boolean isDogCurious;
    private AnimationAction animAction;
    private DogPose activePose = DogPose.STAND;
    private final DogFabricHelper dogFabricHelper = new DogFabricHelper(this);
    private boolean isAddedToWorld = false;

    public Dog(class_1299<? extends Dog> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_6173(false);
        this.setGender(DogGender.random(this.method_6051()));
        this.setLowHealthStrategy(LowHealthStrategy.STICK_TO_OWNER);
        this.authorizedChangingOwner = true;
        this.method_6174(null);
        this.authorizedChangingOwner = false;
        this.resetTickTillRest();
        this.field_6207 = new DogMoveControl(this);
        this.field_6204 = new DogJumpControl(this);
        this.defaultNavigation = this.field_6189;
        this.defaultMoveControl = this.field_6207;
        this.dogAi = new DogAiManager(this, this.method_37908().method_24367());
        this.dogAi.init();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LAST_KNOWN_NAME, Optional.empty());
        this.field_6011.method_12784(DOG_FLAGS, (Object)0);
        this.field_6011.method_12784(HUNGER_INT, (Object)Float.valueOf(60.0f));
        this.field_6011.method_12784(BONE_VARIANT, (Object)class_1799.field_8037);
        this.field_6011.method_12784(INCAP_VAL, (Object)0);
        this.field_6011.method_12784(ANIMATION, (Object)0);
        this.field_6011.method_12784(ANIM_SYNC_TIME, (Object)0);
    }

    protected final void method_5959() {
    }

    public void method_5712(class_2338 pos, class_2680 blockIn) {
        float vol = this.isDogSilent() ? 0.01f : 0.15f;
        this.method_5783(class_3417.field_14772, vol, 1.0f);
    }

    protected class_3414 method_5994() {
        boolean whine_health;
        if (this.dogSoundManager.isAmbientLocked()) {
            return null;
        }
        if (this.isDefeated()) {
            if (this.getDogIncapValue() > 20) {
                int chance_window = this.incapacitatedMananger.canMove() ? 5 : 8;
                return this.field_5974.method_43048(chance_window) == 0 ? this.dogMood.getInjuredAmbient() : null;
            }
            return class_3417.field_14922;
        }
        if (this.pettingManager.isPetting() || this.isDogSilent()) {
            return null;
        }
        boolean bl = whine_health = this.method_6181() && this.method_6032() < 10.0f && this.field_5974.method_43048(3) == 0;
        if (whine_health) {
            return this.dogMood.getLowHealthWhine();
        }
        return this.dogMood.getAmbientSound();
    }

    public void method_5783(class_3414 sound, float vol, float pitch) {
        if (this.dogMood.isForceInteruptibleSound(sound)) {
            this.dogSoundManager.playInterruptible(sound, vol, pitch);
            return;
        }
        super.method_5783(sound, vol, pitch);
    }

    @Override
    public float method_6107() {
        float default_val = 0.4f;
        if (this.isDefeated() && this.getDogIncapValue() > 20) {
            default_val = this.incapacitatedMananger.canMove() ? 0.2f : 0.05f;
        }
        return default_val;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return this.dogMood.getHurtSound(damageSourceIn);
    }

    protected void method_6013(class_1282 source) {
        this.field_6191 = -this.method_5970();
        this.dogSoundManager.playNonInterruptible(this.method_6011(source), this.method_6107(), this.method_6017());
    }

    protected class_3414 method_6002() {
        return this.dogMood.getDeathSound();
    }

    protected class_3414 getHowlSound() {
        return class_3417.field_15117;
    }

    public void howl() {
        this.method_5783(this.getHowlSound(), 1.0f, this.method_6017());
    }

    public boolean isDogSoaked() {
        return this.wetSource.soaked();
    }

    @Environment(value=EnvType.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return Math.min(0.5f + class_3532.method_16439((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float getShakeAngle(float partialTicks, float offset) {
        float f = (class_3532.method_16439((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return class_3532.method_15374((float)(f * (float)Math.PI)) * class_3532.method_15374((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void method_5711(byte id) {
        super.method_5711(id);
    }

    public void handleDogShakingUpdate(DogShakingData.State state) {
        switch (state) {
            case SHAKE_WATER: {
                this.startShaking();
                break;
            }
            case SHAKE_LAVA: {
                this.startShakingLava();
                break;
            }
            case STOP: {
                this.finishShaking();
                break;
            }
            default: {
                this.finishShaking();
            }
        }
        if (this.method_37908().field_9236) {
            this.dogSoundManager.interuptPlaying();
        }
    }

    public float getTailRotation() {
        if (!this.method_6181()) {
            return 0.62831855f;
        }
        float full_health_angle = 1.73f;
        float lost_health = this.method_6063() - this.method_6032();
        float lost_health_percent = lost_health * this.percentDecreasePerHealthLost;
        float lost_rad_percent = lost_health_percent * lost_health_percent;
        float lost_rad = 1.5707964f * lost_rad_percent;
        lost_rad = class_3532.method_15363((float)lost_rad, (float)0.0f, (float)1.5707964f);
        return 1.73f - lost_rad;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return class_3532.method_15362((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        if (this.method_5782()) {
            return this.getDogVisualBbHeight() * 0.8f;
        }
        return sizeIn.field_18068 * 0.8f;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.6f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    public int method_5978() {
        return this.method_6172() ? 20 : super.method_5978();
    }

    public double method_5678() {
        return this.method_5854() instanceof class_1657 ? 0.5 : 0.2;
    }

    protected void method_5627(class_1297 passanger) {
        super.method_5627(passanger);
        this.method_18382();
    }

    protected void method_5793(class_1297 passanger) {
        super.method_5793(passanger);
        this.method_18382();
    }

    public class_4048 method_18377(class_4050 p_19975_) {
        boolean collide_passeneger;
        class_4048 self_dim = super.method_18377(p_19975_);
        this.visualDimension = null;
        if (self_dim.field_18067 >= 1.0f) {
            self_dim = new class_4048(1.0f, self_dim.field_18068, self_dim.field_18069);
        }
        if (!(collide_passeneger = ((Boolean)ConfigHandler.SERVER.WOLF_MOUNT_PASSENGER_COLLISION.get()).booleanValue())) {
            return self_dim;
        }
        if (this.method_5782() && !this.method_5685().isEmpty()) {
            this.visualDimension = self_dim;
            self_dim = this.computeRidingDimension(self_dim);
        }
        return self_dim;
    }

    public double method_5621() {
        return (double)this.getRealDimensions().field_18068 * 0.75;
    }

    public class_4048 getRealDimensions() {
        return super.method_18377(this.method_18376());
    }

    @Override
    public float getDogVisualBbHeight() {
        if (this.visualDimension != null) {
            return this.visualDimension.field_18068;
        }
        return this.method_17682();
    }

    @Override
    public float getDogVisualBbWidth() {
        if (this.visualDimension != null) {
            return this.visualDimension.field_18067;
        }
        return this.method_17681();
    }

    private class_4048 computeRidingDimension(class_4048 self_dim) {
        float total_width = self_dim.field_18067;
        float total_height = (float)this.method_5621();
        class_1297 passenger = (class_1297)this.method_5685().get(0);
        total_width = Math.max(total_width, passenger.method_17681());
        total_height = (float)((double)total_height + ((double)passenger.method_17682() + passenger.method_5678()));
        if (total_width >= 1.0f) {
            total_width = 1.0f;
        }
        return new class_4048(total_width, total_height, self_dim.field_18069);
    }

    public void method_5773() {
        class_1309 owner;
        super.method_5773();
        this.updateClassicalAnim();
        this.method_49477(this.method_5782() ? 1.0f : 0.6f);
        if (this.method_5805()) {
            this.updateDogPose();
        }
        this.alterations.forEach(alter -> alter.tick(this));
        if (this.method_5805() && this.method_6063() != this.maxHealth0) {
            this.maxHealth0 = this.method_6063();
            this.percentDecreasePerHealthLost = 1.0f / this.maxHealth0;
        }
        if (this.method_5805() && !this.method_37908().field_9236 && this.field_6012 % 40 == 0 && (owner = this.method_35057()) != null) {
            this.setOwnersName(owner.method_5477());
        }
        if (this.method_5805()) {
            this.animationManager.tick();
            if (!this.method_37908().field_9236) {
                this.tickAnimAction();
            }
        }
        this.pettingManager.tick();
        this.sleepOnManager.tick();
        this.dogSoundManager.tick();
        if (this.method_37908().field_9236) {
            // empty if block
        }
        if (this.method_37908().field_9236 && ((Boolean)ConfigHandler.CLIENT.DISPLAY_SMOKE_WHEN_ON_FIRE.get()).booleanValue()) {
            this.addAdditionalOnFireEffect();
        }
        if (!this.method_37908().field_9236) {
            this.dogSyncedDataManager.tick();
        }
        if (!this.method_37908().field_9236) {
            this.getDogFabricHelper().tick();
        }
    }

    private void addAdditionalOnFireEffect() {
        if (this.method_5809()) {
            if (this.method_6051().method_43048(3) == 0) {
                float f1 = (this.method_6051().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.method_6051().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.method_37908().method_8406((class_2394)class_2398.field_17430, this.method_23317() + (double)f1, this.method_23318() + (double)this.method_5751(), this.method_23321() + (double)f2, 0.0, 0.05, 0.0);
            }
            if (this.onFireSmokeTick <= 300) {
                ++this.onFireSmokeTick;
            } else if (this.onFireSmokeTick <= 600 && this.field_6012 % 4 == 0) {
                ++this.onFireSmokeTick;
            }
            this.onFireSmokeTick = class_3532.method_15340((int)this.onFireSmokeTick, (int)20, (int)300);
        } else if (this.onFireSmokeTick > 0) {
            --this.onFireSmokeTick;
            if (this.method_6051().method_43048(3) == 0) {
                float f1 = (this.method_6051().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.method_6051().method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + (double)f1, this.method_23318() + (double)this.method_5751(), this.method_23321() + (double)f2, 0.0, 0.05, 0.0);
            }
        }
    }

    private void updateClassicalAnim() {
        if (!this.method_5805()) {
            return;
        }
        this.updateClassicalBegAnim();
        boolean val = this.checkDogInWetSourceAndWetTheDog();
        this.updateClassicalShakeAnim(val);
    }

    private void updateClassicalBegAnim() {
        if (!this.canDogDoBegAnim()) {
            this.headRotationCourse = 0.0f;
            this.headRotationCourseOld = 0.0f;
            return;
        }
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
    }

    private boolean checkDogInWetSourceAndWetTheDog() {
        if (this.method_5771()) {
            this.wetSource = WetSource.LAVA;
            return true;
        }
        if (this.method_5799()) {
            this.wetSource = WetSource.WATER;
            return true;
        }
        if (this.method_5721()) {
            this.wetSource = WetSource.RAIN;
            return true;
        }
        if (this.method_5816()) {
            this.wetSource = WetSource.BUBBLE_COLUMN;
            return true;
        }
        return false;
    }

    private void updateClassicalShakeAnim(boolean currentlyInWater) {
        if (!this.method_37908().field_9236 && this.isShaking && (!this.canDogDoShakeAnim() || currentlyInWater)) {
            this.finishShaking();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.STOP);
            return;
        }
        if (!this.isShaking) {
            return;
        }
        if (this.timeWolfIsShaking == 0.0f && this.method_37908().field_9236 && !this.shakeFire) {
            this.dogSoundManager.playInterruptible(class_3417.field_15042, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
        this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
        this.timeWolfIsShaking += 0.05f;
        if (this.prevTimeWolfIsShaking >= 2.0f) {
            for (IDogAlteration alter : this.alterations) {
                alter.onShakingDry(this, this.wetSource);
            }
            this.wetSource = WetSource.NONE;
            this.finishShaking();
        }
        if (this.timeWolfIsShaking > 0.4f) {
            float f = (float)this.method_23318();
            int i = (int)(class_3532.method_15374((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
            class_243 vec3d = this.method_18798();
            for (int j = 0; j < i; ++j) {
                float f1 = (this.field_5974.method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.field_5974.method_43057() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                if (this.shakeFire) {
                    float r = this.method_6051().method_43057();
                    class_2400 type = class_2398.field_11251;
                    if (r <= 0.15f) {
                        type = class_2398.field_18305;
                    } else if (r <= 0.6f) {
                        type = class_2398.field_11239;
                    }
                    this.method_37908().method_8406((class_2394)type, this.method_23317() + (double)f1, (double)(f + 0.8f), this.method_23321() + (double)f2, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                    continue;
                }
                this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + (double)f1, (double)(f + 0.8f), this.method_23321() + (double)f2, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            }
        }
        if ((double)this.timeWolfIsShaking > 0.5 && this.shakeFire && this.field_5974.method_43048(6) == 0) {
            this.method_5783(class_3417.field_15102, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    public boolean canDoIdileAnim() {
        if (!this.method_5805()) {
            return false;
        }
        if (this.method_5765() || this.method_5782()) {
            return false;
        }
        if (this.idleAnimHurtCooldown > 0) {
            return false;
        }
        return !this.isShaking && !this.getAnim().interupting();
    }

    public boolean canContinueDoIdileAnim() {
        if (this.dogAnimHurtImpules) {
            this.dogAnimHurtImpules = false;
            this.idleAnimHurtCooldown = 20;
            return false;
        }
        if (this.method_5765() || this.method_5782()) {
            return false;
        }
        return this.method_5805() && !this.isShaking;
    }

    public void setAnimForIdle(DogAnimation anim) {
        this.setAnim(anim);
        this.dogAnimHurtImpules = false;
    }

    public boolean canDogDoBegAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canBeg) {
            return false;
        }
        return !this.animationManager.started() || this.getAnim().freeHead();
    }

    public boolean canDogDoShakeAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canShake) {
            return false;
        }
        return !this.animationManager.started();
    }

    public void method_6007() {
        if (this.field_6189 != this.currentNavigation) {
            this.field_6189 = this.currentNavigation;
        }
        if (this.navigationLock != null) {
            this.navigationLock.unlockDogNavigation();
        }
        this.validateGoalsAndTickNonRunningIfNeeded();
        if (!this.method_37908().field_9236) {
            this.method_5985().method_6370();
            this.field_6210 = 0;
            this.field_6265 = 0;
            this.dogAi.tickServer();
            this.dogSwimmingManager.tickServer();
        }
        super.method_6007();
        this.updateDogBeginShake();
        if (!this.method_37908().field_9236 && !this.isDefeated()) {
            this.hungerManager.tick();
            this.tickDogHealing();
            this.dogOwnerDistanceManager.tick();
            this.avoidGoInFrontOfOwnerManager.tick();
        }
        if (!this.method_37908().field_9236) {
            this.dogMood.tickServer();
            this.dogPushAvoidManager.tickServer();
            this.dogAttackManager.tickServer();
        }
        if (this.method_37908().field_9236 && this.getDogLevel().isFullKami() && ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.KAMI_PARTICLES)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11214, this.method_23322(0.5), this.method_23319() - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
            }
        }
        if (this.method_37908().field_9236 && this.isInDrunkPose() && this.field_6012 % 16 == 0) {
            int color = 10101987;
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color >> 0 & 0xFF) / 255.0;
            this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d0, d1, d2);
        }
        if (this.field_6012 % 50 == 0) {
            class_5321 dimKey = this.method_37908().method_27983();
            Optional<class_2338> bowlPos = this.getBowlPos((class_5321<class_1937>)dimKey);
            if (bowlPos.isPresent() && this.method_5707(class_243.method_24955((class_2382)((class_2382)bowlPos.get()))) >= 64.0) {
                this.setBowlPos((class_5321<class_1937>)dimKey, Optional.empty());
            }
            if (bowlPos.isPresent() && this.method_37908().method_22340(bowlPos.get()) && !this.method_37908().method_8320(bowlPos.get()).method_27852((class_2248)DoggyBlocks.FOOD_BOWL.get())) {
                this.setBowlPos((class_5321<class_1937>)dimKey, Optional.empty());
            }
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
        if (this.isDefeated()) {
            this.incapacitatedMananger.tick();
        }
        if (this.tickChopinTail > 0) {
            --this.tickChopinTail;
        }
        if (this.switchNavCooldown > 0) {
            --this.switchNavCooldown;
        }
        if (this.idleAnimHurtCooldown > 0) {
            --this.idleAnimHurtCooldown;
        }
        if (this.drunkTickLeft > 0) {
            --this.drunkTickLeft;
        }
        if (this.silentTickLeft > 0) {
            --this.silentTickLeft;
        }
        if (!this.method_37908().field_9236 && this.method_6172() && !this.isDogResting() && this.tickUntilRest > 0) {
            --this.tickUntilRest;
        }
        if (!this.method_37908().field_9236 && this.method_5753()) {
            this.mayFloatDogInLava();
        }
        if (this.navigationLock != null) {
            this.navigationLock.lockDogNavigation();
        }
    }

    private void tickDogHealing() {
        int healingTick_add = 8;
        if (this.method_6172()) {
            healingTick_add += 4;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1271<Integer> result = alter.healingTick(this, healingTick_add);
            if (!result.method_5467().method_23666()) continue;
            healingTick_add = (Integer)result.method_5466();
        }
        if (healingTick_add < 0) {
            healingTick_add = 0;
        }
        this.healingTick += healingTick_add;
        if (this.healingTick >= 6000) {
            if (this.method_6032() < this.method_6063()) {
                this.method_6025(2.0f);
            }
            this.healingTick = 0;
        }
    }

    private void updateDogBeginShake() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.isShaking) {
            return;
        }
        if (this.method_6150()) {
            return;
        }
        if (!this.method_24828()) {
            return;
        }
        if (!this.canDogDoShakeAnim()) {
            return;
        }
        if (this.wetSource.isNone()) {
            return;
        }
        if (this.checkDogInWetSourceAndWetTheDog()) {
            return;
        }
        if (this.wetSource.flame() && this.method_5809()) {
            return;
        }
        this.startShakingAndBroadcast(this.wetSource.flame());
    }

    private void validateGoalsAndTickNonRunningIfNeeded() {
        if (this.method_37908().field_9236) {
            return;
        }
        Set availableGoals = this.field_6201.method_35115();
        if (!availableGoals.isEmpty()) {
            availableGoals.clear();
        }
    }

    public boolean triggerAction(TriggerableAction action) {
        return this.dogAi.triggerAction(action);
    }

    public boolean isBusy() {
        if (!this.isDoingFine()) {
            return true;
        }
        if (this.method_6172() && this.forceSit()) {
            return true;
        }
        if (this.dogAi.isBusy()) {
            return true;
        }
        return this.method_42148();
    }

    public boolean readyForNonTrivialAction() {
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.method_6172() && this.forceSit()) {
            return false;
        }
        if (!this.dogAi.readyForNonTrivivalAction()) {
            return false;
        }
        return !this.method_42148();
    }

    public void clearTriggerableAction() {
        this.dogAi.clearTriggerableAction();
    }

    public boolean triggerActionDelayed(int delay, TriggerableAction action) {
        return this.dogAi.triggerActionDelayed(action, delay);
    }

    public boolean isOnSwitchNavCooldown() {
        return this.switchNavCooldown > 0;
    }

    public boolean canUpdateDogAi() {
        return !this.method_6062() && this.method_6034() && !this.isDogInAnimDebug();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.isDefeated()) {
            return this.incapacitatedMananger.interact(stack, player, hand);
        }
        if (this.handleOpenDogScreenDedicated(player, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleTameDogIfNotTamed(player, stack, hand).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.dogCheckAndRidePlayer(player, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleSetWolfArmor(player, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleRepairWolfArmor(player, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleUnsetWolfArmor(player, stack, hand).method_23666()) {
            return class_1269.field_5812;
        }
        Optional<class_1269> otherHandlerResult = this.handleAlterationsAndOtherHandlers(player, stack, hand);
        if (otherHandlerResult.isPresent()) {
            return otherHandlerResult.get();
        }
        if (this.handleBreeding(player, hand, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleOpenDogScreen(player).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleDogSitStand(player).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.method_37908().field_9236) {
            this.displayToastIfNoPermission(player);
        }
        return class_1269.field_5811;
    }

    private class_1269 handleDogSitStand(class_1657 player) {
        if (!this.canInteract((class_1309)player)) {
            return class_1269.field_5814;
        }
        if (this.isProtesting()) {
            return class_1269.field_5814;
        }
        if (!this.method_37908().field_9236) {
            this.checkAndDoBackFlip();
        }
        if (!this.method_37908().field_9236 && !this.method_24345()) {
            this.lastOrderedToSitTick = this.field_6012;
        }
        this.method_24346(!this.method_24345());
        this.field_6282 = false;
        this.field_6189.method_6340();
        this.method_5980(null);
        return class_1269.field_5812;
    }

    private void checkAndDoBackFlip() {
        if (!this.method_24345()) {
            return;
        }
        if (!this.method_6172()) {
            return;
        }
        int sit_interval = this.field_6012 - this.lastOrderedToSitTick;
        float r = this.method_6051().method_43057();
        if (!this.checkDogBackflipRandom(r, sit_interval)) {
            return;
        }
        if (!this.checkDogBackflipAreaAbove()) {
            return;
        }
        this.setStandAnim(DogAnimation.NONE);
        this.method_6179(false);
        this.triggerAnimationAction(new DogBackFlipAction(this));
    }

    private boolean checkDogBackflipRandom(float r, int sit_interval) {
        if (sit_interval <= 30) {
            return false;
        }
        if (sit_interval >= 1200) {
            return r <= 0.7f;
        }
        return r <= 0.3f;
    }

    private boolean checkDogBackflipAreaAbove() {
        return this.method_37908().method_8320(this.method_24515().method_10084()).method_26215();
    }

    private class_1269 handleOpenDogScreen(class_1657 player) {
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        if (!this.canInteract((class_1309)player)) {
            return class_1269.field_5811;
        }
        if (this.method_37908().field_9236) {
            DogNewInfoScreen.open(this);
        }
        return class_1269.field_5812;
    }

    private class_1269 handleOpenDogScreenDedicated(class_1657 player, class_1799 stack) {
        if (stack.method_7909() != class_1802.field_8600) {
            return class_1269.field_5814;
        }
        if (!this.method_6181()) {
            return class_1269.field_5814;
        }
        if (!this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (this.canInteract((class_1309)player)) {
            DogNewInfoScreen.open(this);
        } else {
            DogCannotInteractWithScreen.open(this);
        }
        return class_1269.field_5812;
    }

    private class_1269 dogCheckAndRidePlayer(class_1657 player, class_1799 stack) {
        if (player.method_5626((class_1297)this)) {
            if (!this.method_37908().field_9236) {
                this.method_18375();
            }
            return class_1269.field_5812;
        }
        if (stack.method_7909() != class_1802.field_8606) {
            return class_1269.field_5811;
        }
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        if (this.method_5782()) {
            return class_1269.field_5811;
        }
        if (!this.canInteract((class_1309)player)) {
            return class_1269.field_5811;
        }
        if (!this.method_37908().field_9236 && this.method_5804((class_1297)player)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.getGenderPronoun()}), true);
        }
        return class_1269.field_5812;
    }

    private class_1269 handleSetWolfArmor(class_1657 player, class_1799 stack) {
        return class_1269.field_5811;
    }

    private class_1269 handleRepairWolfArmor(class_1657 player, class_1799 stack) {
        return class_1269.field_5811;
    }

    private class_1269 handleUnsetWolfArmor(class_1657 player, class_1799 stack, class_1268 hand) {
        return class_1269.field_5811;
    }

    private Optional<class_1269> handleAlterationsAndOtherHandlers(class_1657 player, class_1799 stack, class_1268 hand) {
        Optional<IDogFoodHandler> foodHandler = FoodHandler.getMatch(this, stack, (class_1297)player);
        if (foodHandler.isPresent()) {
            return Optional.of(foodHandler.get().consume(this, stack, (class_1297)player));
        }
        class_1269 dog_item_result = IDogItem.getMatch(this, stack, player, hand);
        if (dog_item_result != class_1269.field_5811) {
            return Optional.of(dog_item_result);
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.processInteract(this, this.method_37908(), player, hand);
            if (result == class_1269.field_5811) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private class_1269 handleBreeding(class_1657 player, class_1268 hand, class_1799 stack) {
        if (!stack.method_31574(DoggyItems.BREEDING_BONE.get())) {
            return class_1269.field_5811;
        }
        if (!this.canInteract((class_1309)player)) {
            return class_1269.field_5811;
        }
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        int age = this.method_5618();
        if (age == 0 && this.method_6482()) {
            this.method_6475(player, hand, stack);
            this.method_6480(player);
        } else if (this.method_6109()) {
            this.method_6475(player, hand, stack);
            this.method_5620(Dog.method_41321((int)(-age)), true);
        }
        return class_1269.field_5812;
    }

    private class_1269 handleTameDogIfNotTamed(class_1657 player, class_1799 stack, class_1268 hand) {
        boolean alwaysTame;
        if (this.method_6181()) {
            return class_1269.field_5814;
        }
        if (!this.isDogTameItem(stack)) {
            return class_1269.field_5814;
        }
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        this.method_6475(player, hand, stack);
        boolean bl = alwaysTame = stack.method_7909() == DoggyItems.TRAINING_TREAT.get();
        if (alwaysTame || this.field_5974.method_43048(3) == 0) {
            this.method_6170(player);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_24346(true);
            this.maxHealth();
            this.method_37908().method_8421((class_1297)this, (byte)7);
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)6);
        }
        return class_1269.field_5812;
    }

    private boolean isDogTameItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_8606) || stack.method_31574(DoggyItems.TRAINING_TREAT.get());
    }

    @Override
    public boolean canStillEat() {
        if (this.method_37908().field_9236) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && this.method_6032() < this.method_6063() && this.hungerManager.saturation() <= 0) {
            return true;
        }
        return this.getDogHunger() < this.getMaxHunger();
    }

    public boolean isProtesting() {
        return this.isProtesting;
    }

    public void setProtesting(boolean p) {
        this.isProtesting = p;
    }

    private void displayToastIfNoPermission(class_1657 player) {
        if (this.canInteract((class_1309)player)) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"doggui.invalid_dog.no_permission.title", (Object[])new Object[]{this.getGenderPronoun()}).method_27692(class_124.field_1061), true);
    }

    public boolean method_49693() {
        if (this.canSwimUnderwater() && this.alterationProps.canBreatheUnderwater()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.canBeRiddenInWater(this);
            if (result.method_23666()) {
                return false;
            }
            if (result != class_1269.field_5814) continue;
            return true;
        }
        return super.method_49693();
    }

    public void method_5848() {
        if (!this.method_37908().field_9236) {
            class_1297 e0 = this.method_5854();
            super.method_5848();
            class_1297 e1 = this.method_5854();
            if (e0 != e1 && e0 instanceof class_3222) {
                class_3222 player = (class_3222)e0;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.method_5628(), false));
            }
        } else {
            super.method_5848();
        }
    }

    public boolean method_5804(class_1297 entity) {
        boolean not_authorized;
        boolean result = false;
        boolean bl = not_authorized = this.requireRidingAuthorization(entity) && !this.isRidingAuthorized();
        if (!not_authorized) {
            result = super.method_5804(entity);
        }
        this.ridingAuthorized = false;
        if (!this.method_37908().field_9236 && result && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.method_5628(), true));
        }
        return result;
    }

    public boolean isRidingAuthorized() {
        return this.ridingAuthorized;
    }

    public void authorizeRiding() {
        this.ridingAuthorized = true;
    }

    public boolean requireRidingAuthorization(class_1297 entity) {
        Dog otherDog;
        if (this.dogAutoMount()) {
            return false;
        }
        UUID ownerUUID = this.method_6139();
        if (ownerUUID == null) {
            return false;
        }
        if (!ObjectUtils.notEqual((Object)ownerUUID, (Object)entity.method_5667())) {
            return false;
        }
        return !(entity instanceof Dog) || ObjectUtils.notEqual((Object)ownerUUID, (Object)(otherDog = (Dog)entity).method_6139());
    }

    public boolean method_5709() {
        if (this.method_37908().field_9236) {
            return (Boolean)ConfigHandler.CLIENT.HIDE_WOLF_MOUNT_STATUS.get() == false;
        }
        return super.method_5709();
    }

    public boolean canTrample(class_2680 state, class_2338 pos, float fallDistance) {
        return false;
    }

    public class_1315 method_5943(class_5425 p_146746_, class_1266 p_146747_, class_3730 p_146748_, @Nullable class_1315 p_146749_, @Nullable class_2487 p_146750_) {
        return null;
    }

    public double method_26825(class_1320 attrib) {
        if (attrib == class_5134.field_23717) {
            DogAttackManager attack_manager = this.dogAttackManager;
            if (attack_manager != null && attack_manager.isDogFarChasingTarget()) {
                return 32.0;
            }
            IDogRangedAttackManager ranged_attack = this.getDogRangedAttack();
            if (ranged_attack != null && ranged_attack.isApplicable(this)) {
                return 20.0;
            }
        }
        return super.method_26825(attrib);
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        if (this.dogFallImmune()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.onLivingFall(this, distance, damageMultiplier);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        float[] ret = new float[]{distance, damageMultiplier};
        int i = this.method_23329(distance = ret[0], damageMultiplier = ret[1]);
        if (i > 0) {
            if (this.method_5782()) {
                for (class_1297 e : this.method_5685()) {
                    e.method_5643(this.method_48923().method_48827(), (float)i);
                }
            }
            this.method_5783(i > 4 ? this.method_39760().comp_302() : this.method_39760().comp_301(), 1.0f, 1.0f);
            this.method_23328();
            this.method_5643(this.method_48923().method_48827(), i);
            return true;
        }
        return false;
    }

    public boolean dogFallImmune() {
        return this.alterationProps.fallImmune();
    }

    public int method_5850() {
        return 3;
    }

    protected int method_23329(float distance, float damageMultiplier) {
        class_1293 effectInst = this.method_6112(class_1294.field_5913);
        float f = effectInst == null ? 0.0f : (float)(effectInst.method_5578() + 1);
        distance -= f;
        for (IDogAlteration alter : this.alterations) {
            class_1271<Float> result = alter.calculateFallDistance(this, distance);
            if (!result.method_5467().method_23666()) continue;
            distance = ((Float)result.method_5466()).floatValue();
            break;
        }
        return class_3532.method_15386((float)((distance - 3.0f - f) * damageMultiplier));
    }

    public boolean method_6094() {
        return this.alterationProps.canBreatheUnderwater();
    }

    protected int method_6130(int air) {
        for (IDogAlteration alter : this.alterations) {
            class_1271<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.method_5467().method_23666()) continue;
            return (Integer)result.method_5466();
        }
        return super.method_6130(air);
    }

    public boolean method_26319(class_3610 state) {
        if (this.method_5753() && state.method_15767(class_3486.field_15518)) {
            return true;
        }
        return super.method_26319(state);
    }

    public boolean method_5659() {
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.negateExplosion(this);
            if (!result.method_23666()) continue;
            return true;
        }
        return super.method_5659();
    }

    protected int method_6064(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            class_1271<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.method_5467().method_23666()) continue;
            currentAir = (Integer)result.method_5466();
            break;
        }
        return Math.min(currentAir, this.method_5748());
    }

    public boolean method_18395(class_1309 target) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        if (this.getMode().minorAttack() && this.dogMinorAttackCheckToAvoid(target)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.canAttack(this, target);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        if (target instanceof class_1548) {
            return false;
        }
        return super.method_18395(target);
    }

    private boolean dogMinorAttackCheckToAvoid(class_1309 target) {
        class_1309 owner;
        if (target instanceof class_1590) {
            return true;
        }
        if (target instanceof class_5418 && (owner = this.method_35057()) != null) {
            for (class_1799 stack : owner.method_5661()) {
                if (!FabricUtil.makesPiglinsNeutral(stack)) continue;
                return true;
            }
        }
        return target.method_5864().method_20210(DoggyTags.DOG_SHOULD_IGNORE);
    }

    public boolean method_5973(class_1299<?> entityType) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        return entityType != class_1299.field_6107 || this.canDogFly();
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.shouldAttackEntity(this, target, owner);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        if (target instanceof class_1548) {
            return false;
        }
        return !DogAllyCheck.isAlliedToDog(this, (class_1297)target, owner);
    }

    protected boolean stillIdleOrSitWhenHurt(class_1282 source, float amount) {
        if (this.isDogDrunk()) {
            return true;
        }
        if (this.method_5765()) {
            return true;
        }
        for (IDogAlteration alt : this.alterations) {
            if (!alt.stillIdleOrSitWhenHurt(this, source, amount).method_23666()) continue;
            return true;
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean flag;
        class_1297 attacker = source.method_5529();
        if (this.isDefeated() && !source.method_48789(class_8103.field_42242)) {
            class_1308 mob;
            class_1309 target;
            this.incapacitatedMananger.onHurt();
            if (attacker instanceof class_1308 && (target = (mob = (class_1308)attacker).method_5968()) == this) {
                mob.method_5980(null);
            }
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1271<Float> result = alter.gettingAttackedFrom(this, source, amount);
            if (result.method_5467() == class_1269.field_5814) {
                return false;
            }
            amount = ((Float)result.method_5466()).floatValue();
        }
        if (this.method_5679(source)) {
            return false;
        }
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && attacker instanceof class_1657) {
            return false;
        }
        if (!this.canOwnerAttack() && (flag = DogAllyCheck.isAlliedToDog(this, attacker))) {
            return false;
        }
        float health0 = this.method_6032();
        this.dogMood.onStartHurting(health0);
        boolean ret = super.method_5643(source, amount);
        float actual_hurt_amount = health0 - this.method_6032();
        if (!this.method_37908().field_9236) {
            this.mayStandUpAndPlayHurtAnim(source, actual_hurt_amount, health0);
            if (actual_hurt_amount > 0.0f) {
                DogSleepOnManager.onHurt(this);
            }
        }
        if (this.method_37908().field_9236 && ((Boolean)ConfigHandler.CLIENT.BLOCK_RED_OVERLAY_WHEN_HURT.get()).booleanValue()) {
            this.field_6235 = 0;
            this.field_6254 = 0;
        }
        return ret;
    }

    protected void method_6074(class_1282 source, float amount) {
        if (this.mayWolfArmorAbsorb(source, amount)) {
            return;
        }
        super.method_6074(source, amount);
    }

    private boolean mayWolfArmorAbsorb(class_1282 source, float amount) {
        return false;
    }

    private void mayStandUpAndPlayHurtAnim(class_1282 source, float real_hurt_amount, float health0) {
        if (this.isDefeated()) {
            return;
        }
        if (this.method_29504()) {
            this.method_24346(false);
            this.method_6179(false);
            this.setAnim(DogAnimation.HURT_1);
            return;
        }
        if (this.stillIdleOrSitWhenHurt(source, real_hurt_amount)) {
            return;
        }
        this.dogAnimHurtImpules = true;
        this.method_24346(false);
        boolean wasSitting = this.method_6172();
        if (wasSitting) {
            this.setStandAnim(DogAnimation.NONE);
            this.method_6179(false);
        }
        if (wasSitting || real_hurt_amount >= 6.0f) {
            this.setAnim(DogAnimation.HURT_1);
            return;
        }
        if (source.method_5529() != null && real_hurt_amount >= 1.0f) {
            this.setAnim(DogAnimation.HURT_2);
            return;
        }
    }

    public boolean method_6121(class_1297 target) {
        for (IDogAlteration alter : this.alterations) {
            alter.doInitialAttackEffects(this, target);
        }
        class_1324 attackDamageInst = this.method_5996(class_5134.field_23721);
        class_1324 critDamageInst = this.method_5996(DoggyAttributes.CRIT_CHANCE.get());
        Set critModifiers = null;
        if (critDamageInst != null && critDamageInst.method_6194() > this.method_6051().method_43058()) {
            class_1324 critBonusInst = this.method_5996(DoggyAttributes.CRIT_BONUS.get());
            Set set = critModifiers = critBonusInst == null ? null : critBonusInst.method_6195();
            if (critModifiers != null && attackDamageInst != null) {
                critModifiers.forEach(arg_0 -> ((class_1324)attackDamageInst).method_26835(arg_0));
            }
        }
        int damage = (int)(attackDamageInst == null ? 0.0 : attackDamageInst.method_6194());
        class_1799 stack = this.method_6047();
        if (target instanceof class_1309 && stack != null) {
            damage = (int)((float)damage + class_1890.method_8218((class_1799)this.method_6047(), (class_1310)((class_1309)target).method_6046()));
        }
        if (critModifiers != null && attackDamageInst != null) {
            critModifiers.forEach(arg_0 -> ((class_1324)attackDamageInst).method_6202(arg_0));
        }
        this.doInitialEnchantDamageEffects((class_1309)this, target);
        boolean flag = target.method_5643(this.method_48923().method_48812((class_1309)this), (float)damage);
        if (!flag) {
            return false;
        }
        this.method_5723((class_1309)this, target);
        this.statsTracker.increaseDamageDealt(damage);
        if (critModifiers != null) {
            ParticlePackets.CritEmitterPacket.sendCritEmitterPacketToNearClients(target);
            this.method_5783(class_3417.field_15016, 0.5f, 1.0f);
        }
        for (IDogAlteration alter : this.alterations) {
            alter.doAdditionalAttackEffects(this, target);
        }
        if (this.method_6059(DoggyEffects.NATTO_BITE.get()) && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            DoggyEffects.NATTO_BITE.get().doAdditionalAttackEffects(this, living);
        }
        return true;
    }

    public boolean method_5874(class_3218 level, class_1309 entity) {
        if (!((Boolean)ConfigHandler.SERVER.DISABLE_KILL_STATS.get()).booleanValue()) {
            this.statsTracker.incrementKillCount((class_1297)entity);
        }
        return true;
    }

    protected void doInitialEnchantDamageEffects(class_1309 dog, class_1297 target) {
        int i = class_1890.method_8199((class_1309)this);
        if (i > 0) {
            target.method_5639(i * 4);
        }
        float knockback = (float)this.method_26825(class_5134.field_23722);
        if ((knockback += (float)class_1890.method_8205((class_1309)this)) > 0.0f && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            living.method_6005((double)(knockback * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
        }
    }

    public boolean method_6061(class_1282 source) {
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.canBlockDamageSource(this, source);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        return super.method_6061(source);
    }

    public boolean method_33190() {
        return !this.isDefeated() && super.method_33190();
    }

    public void method_5639(int second) {
        for (IDogAlteration alter : this.alterations) {
            class_1271<Integer> result = alter.setFire(this, second);
            if (!result.method_5467().method_23666()) continue;
            second = (Integer)result.method_5466();
        }
        super.method_5639(second);
    }

    public boolean method_5753() {
        return this.alterationProps.fireImmune();
    }

    public boolean method_32316() {
        return !this.alterationProps.fireImmune();
    }

    public boolean shouldDogNotAfraidOfFire() {
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.shouldNotAfraidOfFire(this);
            if (!result.method_23666()) continue;
            return true;
        }
        return false;
    }

    public boolean method_5679(class_1282 source) {
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.isInvulnerableTo(this, source);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        return super.method_5679(source);
    }

    public boolean method_5655() {
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.isInvulnerable(this);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        return super.method_5655();
    }

    public boolean method_37222(class_1293 effectInst, @Nullable class_1297 adder) {
        if (this.isDefeated()) {
            return false;
        }
        return super.method_37222(effectInst, adder);
    }

    public void method_26082(class_1293 p_147216_, @Nullable class_1297 adder) {
        if (this.isDefeated()) {
            return;
        }
        super.method_26082(p_147216_, adder);
    }

    public boolean method_6049(class_1293 effectIn) {
        if (this.isDefeated()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.isPotionApplicable(this, effectIn);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        return super.method_6049(effectIn);
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public void method_5954(class_1297 p_21464_, boolean p_21465_) {
    }

    public boolean method_5934() {
        return false;
    }

    @Nullable
    public class_1297 method_5933() {
        return null;
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public void method_5982() {
        this.field_6278 = 0;
    }

    public void method_5826(UUID uniqueIdIn) {
        UUID oldUniqueId = this.method_5667();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.method_5826(uniqueIdIn);
        if (!this.isAddedToWorld()) {
            return;
        }
        if (this.method_37908() != null && !this.method_37908().field_9236) {
            DogLocationStorage.get(this.method_37908()).remove(oldUniqueId);
            DogLocationStorage.get(this.method_37908()).getOrCreateData(this).update(this);
        }
    }

    public void method_6170(class_1657 player) {
        super.method_6170(player);
        this.setOwnersName(player.method_5477());
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            float maxHealth = this.getDogLevel().getMaxHealth();
            this.method_5996(class_5134.field_23716).method_6192((double)maxHealth);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(8.0);
        }
        this.method_5996(class_5134.field_23721).method_6192(4.0);
    }

    public void maxHealth() {
        this.method_6033(this.method_6063());
    }

    public void method_6174(@Nullable UUID uuid) {
        boolean isChangingOwner;
        UUID currentUUID = this.method_6139();
        boolean bl = isChangingOwner = currentUUID != null && ObjectUtils.notEqual((Object)currentUUID, (Object)uuid);
        if (isChangingOwner && !this.authorizedChangingOwner) {
            return;
        }
        super.method_6174(uuid);
        if (uuid == null) {
            this.setOwnersName((class_2561)null);
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        if (!this.authorizedChangingName) {
            return;
        }
        name = this.checkDogNameLength(name);
        name = this.checkDogValidName(name);
        super.method_5665(name);
    }

    private class_2561 checkDogNameLength(class_2561 name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        if (str.length() <= MAX_NAME_LEN) {
            return name;
        }
        String new_str = str.substring(0, MAX_NAME_LEN);
        class_5250 new_name = class_2561.method_43470((String)new_str).method_27696(name.method_10866());
        return new_name;
    }

    private class_2561 checkDogValidName(class_2561 name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        String newStr = DogUtil.checkAndCorrectInvalidName(str);
        if (newStr == str) {
            return name;
        }
        return class_2561.method_43470((String)newStr).method_27696(name.method_10866());
    }

    public void setDogCustomName(@Nullable class_2561 name) {
        this.authorizedChangingName = true;
        this.method_5665(name);
        this.authorizedChangingName = false;
    }

    public boolean method_5698(class_1297 entityIn) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && entityIn instanceof class_1657) {
            return true;
        }
        if (!this.canOwnerAttack() && DogAllyCheck.isAlliedToDog(this, entityIn)) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.shouldSkipAttackFrom(this, entityIn);
            if (result.method_23666()) {
                return true;
            }
            if (result != class_1269.field_5814) continue;
            return false;
        }
        return false;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (this.isDefeated()) {
            return false;
        }
        if (otherAnimal == this) {
            return false;
        }
        if (!this.method_6181()) {
            return false;
        }
        if (!(otherAnimal instanceof Dog)) {
            return false;
        }
        Dog entitydog = (Dog)otherAnimal;
        if (!entitydog.method_6181()) {
            return false;
        }
        if (entitydog.method_6172()) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue() && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return !entitydog.isDefeated() && this.method_6479() && entitydog.method_6479();
    }

    public class_1296 method_5613(class_3218 worldIn, class_1296 partner) {
        Dog child = (Dog)DoggyEntityTypes.DOG.get().method_5883((class_1937)worldIn);
        UUID uuid = this.method_6139();
        if (uuid != null) {
            child.method_6174(uuid);
            child.method_6173(true);
            child.maxHealth();
        }
        if (partner instanceof Dog && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS)).booleanValue()) {
            child.setLevel(this.getDogLevel().combine(((Dog)partner).getDogLevel()));
        }
        return child;
    }

    public void method_24650(class_3218 level, class_1429 otherDog) {
        if (!this.checkOwnerTrainLimitBeforeBreed()) {
            this.method_5614(6000);
            otherDog.method_5614(6000);
            this.method_6477();
            otherDog.method_6477();
            this.method_37908().method_8421((class_1297)this, (byte)6);
            return;
        }
        super.method_24650(level, otherDog);
    }

    private boolean checkOwnerTrainLimitBeforeBreed() {
        class_1309 owner = this.method_35057();
        if (owner == null) {
            return false;
        }
        if (!(owner instanceof class_3222)) {
            return false;
        }
        class_3222 sP = (class_3222)owner;
        return EventHandler.isWithinTrainWolfLimit((class_1657)sP);
    }

    public boolean method_5733() {
        return this.method_16914() || super.method_5733();
    }

    public float method_17825() {
        if (this.method_6109()) {
            return 0.5f;
        }
        return this.getDogSize().getScale();
    }

    public void authorizeChangeDimension() {
        this.changeDimensionAuthorized = true;
    }

    public class_1297 method_5731(class_3218 worldIn) {
        if (this.checkBlockPortal()) {
            return null;
        }
        this.DTN_dogChangingDim = true;
        class_1297 transportedEntity = super.method_5731(worldIn);
        this.DTN_dogChangingDim = false;
        if (transportedEntity instanceof Dog) {
            DogLocationStorage.get(this.method_37908()).getOrCreateData(this).update((Dog)transportedEntity);
        }
        return transportedEntity;
    }

    private boolean checkBlockPortal() {
        boolean default_block;
        boolean defeated_bypass;
        boolean changeDimensionAuth0 = this.changeDimensionAuthorized;
        this.changeDimensionAuthorized = false;
        boolean bl = defeated_bypass = this.isDefeated() && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.INJURED_DOG_BLOCK_PORTAL) == false;
        if (defeated_bypass) {
            return false;
        }
        boolean bl2 = default_block = !changeDimensionAuth0 && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.ALL_DOG_BLOCK_PORTAL) != false;
        return default_block;
    }

    public void onRemovedFromWorld() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_5805()) {
                DogLocationData data = DogLocationStorage.get((class_1937)serverLevel).getData(this);
                if (data != null) {
                    data.update(this);
                }
                this.locationUpdatedUponRemove = true;
            }
        }
    }

    public void onAddedToWorld() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_5805()) {
                DogLocationStorage storage = DogLocationStorage.get((class_1937)serverLevel);
                DogLocationData data = storage.getOrCreateData(this);
                if (data != null) {
                    data.update(this);
                }
                storage.getOnlineDogsManager().onDogGoOnline(this);
            }
        }
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        if (removalReason.method_31486() && this.method_37908() != null && !this.method_37908().field_9236) {
            this.cacheSessionUUID();
            DogLocationStorage.get(this.method_37908()).remove(this);
            if (this.method_6139() != null) {
                DogRespawnStorage.get(this.method_37908()).putData(this);
            }
        }
        super.method_5650(removalReason);
        for (IDogAlteration x : this.alterations) {
            x.remove(this);
        }
    }

    public void method_5814(double x, double y, double z) {
        int y_cap;
        boolean max_build_height_check = ConfigHandler.ServerConfig.getConfigOrDefault(ConfigHandler.SERVER.DOG_MAX_BUILD_Y_CAP, false);
        if (max_build_height_check && y > (double)(y_cap = this.method_37908().method_31600())) {
            y = y_cap;
        }
        super.method_5814(x, y, z);
    }

    private void startShaking() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingAndBroadcast(boolean shakeFire) {
        if (this.isShaking) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (shakeFire) {
            this.startShakingLava();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_LAVA);
            return;
        }
        this.startShaking();
        ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_WATER);
    }

    private void finishShaking() {
        this.isShaking = false;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingLava() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public boolean isShakingLava() {
        return this.isShaking && this.shakeFire;
    }

    public void resetBeggingRotation() {
        this.headRotationCourse = 0.0f;
        this.headRotationCourseOld = 0.0f;
    }

    public void method_6078(class_1282 cause) {
        if (this.checkAndHandleIncapacitated(cause)) {
            return;
        }
        this.wetSource = WetSource.NONE;
        this.finishShaking();
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        this.dogDeathCause = Optional.empty();
        if (((Boolean)ConfigHandler.SERVER.DOG_RESPAWN_INCAPACITATED_WHEN_KILLED.get()).booleanValue() && !cause.method_48789(class_8103.field_42242)) {
            this.dogDeathCause = Optional.ofNullable(cause);
            this.setDogIncapValue(this.getInitalDogIncapVal(cause));
        }
        this.dogProccessAndBroadcastDieVanilla(cause);
    }

    public Optional<class_1282> getDogDeathCause() {
        return this.dogDeathCause;
    }

    private void dogProccessAndBroadcastDieVanilla(class_1282 cause) {
        if (this.method_31481()) {
            return;
        }
        if (this.field_6272) {
            return;
        }
        class_2561 deathMessage = this.method_6066().method_5548();
        this.field_6272 = true;
        this.method_6066().method_5539();
        class_1937 level = this.method_37908();
        class_1297 entity = cause.method_5529();
        if (level instanceof class_3218) {
            class_3218 serverlevel = (class_3218)level;
            if (entity == null || entity.method_5874(serverlevel, (class_1309)this)) {
                this.method_32876(class_5712.field_37676);
                this.method_16080(cause);
            }
            this.method_37908().method_8421((class_1297)this, (byte)3);
        }
        class_1309 owner = this.method_35057();
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && owner instanceof class_3222) {
            owner.method_43496(deathMessage);
        }
    }

    private boolean checkAndHandleIncapacitated(class_1282 cause) {
        if (this.method_37908().field_9236) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.IMMORTAL_DOGS)).booleanValue()) {
            return false;
        }
        if (cause.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (this.method_6139() == null) {
            return false;
        }
        this.handleIncapacitated(cause);
        return true;
    }

    private void handleIncapacitated(class_1282 source) {
        this.method_6033(1.0f);
        this.setMode(DogMode.INJURED);
        this.setDogHunger(0.0f);
        this.method_6012();
        this.setDogIncapValue(this.getInitalDogIncapVal(source));
        this.method_20417();
        this.dogAi.forceStopAllGoal();
        this.method_5942().method_6340();
        this.method_18375();
        this.createAndSetIncapSyncState(source);
        if (this.method_5799() || !this.method_5753() && this.method_5771()) {
            this.triggerAnimationAction(new DogDrownAction(this));
        } else {
            this.setAnim(this.incapacitatedMananger.getAnim());
        }
        class_1309 owner = this.method_35057();
        if (owner != null) {
            this.sendIncapacitatedMsg(owner, source);
        }
        this.incapacitatedMananger.setIncapMsg(source.method_5506((class_1309)this).getString());
        this.wetSource = WetSource.NONE;
        this.finishShaking();
    }

    public int getInitalDogIncapVal(class_1282 source) {
        class_1267 difficulty = this.method_37908().method_8407();
        if (difficulty == class_1267.field_5801) {
            return this.getDefaultInitIncapVal() / 2;
        }
        if (difficulty == class_1267.field_5805) {
            return this.getDefaultInitIncapVal();
        }
        if (source.method_48789(class_8103.field_42242)) {
            return this.getDefaultInitIncapVal();
        }
        float fatal_damage = this.field_6253;
        if (fatal_damage <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        fatal_damage = this.method_6132(source, fatal_damage);
        if ((fatal_damage = this.method_6036(source, fatal_damage)) <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        int multipler = difficulty == class_1267.field_5807 ? 2 : 1;
        int additional_incap = class_3532.method_15375((float)((float)multipler * fatal_damage));
        return this.getDefaultInitIncapVal() + additional_incap;
    }

    private void sendIncapacitatedMsg(class_1309 owner, class_1282 source) {
        class_5250 msg = source.method_5506((class_1309)this).method_27661();
        String genderStr = class_2561.method_43471((String)this.getGender().getUnlocalisedSubject()).getString();
        String msg005 = ". " + genderStr.substring(0, 1).toUpperCase() + genderStr.substring(1) + " ";
        class_5250 msg01 = class_2561.method_43469((String)"dog.mode.incapacitated.msg.partition1", (Object[])new Object[]{class_2561.method_43470((String)msg005), class_2561.method_43471((String)DogMode.INJURED.getUnlocalisedName()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(14025732))});
        msg.method_10852((class_2561)msg01);
        owner.method_43496((class_2561)msg);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState createIncapSyncState(class_1282 source) {
        DogIncapacitatedMananger.DefeatedType type = source.method_48789(class_8103.field_42246) || this.method_5809() && !this.method_5753() ? DogIncapacitatedMananger.DefeatedType.BURN : (source.method_49708(class_8111.field_42349) ? DogIncapacitatedMananger.DefeatedType.POISON : (source.method_49708(class_8111.field_42342) ? DogIncapacitatedMananger.DefeatedType.DROWN : (source.method_49708(class_8111.field_42343) ? DogIncapacitatedMananger.DefeatedType.STARVE : DogIncapacitatedMananger.DefeatedType.BLOOD)));
        int poseId = this.method_6051().method_43048(2);
        return new DogIncapacitatedMananger.IncapacitatedSyncState(type, DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private void createAndSetIncapSyncState(class_1282 source) {
        DogIncapacitatedMananger.IncapacitatedSyncState state = this.createIncapSyncState(source);
        this.setIncapSyncState(state);
    }

    public double method_29241() {
        float defeated_threshold = this.method_5771() ? 0.9f : 1.0f;
        return this.isDefeated() ? (double)defeated_threshold : super.method_29241();
    }

    public void method_6010(class_6862<class_3611> tagKey) {
        if (this.method_5942().method_6350()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)0.04f, 0.0));
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, 0.3, 0.0));
        }
    }

    public void method_16078() {
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.addDTNAdditionalSavedData(compound);
    }

    public void addDTNAdditionalSavedData(class_2487 compound) {
        DimensionDependantArg<Optional<class_2338>> bowlsData;
        DimensionDependantArg<Optional<class_2338>> bedsData;
        class_2499 talentList = new class_2499();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            class_2487 talentTag = new class_2487();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.method_10566("talents", (class_2520)talentList);
        class_2499 accessoryList = new class_2499();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            class_2487 accessoryTag = new class_2487();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.method_10566("accessories", (class_2520)accessoryList);
        class_2499 artifactsListTag = new class_2499();
        List<DoggyArtifactItem> artifacts = this.getArtifactsList();
        for (DoggyArtifactItem x : artifacts) {
            class_2487 artifactTag = DoggyArtifactItem.writeCompound(x);
            if (artifactTag == null) continue;
            artifactsListTag.add((Object)artifactTag);
        }
        compound.method_10566("doggy_artifacts", (class_2520)artifactsListTag);
        compound.method_10582("classicalVariant", DogVariantUtil.toSaveString(this.dogVariant()));
        compound.method_10582("mode", this.getMode().getSaveName());
        compound.method_10582("dogGender", this.getGender().getSaveName());
        compound.method_10548("dogHunger", this.getDogHunger());
        compound.method_10569("dogIncapacitatedValue", this.getDogIncapValue());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        this.getSkinData().save(compound);
        compound.method_10556("willObey", this.willObeyOthers());
        compound.method_10556("friendlyFire", this.canOwnerAttack());
        compound.method_10556("regardTeamPlayers", this.regardTeamPlayers());
        compound.method_10556("forceSit", this.forceSit());
        compound.method_10556("dogAutoMount", this.dogAutoMount());
        compound.method_10567("lowHealthStrategy", this.getLowHealthStrategy().getId());
        compound.method_10567("combatReturnStrategy", this.getCombatReturnStrategy().getId());
        compound.method_10556("crossOriginTp", this.crossOriginTp());
        compound.method_10556("patrolTargetLock", this.patrolTargetLock());
        compound.method_10556("hideDogArmor", this.hideArmor());
        compound.method_10556("dogOnDuty", this.dogOnDuty());
        compound.method_10569("dogSize", this.getDogSize().getId());
        compound.method_10569("level_normal", this.getDogLevel().getLevel(DogLevel.Type.NORMAL));
        compound.method_10569("level_kami", this.getDogLevel().getLevel(DogLevel.Type.KAMI));
        NBTUtil.writeItemStack(compound, "fetchItem", this.getBoneVariant());
        class_1799 wolf_armor = this.wolfArmor();
        if (wolf_armor != null && !wolf_armor.method_7960()) {
            NBTUtil.writeItemStack(compound, "wolfArmorItem", wolf_armor);
        }
        if (!(bedsData = this.dogFabricHelper.getBedPos()).isEmpty()) {
            class_2499 bedsList = new class_2499();
            for (Map.Entry<class_5321<class_1937>, Optional<class_2338>> entry : bedsData.entrySet()) {
                class_2487 class_24872 = new class_2487();
                NBTUtil.putResourceLocation(class_24872, "dim", entry.getKey().method_29177());
                NBTUtil.putBlockPos(class_24872, "pos", entry.getValue());
                bedsList.add((Object)class_24872);
            }
            compound.method_10566("beds", (class_2520)bedsList);
        }
        if (!(bowlsData = this.dogFabricHelper.getBowlPos()).isEmpty()) {
            class_2499 bowlsList = new class_2499();
            for (Map.Entry<class_5321<class_1937>, Optional<class_2338>> entry : bowlsData.entrySet()) {
                class_2487 bowlsNBT = new class_2487();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().method_29177());
                NBTUtil.putBlockPos(bowlsNBT, "pos", entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.method_10566("bowls", (class_2520)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.dogOwnerDistanceManager.save(compound);
        this.pettingManager.save(compound);
        this.animationManager.save(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
        this.dogGroupsManager.save(compound);
        if (this.isDefeated()) {
            this.incapacitatedMananger.save(compound);
        }
        if (this.getMode().canWander() && this.method_18410()) {
            class_2338 restrict = this.method_18412();
            int n = (int)this.method_18413();
            if (restrict != null) {
                class_2487 class_24873 = new class_2487();
                class_24873.method_10569("wanderX", restrict.method_10263());
                class_24873.method_10569("wanderY", restrict.method_10264());
                class_24873.method_10569("wanderZ", restrict.method_10260());
                class_24873.method_10569("wanderR", n);
                compound.method_10566("dogWanderCenter", (class_2520)class_24873);
            }
        }
        if (!this.method_37908().field_9236 && !this.DTN_dogChangingDim) {
            UUID uuid = this.method_5667();
            UUID uUID = this.method_6139();
            if (uuid != null && uUID != null) {
                class_2487 class_24874 = new class_2487();
                class_24874.method_25927("dtn_uuid_owner", uUID);
                class_24874.method_25927("dtn_uuid_self", uuid);
                this.writeSessionUUIDToCompound(uuid, class_24874);
                compound.method_10566("DTN_DupeDetect_UUID", (class_2520)class_24874);
            }
        }
    }

    public void addNonDTNAdditionalData(class_2487 tag) {
        super.method_5652(tag);
    }

    public void method_5651(class_2487 compound) {
        this.authorizedChangingOwner = true;
        this.authorizedChangingName = true;
        super.method_5651(compound);
        this.authorizedChangingOwner = false;
        this.authorizedChangingName = false;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        ArrayList<TalentInstance> newTlInstLs = new ArrayList<TalentInstance>();
        this.tryReadAllTalents(compound, newTlInstLs);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.talents().addAll(newTlInstLs);
        this.dogSyncedDataManager.setTalentsDirty();
        ArrayList<AccessoryInstance> newAccInstLs = new ArrayList<AccessoryInstance>();
        this.tryReadAllAccessories(compound, newAccInstLs);
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.accessories().addAll(newAccInstLs);
        this.dogSyncedDataManager.setAccessoriesDirty();
        ArrayList<DoggyArtifactItem> artifactsList = new ArrayList<DoggyArtifactItem>(3);
        try {
            if (compound.method_10573("doggy_artifacts", 9)) {
                class_2499 artifactsListTag = compound.method_10554("doggy_artifacts", 10);
                for (int i = 0; i < artifactsListTag.size(); ++i) {
                    DoggyArtifactItem artifactItem = DoggyArtifactItem.readCompound(artifactsListTag.method_10602(i));
                    if (artifactItem == null) continue;
                    artifactsList.add(artifactItem);
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load artifacts : " + e);
        }
        this.dogFabricHelper.setArtifacts(artifactsList);
        try {
            this.spendablePoints.markForRefresh();
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.setGender(DogGender.bySaveName(compound.method_10558("dogGender")));
            if (compound.method_10573("mode", 8)) {
                this.setMode(DogMode.bySaveName(compound.method_10558("mode")));
            }
            DogSkinData dogSkinData = DogSkinData.readFromTag(compound);
            this.setDogSkinData(dogSkinData);
            if (compound.method_10573("wolfArmorItem", 10)) {
                this.setWolfArmor(NBTUtil.readItemStack(compound, "wolfArmorItem"));
            }
            if (compound.method_10573("fetchItem", 10)) {
                this.setBoneVariant(NBTUtil.readItemStack(compound, "fetchItem"));
            }
            this.setDogVariant(DogVariantUtil.fromSaveString(compound.method_10558("classicalVariant")));
            this.setHungerDirectly(compound.method_10583("dogHunger"));
            this.setDogIncapValue(compound.method_10550("dogIncapacitatedValue"));
            this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.method_10577("willObey"));
            this.setCanPlayersAttack(compound.method_10577("friendlyFire"));
            this.setRegardTeamPlayers(compound.method_10577("regardTeamPlayers"));
            this.setDogAutoMount(compound.method_10577("dogAutoMount"));
            this.setForceSit(compound.method_10577("forceSit"));
            this.setCrossOriginTp(compound.method_10577("crossOriginTp"));
            this.setPatrolTargetLock(compound.method_10577("patrolTargetLock"));
            this.setHideArmor(compound.method_10577("hideDogArmor"));
            this.setDogOnDuty(compound.method_10577("dogOnDuty"));
            byte low_health_strategy_id = compound.method_10571("lowHealthStrategy");
            this.setLowHealthStrategy(LowHealthStrategy.fromId(low_health_strategy_id));
            byte combat_return_strategy_id = compound.method_10571("combatReturnStrategy");
            this.setCombatReturnStrategy(CombatReturnStrategy.fromId(combat_return_strategy_id));
            if (compound.method_10573("dogSize", 99)) {
                this.setDogSize(DogSize.fromId(compound.method_10550("dogSize")));
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            int level_normal = 0;
            int level_kami = 0;
            if (compound.method_10573("level_normal", 99)) {
                level_normal = compound.method_10550("level_normal");
            }
            if (compound.method_10573("level_kami", 99)) {
                level_kami = compound.method_10550("level_kami");
            } else if (compound.method_10573("level_dire", 99)) {
                level_kami = compound.method_10550("level_dire");
            }
            this.dogFabricHelper.setDogLevel(new DogLevel(level_normal, level_kami));
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        DimensionDependantArg<Optional<class_2338>> bedsData = this.dogFabricHelper.getBedPos().copyEmpty();
        try {
            if (compound.method_10573("beds", 9)) {
                class_2499 bedsList = compound.method_10554("beds", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    class_2487 bedNBT = bedsList.method_10602(i);
                    class_2960 loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                    class_5321 type = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)loc);
                    Optional<class_2338> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    bedsData.put((class_5321<class_1937>)type, pos);
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load beds: " + e.getMessage());
            e.printStackTrace();
        }
        this.dogFabricHelper.setBedPos(bedsData);
        DimensionDependantArg<Optional<class_2338>> bowlsData = this.dogFabricHelper.getBowlPos().copyEmpty();
        try {
            if (compound.method_10573("bowls", 9)) {
                class_2499 bowlsList = compound.method_10554("bowls", 10);
                for (int i = 0; i < bowlsList.size(); ++i) {
                    class_2487 bowlsNBT = bowlsList.method_10602(i);
                    class_2960 loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                    class_5321 type = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)loc);
                    Optional<class_2338> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    bowlsData.put((class_5321<class_1937>)type, pos);
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load bowls: " + e.getMessage());
            e.printStackTrace();
        }
        this.dogFabricHelper.setBowlPos(bowlsData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.dogOwnerDistanceManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load owner distance manager: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.pettingManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load dog petting manager: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.animationManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load dog animation manager: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                DoggyTalentsNext.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
        try {
            this.dogGroupsManager.load(compound);
            if (this.isDefeated()) {
                this.incapacitatedMananger.load(compound);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getMode().canWander() && compound.method_10573("dogWanderCenter", 10)) {
                class_2487 wanderTg = compound.method_10562("dogWanderCenter");
                class_2338 restrictPos = new class_2338(wanderTg.method_10550("wanderX"), wanderTg.method_10550("wanderY"), wanderTg.method_10550("wanderZ"));
                int restrict_r = wanderTg.method_10550("wanderR");
                restrict_r = Math.max(0, restrict_r);
                this.method_18408(restrictPos, restrict_r);
            }
        }
        catch (Exception wanderTg) {
            // empty catch block
        }
        boolean duplicate_detected = false;
        if (!this.method_37908().field_9236) {
            try {
                duplicate_detected = this.detectDuplicate(compound);
            }
            catch (Exception restrictPos) {
                // empty catch block
            }
        }
        if (duplicate_detected) {
            int strategy = (Integer)ConfigHandler.SERVER.DUPLICATION_RESOLVE_STRATEGY.get();
            if (strategy == 0 || strategy == 1) {
                this.untame();
                if (!this.isAddedToWorld()) {
                    this.method_31745(class_1297.class_5529.field_26999);
                } else {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            }
            compound.method_10556("DTN_DupeDetect_marked", true);
            if (strategy == 0) {
                throw new IllegalStateException("This dog has been restored from third-party storage which may leads to duplications. Please restore this Dog via its Dog Bed, by using a Totem of Undying on an Unlinked Dog Bed or via [ /dog revive ] instead. This Exception usually wouldn't cause a Crash and instead silently prevent the Dog to be restored, although if a Game Breaking Crash does happen, set duplication_resolve_strategy = 1 in serverconfig to prevent this Exception to be thrown again.");
            }
            return;
        }
        this.detectedDuplicateVertified = true;
        if (!this.method_37908().field_9236) {
            try {
                this.checkAndRecorrectOwner(compound);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.method_37908().field_9236) {
            try {
                this.setAnim(DogAnimation.NONE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void tryReadAllTalents(class_2487 compound, ArrayList<TalentInstance> target) {
        try {
            if (compound.method_10573("talents", 9)) {
                class_2499 talentList = compound.method_10554("talents", 10);
                for (int i = 0; i < talentList.size(); ++i) {
                    try {
                        TalentInstance.readInstance(this, talentList.method_10602(i)).ifPresent(target::add);
                        continue;
                    }
                    catch (Exception e) {
                        DoggyTalentsNext.LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load talents : " + e);
        }
    }

    private void tryReadAllAccessories(class_2487 compound, ArrayList<AccessoryInstance> target) {
        try {
            if (compound.method_10573("accessories", 9)) {
                class_2499 accessoryList = compound.method_10554("accessories", 10);
                for (int i = 0; i < accessoryList.size(); ++i) {
                    try {
                        AccessoryInstance.readInstance(accessoryList.method_10602(i)).ifPresent(target::add);
                        continue;
                    }
                    catch (Exception e) {
                        DoggyTalentsNext.LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load accessories : " + e);
        }
    }

    private boolean detectDuplicate(class_2487 tag) {
        if (this.detectedDuplicateVertified) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return false;
        }
        if (!tag.method_10573("DTN_DupeDetect_UUID", 10)) {
            return false;
        }
        if (tag.method_10545("DTN_DupeDetect_marked")) {
            return tag.method_10577("DTN_DupeDetect_marked");
        }
        class_2487 backupUUIDTag = tag.method_10562("DTN_DupeDetect_UUID");
        UUID uuid = backupUUIDTag.method_25926("dtn_uuid_self");
        UUID ownerUUID = backupUUIDTag.method_25926("dtn_uuid_owner");
        UUID sessionUUID = null;
        if (backupUUIDTag.method_25928("session_uuid")) {
            sessionUUID = backupUUIDTag.method_25926("session_uuid");
        }
        if (uuid == null || ownerUUID == null) {
            return false;
        }
        if (this.isAddedToWorld() && uuid.equals(this.method_5667())) {
            return false;
        }
        boolean isDuplicate = false;
        if (!isDuplicate && this.checkRespawnStorageForDuplicate(uuid, ownerUUID)) {
            isDuplicate = true;
        }
        if (!isDuplicate && this.checkLocationStorageForDuplicate(uuid, ownerUUID, sessionUUID)) {
            isDuplicate = true;
        }
        if (!isDuplicate) {
            return false;
        }
        DoggyTalentsNext.LOGGER.warn("Duplicated Dog Detected! dog_uuid=[" + uuid.toString() + "] owner_uuid=[" + ownerUUID.toString() + "]");
        return true;
    }

    private boolean checkRespawnStorageForDuplicate(UUID uuid, UUID ownerUUID) {
        DogRespawnStorage storage = DogRespawnStorage.get(this.method_37908());
        if (storage == null) {
            return false;
        }
        DogRespawnData data = storage.getData(uuid);
        if (data == null) {
            return false;
        }
        UUID ownerUUID0 = data.getOwnerId();
        if (ownerUUID0 == null) {
            return false;
        }
        return !ObjectUtils.notEqual((Object)ownerUUID0, (Object)ownerUUID);
    }

    private boolean checkLocationStorageForDuplicate(UUID uuid, UUID ownerUUID, UUID sessionUUID) {
        DogLocationStorage storage = DogLocationStorage.get(this.method_37908());
        if (storage == null) {
            return false;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return false;
        }
        UUID ownerUUID0 = data.getOwnerId();
        if (ownerUUID0 == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)ownerUUID0, (Object)ownerUUID)) {
            return false;
        }
        UUID correctSessionUUID = data.getSessionUUID();
        if (correctSessionUUID == null) {
            return false;
        }
        return ObjectUtils.notEqual((Object)correctSessionUUID, (Object)sessionUUID);
    }

    private void writeSessionUUIDToCompound(UUID uuid, class_2487 tag) {
        if (this.cachedSessionUUID != null) {
            tag.method_25927("session_uuid", this.cachedSessionUUID);
            this.cachedSessionUUID = null;
            return;
        }
        class_1937 level = this.method_37908();
        if (level == null) {
            return;
        }
        DogLocationStorage storage = DogLocationStorage.get(level);
        if (storage == null) {
            return;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return;
        }
        UUID sessionUUID = data.getSessionUUID();
        if (sessionUUID == null) {
            return;
        }
        tag.method_25927("session_uuid", sessionUUID);
    }

    private void cacheSessionUUID() {
        UUID uuid = this.method_5667();
        class_1937 level = this.method_37908();
        if (level == null) {
            return;
        }
        DogLocationStorage storage = DogLocationStorage.get(level);
        if (storage == null) {
            return;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return;
        }
        UUID sessionUUID = data.getSessionUUID();
        if (sessionUUID == null) {
            return;
        }
        this.cachedSessionUUID = sessionUUID;
    }

    private void checkAndRecorrectOwner(class_2487 tag) {
        if (!tag.method_10573("DTN_DupeDetect_UUID", 10)) {
            return;
        }
        class_2487 backupUUIDTag = tag.method_10562("DTN_DupeDetect_UUID");
        UUID ownerUUID = backupUUIDTag.method_25926("dtn_uuid_owner");
        if (!ObjectUtils.notEqual((Object)ownerUUID, (Object)this.method_6139())) {
            return;
        }
        boolean prevAuthorized = this.authorizedChangingOwner;
        this.authorizedChangingOwner = true;
        this.method_6174(ownerUUID);
        this.authorizedChangingOwner = prevAuthorized;
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (ANIMATION.equals(key)) {
            this.animationManager.onAnimationChange(this.getAnim());
        }
        if (ANIM_SYNC_TIME.equals(key)) {
            this.animationManager.onSyncTimeUpdated();
        }
        if (HUNGER_INT.equals(key)) {
            this.hungerManager.onHungerUpdated(this.getDogHunger());
        }
    }

    public void onDogSyncedDataUpdated(boolean talents, boolean accessories) {
        if (talents || accessories) {
            this.refreshAlterations();
            this.spendablePoints.markForRefresh();
        }
        if (talents && this.method_37908().field_9236) {
            ClientEventHandler.onDogTalentUpdated(this);
        }
        if (accessories && this.method_37908().field_9236) {
            this.clientAccessories = new ArrayList<AccessoryInstance>(this.getAccessories());
            this.clientAccessories.sort(AccessoryInstance.RENDER_SORTER);
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.dogSyncedDataManager.onStartBeingSeenBy(player);
        this.getDogFabricHelper().onStartBeingSeenBy(player);
    }

    private void updateWanderState(DogMode mode) {
        class_2338 bowlPos;
        if (!mode.canWander()) {
            this.method_35055();
            return;
        }
        class_2338 restrictPos = this.method_24515();
        int restrictRadius = 12;
        Optional<class_2338> bowlPosOptional = this.getBowlPos();
        if (bowlPosOptional.isPresent() && (bowlPos = bowlPosOptional.get()).method_10262((class_2382)this.method_24515()) < 64.0) {
            restrictRadius = 5;
            restrictPos = bowlPos;
        }
        this.method_18408(restrictPos, restrictRadius);
    }

    private boolean invalidateWanderCenter(int distanceSqr) {
        if (!this.method_18410()) {
            return false;
        }
        class_2338 restrict_pos = this.method_18412();
        if (restrict_pos == null) {
            return false;
        }
        if (restrict_pos.method_10262((class_2382)this.method_24515()) >= (double)distanceSqr) {
            this.method_35055();
            return true;
        }
        return false;
    }

    public void refreshAlterations() {
        for (IDogAlteration iDogAlteration : this.alterations) {
            iDogAlteration.remove(this);
        }
        this.alterations.clear();
        this.foodHandlers.clear();
        this.alterationProps = new DogAlterationProps();
        this.dogRangedAttackManager = IDogRangedAttackManager.NONE;
        DogVariant dogVariant = this.dogVariant();
        if (dogVariant instanceof IDogAlteration) {
            IDogAlteration alter_var = (IDogAlteration)((Object)dogVariant);
            this.alterations.add(alter_var);
        }
        for (AccessoryInstance accessoryInstance : this.getAccessories()) {
            if (accessoryInstance instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)accessoryInstance));
            }
            if (!(accessoryInstance instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)accessoryInstance));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst3 : talents) {
            if (!(inst3 instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst3));
        }
        List<DoggyArtifactItem> list = this.getArtifactsList();
        for (DoggyArtifactItem artifactItem : list) {
            DoggyArtifact artifact = artifactItem.createArtifact();
            this.alterations.add(artifact);
        }
        for (IDogAlteration inst4 : this.alterations) {
            inst4.props(this, this.alterationProps);
            inst4.init(this);
            if (this.dogRangedAttackManager != IDogRangedAttackManager.NONE || !inst4.getRangedAttack().isPresent()) continue;
            this.dogRangedAttackManager = inst4.getRangedAttack().get();
        }
        this.onPropsUpdated();
    }

    private void onPropsUpdated() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.dogArmors.onPropsUpdated(this.alterationProps);
        if (!this.alterationProps.canUseTools()) {
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        this.dogSwimmingManager.onPropsUpdated(this.alterationProps);
    }

    public IDogRangedAttackManager getDogRangedAttack() {
        if (this.dogRangedAttackManager == null) {
            return IDogRangedAttackManager.NONE;
        }
        return this.dogRangedAttackManager;
    }

    @Override
    public boolean canInteract(class_1309 livingEntity) {
        if (!this.isDoingFine()) {
            return false;
        }
        return this.willObeyOthers() || this.method_6171(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return this.dogSyncedDataManager.accessories();
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        this.dogSyncedDataManager.accessories().add(accessoryInst);
        this.dogSyncedDataManager.setAccessoriesDirty();
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList<AccessoryInstance> removed = new ArrayList<AccessoryInstance>(this.getAccessories());
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.setAccessoriesDirty();
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<class_2561> getOwnersName() {
        return (Optional)this.field_6011.method_12789(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable class_2561 comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<class_2561> collar) {
        this.field_6011.method_12778(LAST_KNOWN_NAME, collar);
    }

    public DogVariant dogVariant() {
        return this.dogFabricHelper.getDogVariant();
    }

    public void setDogVariant(DogVariant val) {
        this.dogFabricHelper.setDogVariant(val);
    }

    public DogGender getGender() {
        return this.dogFabricHelper.getDogGender();
    }

    public void setGender(DogGender collar) {
        this.dogFabricHelper.setDogGender(collar);
    }

    @Override
    public DogMode getMode() {
        return this.dogFabricHelper.getDogMode();
    }

    public boolean isMode(DogMode ... modes) {
        DogMode mode = this.getMode();
        for (DogMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(DogMode collar) {
        this.dogFabricHelper.setDogMode(collar);
    }

    public Optional<class_2338> getBedPos() {
        return this.getBedPos((class_5321<class_1937>)this.method_37908().method_27983());
    }

    public Optional<class_2338> getBedPos(class_5321<class_1937> registryKey) {
        return this.dogFabricHelper.getBedPos().getOrDefault(registryKey, Optional.empty());
    }

    public void setBedPos(@Nullable class_2338 pos) {
        this.setBedPos((class_5321<class_1937>)this.method_37908().method_27983(), pos);
    }

    public void setBedPos(class_5321<class_1937> registryKey, @Nullable class_2338 pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(class_5321<class_1937> registryKey, Optional<class_2338> pos) {
        this.dogFabricHelper.setBedPos(this.dogFabricHelper.getBedPos().copy().set(registryKey, pos));
    }

    public Optional<class_2338> getBowlPos() {
        return this.getBowlPos((class_5321<class_1937>)this.method_37908().method_27983());
    }

    public Optional<class_2338> getBowlPos(class_5321<class_1937> registryKey) {
        return this.dogFabricHelper.getBowlPos().getOrDefault(registryKey, Optional.empty());
    }

    public void setBowlPos(@Nullable class_2338 pos) {
        this.setBowlPos((class_5321<class_1937>)this.method_37908().method_27983(), pos);
    }

    public void setBowlPos(class_5321<class_1937> registryKey, @Nullable class_2338 pos) {
        this.setBowlPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(class_5321<class_1937> registryKey, Optional<class_2338> pos) {
        this.dogFabricHelper.setBowlPos(this.dogFabricHelper.getBowlPos().copy().set(registryKey, pos));
    }

    @Override
    public int getDefaultInitIncapVal() {
        return 64;
    }

    @Override
    public int getMaxDogIncapVal() {
        return 256;
    }

    @Override
    public int getDogIncapValue() {
        return (Integer)this.field_6011.method_12789(INCAP_VAL);
    }

    @Override
    public void setDogIncapValue(int val) {
        val = class_3532.method_15340((int)val, (int)0, (int)this.getMaxDogIncapVal());
        this.field_6011.method_12778(INCAP_VAL, (Object)val);
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = 120.0f;
        for (IDogAlteration alter : this.alterations) {
            class_1271<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.method_5467().method_23666()) continue;
            maxHunger = ((Float)result.method_5466()).floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.field_6011.method_12789(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        this.hungerManager.addHunger(add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            class_1271<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.method_5467().method_23666()) continue;
            hunger = ((Float)result.method_5466()).floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(class_3532.method_15363((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.field_6011.method_12778(HUNGER_INT, (Object)Float.valueOf(hunger));
    }

    public void method_6025(float add) {
        if (add <= 0.0f) {
            return;
        }
        float h = this.method_6032();
        if (h > 0.0f) {
            this.method_6033(h + add);
        }
    }

    public void method_5980(@Nullable class_1309 target) {
        if (target == this) {
            target = null;
        }
        UUID owner_id = this.method_6139();
        if (target != null && owner_id != null && owner_id.equals(target.method_5667())) {
            target = null;
        }
        class_1309 oldTarget = this.method_5968();
        super.method_5980(target);
        class_1309 newTarget = this.method_5968();
        if (oldTarget != newTarget) {
            for (IDogAlteration alt : this.alterations) {
                alt.onDogSetTarget(this, newTarget, oldTarget);
            }
            this.dogAttackManager.onTargetChange();
        }
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinData().getHash());
    }

    public DogSkinData getSkinData() {
        return this.dogFabricHelper.getDogSkin();
    }

    public void setDogSkinData(DogSkinData data) {
        if (data == null) {
            data = DogSkinData.NULL;
        }
        this.dogFabricHelper.setDogSkin(data);
    }

    @Override
    public DogLevel getDogLevel() {
        return this.dogFabricHelper.getDogLevel();
    }

    public void setLevel(DogLevel level) {
        this.dogFabricHelper.setDogLevel(level);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState getIncapSyncState() {
        return this.dogFabricHelper.getIncapSyncState();
    }

    public void setIncapSyncState(DogIncapacitatedMananger.IncapacitatedSyncState state) {
        this.dogFabricHelper.setIncapSyncState(state);
    }

    public DogPettingManager.DogPettingState getPettingState() {
        return this.dogFabricHelper.getDogPettingState();
    }

    public void setPettingState(DogPettingManager.DogPettingState state) {
        this.dogFabricHelper.setDogPettingState(state);
    }

    public DogSleepOnManager.DogSleepOnState getSleepOnState() {
        return this.dogFabricHelper.getDogSleepOnState();
    }

    public void setSleepOnState(DogSleepOnManager.DogSleepOnState state) {
        this.dogFabricHelper.setDogSleepOnState(state);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        DogLevel copy = this.getDogLevel().copy();
        copy.incrementLevel(typeIn);
        this.setLevel(copy);
    }

    @Override
    public void setDogSize(DogSize size) {
        this.dogFabricHelper.setDogSize(size);
    }

    @Override
    public DogSize getDogSize() {
        return this.dogFabricHelper.getDogSize();
    }

    public boolean method_6109() {
        if (this.getDogSize() == DogSize.PPP) {
            return true;
        }
        return super.method_6109();
    }

    public void setBoneVariant(class_1799 stack) {
        this.field_6011.method_12778(BONE_VARIANT, (Object)stack);
    }

    public class_1799 getBoneVariant() {
        return (class_1799)this.field_6011.method_12789(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        class_1792 item = ((class_1799)this.field_6011.method_12789(BONE_VARIANT)).method_7909();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().method_7960();
    }

    private boolean getDogFlag(int bit) {
        return ((Integer)this.field_6011.method_12789(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        int c = (Integer)this.field_6011.method_12789(DOG_FLAGS);
        this.field_6011.method_12778(DOG_FLAGS, (Object)(flag ? c | bits : c & ~bits));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canOwnerAttack() {
        return this.getDogFlag(4);
    }

    public void setForceSit(boolean val) {
        this.setDogFlag(8, val);
    }

    public boolean forceSit() {
        return this.getDogFlag(8);
    }

    public LowHealthStrategy getLowHealthStrategy() {
        int msb = this.getDogFlag(32) ? 1 : 0;
        int lsb = this.getDogFlag(16) ? 1 : 0;
        return LowHealthStrategy.fromId(msb * 2 + lsb);
    }

    public void setLowHealthStrategy(LowHealthStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(32, msb);
        this.setDogFlag(16, lsb);
    }

    public CombatReturnStrategy getCombatReturnStrategy() {
        int msb = this.getDogFlag(8192) ? 1 : 0;
        int lsb = this.getDogFlag(4096) ? 1 : 0;
        return CombatReturnStrategy.fromId(msb * 2 + lsb);
    }

    public void setCombatReturnStrategy(CombatReturnStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(8192, msb);
        this.setDogFlag(4096, lsb);
    }

    public void setRegardTeamPlayers(boolean val) {
        this.setDogFlag(128, val);
    }

    public boolean regardTeamPlayers() {
        return this.getDogFlag(128);
    }

    public boolean crossOriginTp() {
        return this.getDogFlag(64);
    }

    public void setCrossOriginTp(boolean val) {
        this.setDogFlag(64, val);
    }

    public RestingState getDogRestingState() {
        boolean isResting = this.getDogFlag(32768);
        if (!isResting) {
            return RestingState.NONE;
        }
        boolean bellyUp = this.getDogFlag(65536);
        return bellyUp ? RestingState.BELLY : RestingState.LYING;
    }

    public void setDogRestingState(RestingState val) {
        if (val == null) {
            val = RestingState.NONE;
        }
        switch (val) {
            default: {
                this.setDogFlag(32768, false);
                this.setDogFlag(65536, false);
                break;
            }
            case LYING: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, false);
                break;
            }
            case BELLY: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, true);
            }
        }
    }

    public boolean isDogResting() {
        return this.getDogRestingState() != RestingState.NONE;
    }

    public boolean patrolTargetLock() {
        return this.getDogFlag(512);
    }

    public boolean isInDrunkPose() {
        return this.getDogFlag(131072);
    }

    public void setInDrunkPose(boolean val) {
        this.setDogFlag(131072, val);
    }

    public void setForcedActionAnim(boolean val) {
        this.setDogFlag(262144, val);
    }

    @Override
    public boolean forcedWhenNoneAnim() {
        return this.getDogFlag(262144);
    }

    public void setDogOnDuty(boolean val) {
        this.setDogFlag(256, val);
    }

    public boolean dogOnDuty() {
        return this.getDogFlag(256);
    }

    public void setDrunkTicks(int ticks) {
        this.drunkTickLeft = ticks;
    }

    public boolean isDogDrunk() {
        return this.drunkTickLeft > 0;
    }

    public void setSilentTickLeft(int ticks) {
        this.silentTickLeft = ticks;
    }

    public boolean isDogSilent() {
        return this.silentTickLeft > 0;
    }

    public void setPatrolTargetLock(boolean val) {
        this.setDogFlag(512, val);
    }

    public boolean hideArmor() {
        return this.getDogFlag(2048);
    }

    public void setHideArmor(boolean val) {
        this.setDogFlag(2048, val);
    }

    public boolean dogAutoMount() {
        return this.getDogFlag(16384);
    }

    public void setDogAutoMount(boolean val) {
        this.setDogFlag(16384, val);
    }

    public boolean wantsToRest() {
        return this.tickUntilRest <= 0 && this.method_6051().method_43057() < 0.02f;
    }

    public void resetTickTillRest() {
        this.tickUntilRest = 600 + this.method_6051().method_43048(271) * 20;
    }

    public List<TalentInstance> getTalentMap() {
        return this.dogSyncedDataManager.talents();
    }

    public class_1269 setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return class_1269.field_5814;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        int selected_id = -1;
        for (int i = 0; i < activeTalents.size(); ++i) {
            TalentInstance activeInst = activeTalents.get(i);
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            selected_id = i;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return class_1269.field_5811;
            }
            TalentInstance newTalent = talent.getDefault(level);
            this.dogSyncedDataManager.talents().add(newTalent);
        } else {
            int remove_id;
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return class_1269.field_5811;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level <= 0 && (remove_id = selected_id) >= 0) {
                this.dogSyncedDataManager.talents().remove(remove_id);
            }
        }
        this.dogSyncedDataManager.setTalentsDirty();
        return class_1269.field_5812;
    }

    public List<DoggyArtifactItem> getArtifactsList() {
        List<DoggyArtifactItem> array = this.dogFabricHelper.getArtifacts();
        return array;
    }

    public boolean addArtifact(DoggyArtifactItem artifact) {
        if (artifact == null) {
            return false;
        }
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (array.size() >= 3) {
            return false;
        }
        if (array.contains((Object)artifact)) {
            return false;
        }
        this.modifyArtifact(artifacts -> artifacts.add(artifact));
        return true;
    }

    public class_1799 removeArtifact(int indx) {
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (indx < 0 || indx >= array.size()) {
            return null;
        }
        DoggyArtifactItem removedArtifact = array.get(indx);
        this.modifyArtifact(artifacts -> artifacts.remove(indx));
        return new class_1799((class_1935)removedArtifact);
    }

    public void modifyArtifact(Consumer<List<DoggyArtifactItem>> modify) {
        ArrayList<DoggyArtifactItem> list = new ArrayList<DoggyArtifactItem>(this.dogFabricHelper.getArtifacts());
        modify.accept(list);
        this.dogFabricHelper.setArtifacts(list);
    }

    public <T> void modifyListSyncedData(class_2940<List<T>> key, Consumer<List<T>> modify) {
        this.modifySyncedData(key, modify, x -> new ArrayList(x));
    }

    public <T> void modifySyncedData(class_2940<T> key, Consumer<T> modify, Function<T, T> copyFunc) {
        Object result = copyFunc.apply(this.field_6011.method_12789(key));
        modify.accept(result);
        this.field_6011.method_12778(key, result);
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    public <T extends TalentInstance> Optional<T> getTalent(Talent talent, Class<T> type) {
        Optional<TalentInstance> inst_optional = this.getTalent(talent);
        return inst_optional.map(x -> x.cast(type));
    }

    @Override
    public int getDogLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    public void untame() {
        this.field_6189.method_6340();
        this.clearTriggerableAction();
        this.dogAi.forceStopAllGoal();
        this.method_24346(false);
        this.method_6033(8.0f);
        this.setDogCustomName(null);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.setTalentsDirty();
        this.authorizedChangingOwner = true;
        this.method_6173(false);
        this.method_6174(null);
        this.setWillObeyOthers(false);
        this.setCanPlayersAttack(true);
        this.setMode(DogMode.DOCILE);
        this.authorizedChangingOwner = false;
    }

    public void migrateOwner(UUID newOwnerUUID) {
        this.field_6189.method_6340();
        this.clearTriggerableAction();
        this.dogAi.forceStopAllGoal();
        this.setMode(DogMode.DOCILE);
        this.authorizedChangingOwner = true;
        this.method_6174(newOwnerUUID);
        this.authorizedChangingOwner = false;
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory(DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getDogLevel().getLevel(DogLevel.Type.NORMAL) + this.getDogLevel().getLevel(DogLevel.Type.KAMI);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public class_1309 method_5642() {
        List passengers = this.method_5685();
        if (passengers.isEmpty()) {
            return null;
        }
        class_1297 first_passenger = (class_1297)passengers.get(0);
        if (!(first_passenger instanceof class_1657)) {
            return null;
        }
        class_1657 player = (class_1657)first_passenger;
        return this.canInteract((class_1309)player) ? player : null;
    }

    public class_243 method_24829(class_1309 passenger) {
        float a1 = this.method_36454();
        float dx1 = -class_3532.method_15374((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = class_3532.method_15362((float)(a1 * ((float)Math.PI / 180)));
        double newX = this.method_23317() + (double)dx1;
        double newZ = this.method_23321() + (double)dz1;
        class_243 newPos = new class_243(newX, this.method_23318() + 0.5, newZ);
        class_2338 b0 = class_2338.method_49638((class_2374)newPos);
        class_7 type = class_14.method_23476((class_1922)this.method_37908(), (class_2338.class_2339)b0.method_25503());
        if (type == class_7.field_12) {
            return newPos;
        }
        return super.method_24829(passenger);
    }

    public boolean method_5863() {
        if (this.method_37908().field_9236 && ClientEventHandler.shouldClientBlockPick(this)) {
            return false;
        }
        return super.method_5863();
    }

    public boolean method_5810() {
        return (!this.method_5782() || !this.method_42148()) && super.method_5810();
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void method_6091(class_243 positionIn) {
        if (this.isDogResistingPush()) {
            this.mayDogResistPush();
        }
        super.method_6091(positionIn);
        if (this.isDogFlying()) {
            class_243 moveVec = this.method_18798();
            double down = moveVec.field_1351;
            double gravity = -0.112102;
            class_1324 attrib = this.method_5996(ForgeMod.ENTITY_GRAVITY.get());
            if (attrib != null) {
                gravity = -attrib.method_6194();
            }
            down = down < 0.0 ? Math.min(down * 0.7, gravity) : (down *= 0.7);
            this.method_18800(moveVec.field_1352 * 0.67, down, moveVec.field_1350 * 0.67);
        }
        this.addMovementStat(this.method_23317() - this.field_6014, this.method_23318() - this.field_6036, this.method_23321() - this.field_5969);
    }

    private void mayDogResistPush() {
        double moveZ;
        if (!this.canDogResistPush()) {
            return;
        }
        double max_XZ_push_len = this.getDogPushResistXZCap();
        class_243 move = this.method_18798();
        double moveX = move.method_10216();
        double moveXZ_lSqr = moveX * moveX + (moveZ = move.method_10215()) * moveZ;
        if (moveXZ_lSqr <= max_XZ_push_len * max_XZ_push_len) {
            return;
        }
        double moveXZ_l = Math.sqrt(moveXZ_lSqr);
        moveX = moveX / moveXZ_l * max_XZ_push_len;
        moveZ = moveZ / moveXZ_l * max_XZ_push_len;
        this.method_18799(new class_243(moveX, move.method_10214(), moveZ));
    }

    public boolean canDogResistPush() {
        if (!this.method_24828()) {
            return false;
        }
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.isDogCurious()) {
            return false;
        }
        if (this.method_5782()) {
            return false;
        }
        return !this.method_6150();
    }

    private void mayFloatDogInLava() {
        if (!this.method_5771()) {
            return;
        }
        class_3726 collisioncontext = class_3726.method_16195((class_1297)this);
        if (collisioncontext.method_16192(class_2404.field_24412, this.method_24515(), true) && !this.method_37908().method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15518)) {
            this.method_24830(true);
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, 0.085, 0.0));
        }
    }

    protected float method_49484() {
        return this.isDogFlying() ? 0.49f : super.method_49484();
    }

    public boolean canDogFly() {
        return this.alterationProps.canFly() && this.alterationProps.willFly();
    }

    protected void method_49481(class_1657 rider, class_243 rideVec) {
        if (this.isDefeated()) {
            return;
        }
        this.method_36456(rider.method_36454());
        this.field_5982 = this.method_36454();
        this.method_36457(rider.method_36455() * 0.5f);
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6241 = this.field_6283 = this.method_36454();
        this.checkAndJumpWhenBeingRidden((class_1309)rider);
        if (this.method_6101()) {
            this.field_6017 = 0.0f;
        }
        this.addMovementStat(this.method_23317() - this.field_6014, this.method_23318() - this.field_6036, this.method_23321() - this.field_5969);
    }

    protected class_1330 method_5963() {
        return new DogBodyRotationControl(this);
    }

    private void checkAndJumpWhenBeingRidden(class_1309 rider) {
        float forward = rider.field_6250;
        if (this.jumpPower > 0.0f) {
            if (this.method_5799() && this.canSwimUnderwater()) {
                this.doDogRideFloat();
            } else if (!this.isDogJumping() && this.method_24828()) {
                this.doDogRideJump(forward);
            }
        }
        if (this.method_24828()) {
            this.jumpPower = 0.0f;
            this.setDogJumping(false);
        } else {
            this.jumpPower = 0.0f;
        }
    }

    protected class_243 method_49482(class_1657 rider, class_243 rideVec) {
        float straf = rider.field_6212 * 0.7f;
        float forward = rider.field_6250;
        double downward = rideVec.field_1351;
        if (forward > 0.0f && !this.isDogRidingConstraintToGround()) {
            float l = forward;
            downward = -l * class_3532.method_15374((float)(rider.method_36455() * ((float)Math.PI / 180)));
            forward = l * class_3532.method_15362((float)(rider.method_36455() * ((float)Math.PI / 180)));
        }
        if (forward <= 0.0f) {
            forward *= 0.5f;
        }
        return new class_243((double)straf, downward, (double)forward);
    }

    protected boolean isDogRidingConstraintToGround() {
        if (this.method_5799() && this.canSwimUnderwater()) {
            return false;
        }
        return !this.canDogFly();
    }

    protected float method_49485(class_1657 rider) {
        return (float)this.method_5996(class_5134.field_23719).method_6194() * 0.5f;
    }

    private void doDogRideFloat() {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, 0.1, vec3d.field_1350);
        this.jumpPower = 0.0f;
    }

    private void doDogRideJump(double forward) {
        double jumpValue = this.method_5996(DoggyAttributes.JUMP_POWER.get()).method_6194() * (double)this.method_23313() * (double)this.jumpPower;
        if (this.method_6059(class_1294.field_5913)) {
            jumpValue += (double)((float)(this.method_6112(class_1294.field_5913).method_5578() + 1) * 0.1f);
        }
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, jumpValue, vec3d.field_1350);
        this.setDogJumping(true);
        this.field_6007 = true;
        if (forward > 0.0) {
            float amount = 0.4f;
            float compX = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
            float compZ = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
            this.method_18799(this.method_18798().method_1031((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
        }
        this.jumpPower = 0.0f;
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.method_5782()) {
            j = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.method_5765()) {
            if (this.method_5777(class_3486.field_15517)) {
                j = Math.round(class_3532.method_15355((float)((float)(xD * xD + yD * yD + zD * zD))) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.method_5799()) {
                int k = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.method_24828()) {
                int l = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (l > 0) {
                    if (this.method_5624()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.method_18276()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(class_3532.method_15355((float)((float)(xD * xD + zD * zD))) * 100.0f);
            }
        }
    }

    public boolean method_5675() {
        if (this.method_5753()) {
            return false;
        }
        if (this.alterationProps.resistWaterPush()) {
            return false;
        }
        if (this.isDogRunningAwayFromFire()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            class_1269 result = alter.canResistPushFromFluidType();
            if (!result.method_23666()) continue;
            return false;
        }
        return super.method_5675();
    }

    public class_5250 getTranslationKey(Function<DogGender, String> function) {
        return class_2561.method_43471((String)((String)function.apply((Object)((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER) == false ? this.getGender() : DogGender.UNISEX))));
    }

    @Override
    public boolean isLying() {
        boolean ownerSleeping;
        class_1309 owner = this.method_35057();
        boolean bl = ownerSleeping = owner != null && owner.method_6113();
        if (ownerSleeping) {
            return true;
        }
        if (this.isDefeated()) {
            boolean onBed;
            class_2680 blockBelow = this.method_37908().method_8320(this.method_24515());
            boolean bl2 = onBed = blockBelow.method_27852((class_2248)DoggyBlocks.DOG_BED.get()) || blockBelow.method_26164(class_3481.field_16443);
            if (onBed) {
                return true;
            }
        }
        return false;
    }

    public void method_6179(boolean sit) {
        if (!this.method_37908().field_9236 && this.animAction == null) {
            boolean sit0 = this.method_6172();
            if (sit0 != sit) {
                DogAnimation anim;
                DogAnimation dogAnimation = anim = sit ? this.getSitAnim() : this.getStandAnim();
                if (!sit0 && this.isLying()) {
                    anim = DogAnimation.NONE;
                }
                if (anim != DogAnimation.NONE) {
                    this.setAnim(anim);
                }
            }
            this.sitAnim = DogAnimation.SIT_DOWN;
            this.standAnim = DogAnimation.STAND_QUICK;
        }
        super.method_6179(sit);
    }

    public void setSitAnim(DogAnimation anim) {
        if (anim == null) {
            this.sitAnim = DogAnimation.SIT_DOWN;
            return;
        }
        this.sitAnim = anim;
    }

    public DogAnimation getStandAnim() {
        return this.standAnim;
    }

    public void setStandAnim(DogAnimation anim) {
        if (anim == null) {
            this.standAnim = DogAnimation.STAND_QUICK;
            return;
        }
        this.standAnim = anim;
    }

    public DogAnimation getSitAnim() {
        return this.sitAnim;
    }

    public void method_24346(boolean val) {
        super.method_24346(val);
        this.mayDogCorrectSittingPose(val);
    }

    private void mayDogCorrectSittingPose(boolean sit_ordered) {
        if (this.method_37908().field_9236) {
            return;
        }
        if (sit_ordered) {
            return;
        }
        if (this.dogAi == null) {
            return;
        }
        if (this.dogAi.isSitGoalRunning()) {
            return;
        }
        this.method_6179(false);
    }

    public void setChopinTailFor(int ticks) {
        this.tickChopinTail = ticks;
    }

    public boolean isChopinTail() {
        return this.tickChopinTail > 0;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    @Override
    public void resetNavigation() {
        this.setNavigation(this.defaultNavigation);
    }

    @Override
    public void resetMoveControl() {
        this.setMoveControl(this.defaultMoveControl);
    }

    @Override
    public void setNavigation(class_1408 p) {
        super.setNavigation(p);
        this.switchNavCooldown = 5;
        if (p instanceof IDogNavLock) {
            IDogNavLock lock = (IDogNavLock)p;
            this.currentNavigation = p;
            this.navigationLock = lock;
        }
    }

    @Override
    public class_1408 getDefaultNavigation() {
        return this.defaultNavigation;
    }

    @Override
    public class_1335 getDefaultMoveControl() {
        return this.defaultMoveControl;
    }

    public boolean isDefaultNavigation() {
        return this.defaultNavigation == this.method_5942();
    }

    protected class_1408 method_5965(class_1937 p_21480_) {
        DogPathNavigation dogPathNav = new DogPathNavigation(this, p_21480_);
        this.currentNavigation = dogPathNav;
        this.navigationLock = dogPathNav;
        this.navigationLock.lockDogNavigation();
        return dogPathNav;
    }

    public void setDogSitOverridePos(@Nonnull class_2338 pos) {
        this.lastSitPos = Optional.of(pos);
        this.lastSitPosSaveTimestamp = this.field_6012;
    }

    public void clearDogSitOverridePos() {
        this.lastSitPos = Optional.empty();
    }

    public Optional<class_2338> getDogSitOverridePos() {
        return this.lastSitPos;
    }

    public int getDogSitOverridePosTimestamp() {
        return this.lastSitPosSaveTimestamp;
    }

    public float method_5944(class_7 type) {
        switch (type) {
            default: {
                break;
            }
            case field_18: 
            case field_4: {
                if (!this.shouldDogOmitWaterPathWeight()) break;
                return 0.0f;
            }
            case field_14: 
            case field_3: 
            case field_9: {
                if (!this.method_5753()) break;
                return 0.0f;
            }
            case field_23: {
                if (!this.canDogPassGate()) break;
                return 8.0f;
            }
            case field_36432: 
            case field_33534: {
                return -1.0f;
            }
        }
        return super.method_5944(type);
    }

    private boolean shouldDogOmitWaterPathWeight() {
        if (this.isDogFollowingSomeone()) {
            return true;
        }
        if (!this.method_5799()) {
            return false;
        }
        if (this.alterationProps.canBreatheUnderwater()) {
            return true;
        }
        return this.canSwimUnderwater() && !this.isLowAirSupply();
    }

    public boolean shouldDogBlockFloat() {
        return this.method_5753() && this.method_5771();
    }

    public boolean isDogFollowingSomeone() {
        return this.isDogFollowingSomeone;
    }

    public void setDogFollowingSomeone(boolean val) {
        this.isDogFollowingSomeone = val;
    }

    public void setDogResistingPush(boolean val) {
        this.isDogResistingPush = val;
    }

    public boolean isDogResistingPush() {
        return this.isDogResistingPush;
    }

    public double getDogPushResistXZCap() {
        return 5.0E-4;
    }

    public List<IDogAlteration> getAlterations() {
        return this.alterations;
    }

    @Override
    public boolean canSwimUnderwater() {
        return this.alterationProps.canSwimUnderwater();
    }

    @Override
    public boolean canDogWearArmor() {
        return this.alterationProps.canWearArmor();
    }

    @Override
    public boolean canDogUseTools() {
        return this.alterationProps.canUseTools();
    }

    @Override
    public DogArmorItemHandler dogArmors() {
        return this.dogArmors;
    }

    @Override
    public class_1799 wolfArmor() {
        return class_1799.field_8037;
    }

    public void setWolfArmor(class_1799 stack) {
    }

    public boolean hasWolfArmor() {
        return !this.wolfArmor().method_7960();
    }

    public Iterable<class_1799> method_5877() {
        if (!this.canDogUseTools() || this.mouthStack == null) {
            return List.of();
        }
        return List.of(this.mouthStack);
    }

    public Iterable<class_1799> method_5661() {
        if (!this.canDogWearArmor()) {
            return List.of();
        }
        return this.dogArmors.armors();
    }

    public Iterable<class_1799> getArmorAndBodyArmorSlots() {
        return this.method_5661();
    }

    public class_1799 method_6118(class_1304 slot) {
        boolean getMouth;
        boolean getArmor;
        class_1304.class_1305 type = slot.method_5925();
        boolean bl = getArmor = type == class_1304.class_1305.field_6178 && (this.alterationProps.canWearArmor() || this.method_37908().field_9236);
        if (getArmor) {
            return this.dogArmors.getArmorFromSlot(slot);
        }
        boolean bl2 = getMouth = slot == class_1304.field_6173 && (this.alterationProps.canUseTools() || this.method_37908().field_9236) && this.mouthStack != null;
        if (getMouth) {
            return this.mouthStack;
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        if (this.trySetDogArmorSlot(slot, stack)) {
            return;
        }
        if (this.trySetDogToolSlot(slot, stack)) {
            return;
        }
        if (this.trySetWolfArmor(slot, stack)) {
            return;
        }
    }

    private boolean trySetDogArmorSlot(class_1304 slot, class_1799 stack) {
        if (slot.method_5925() != class_1304.class_1305.field_6178) {
            return false;
        }
        if (!this.method_37908().field_9236 && !this.canDogWearArmor()) {
            return false;
        }
        class_1799 oldStack = this.dogArmors.getArmorFromSlot(slot);
        this.dogArmors.setArmorInSlot(stack, slot);
        this.method_6116(slot, oldStack, stack);
        return true;
    }

    private boolean trySetDogToolSlot(class_1304 slot, class_1799 stack) {
        if (slot != class_1304.field_6173) {
            return false;
        }
        if (!this.method_37908().field_9236 && !this.canDogUseTools()) {
            return false;
        }
        class_1799 oldStack = this.mouthStack == null ? class_1799.field_8037 : this.mouthStack;
        this.mouthStack = stack;
        this.method_6116(slot, oldStack, stack);
        return true;
    }

    private boolean trySetWolfArmor(class_1304 slot, class_1799 stack) {
        return false;
    }

    public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
        boolean is_slot_should_be_handled;
        class_1304.class_1305 type = slot.method_5925();
        boolean bl = is_slot_should_be_handled = type == class_1304.class_1305.field_6178;
        if (!is_slot_should_be_handled) {
            return;
        }
        super.method_6116(slot, oldStack, newStack);
    }

    public boolean method_18397(class_1799 stack) {
        return this.checkEligibleArmorItemAndAvailableSlot(stack);
    }

    private boolean checkEligibleArmorItemAndAvailableSlot(class_1799 stack) {
        if (!this.canDogWearArmor()) {
            return false;
        }
        if (!(stack.method_7909() instanceof class_1738)) {
            return false;
        }
        class_1304 slot = Dog.method_32326((class_1799)stack);
        if (slot.method_5925() != class_1304.class_1305.field_6178) {
            return false;
        }
        class_1799 current = this.method_6118(slot);
        return current == null || current.method_7960();
    }

    protected void method_16080(class_1282 source) {
        this.method_16078();
    }

    public boolean isLowAirSupply() {
        return (double)this.method_5669() < (double)this.method_5748() * 0.3;
    }

    @Override
    public boolean isDogLowHealth() {
        return this.method_6032() < 6.0f;
    }

    @Override
    public void setDogSwimming(boolean s) {
        this.isDogSwimming = s;
    }

    public boolean isDogSwimming() {
        return this.isDogSwimming;
    }

    public void setDogRunningAwayFromFire(boolean val) {
        this.isDogRunningAwayFromFire = val;
    }

    public boolean isDogRunningAwayFromFire() {
        return this.isDogRunningAwayFromFire;
    }

    public boolean isDogCurious() {
        return this.isDogCurious;
    }

    public void setDogCurious(boolean val) {
        this.isDogCurious = val;
    }

    @Override
    public void setDogFlying(boolean s) {
        this.setDogFlag(1024, s);
    }

    @Override
    public boolean isDogFlying() {
        return this.getDogFlag(1024);
    }

    public boolean isLowHunger() {
        return this.hungerManager.isLowHunger();
    }

    protected void method_20417() {
        boolean incapBlockedMove = this.isDefeated() && !this.incapacitatedMananger.canMove();
        boolean animBlockedMove = this.animAction != null;
        boolean animBlockedLook = this.animAction != null;
        boolean notControlledByPlayer = !(this.method_5642() instanceof class_3222);
        boolean notRidingBoat = !(this.method_5854() instanceof class_1690);
        this.dogAi.setLockedFlag(class_1352.class_4134.field_18405, notControlledByPlayer && !incapBlockedMove && !animBlockedMove);
        this.dogAi.setLockedFlag(class_1352.class_4134.field_18407, notControlledByPlayer && notRidingBoat);
        this.dogAi.setLockedFlag(class_1352.class_4134.field_18406, notControlledByPlayer && !animBlockedLook);
    }

    protected void method_6087(class_1297 pushTarget) {
        if (this.pettingManager.checkPush(pushTarget)) {
            return;
        }
        if (this.dogPushAvoidManager.shouldBlockPush(pushTarget)) {
            return;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(pushTarget)) {
            return;
        }
        if (pushTarget.method_5854() == this || this.method_5854() == pushTarget) {
            return;
        }
        if (this.method_5782() && !this.method_42148()) {
            this.pushDogAsVehicle(pushTarget);
        } else {
            super.method_6087(pushTarget);
        }
    }

    public void method_5697(class_1297 source) {
        if (source.method_5854() == this || this.method_5854() == source) {
            return;
        }
        if (this.pettingManager.checkPush(source)) {
            return;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(source)) {
            this.incapacitatedMananger.customBeingPushed(source, this::calcDogPushVec);
            return;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return;
        }
        if (this.method_5782() && !this.method_42148()) {
            this.pushDogAsVehicle(source);
        } else {
            if (this.isDogCurious()) {
                this.setDogCurious(false);
            }
            super.method_5697(source);
        }
    }

    private void pushDogAsVehicle(class_1297 source) {
        Optional<class_243> push_vec_optional = this.calcDogPushVec(source);
        if (!push_vec_optional.isPresent()) {
            return;
        }
        class_243 push_vec = push_vec_optional.get();
        if (this.method_5810()) {
            this.method_5762(-push_vec.method_10216(), 0.0, -push_vec.method_10215());
        }
        if (source.method_5810()) {
            source.method_5762(push_vec.method_10216(), 0.0, push_vec.method_10215());
        }
    }

    private Optional<class_243> calcDogPushVec(class_1297 source) {
        double dz_vec;
        if (this.method_5794(source)) {
            return Optional.empty();
        }
        if (source.field_5960 || this.field_5960) {
            return Optional.empty();
        }
        double dx_vec = source.method_23317() - this.method_23317();
        double max_magnitude = class_3532.method_15391((double)dx_vec, (double)(dz_vec = source.method_23321() - this.method_23321()));
        if (max_magnitude < 0.01) {
            return Optional.empty();
        }
        max_magnitude = Math.sqrt(max_magnitude);
        dx_vec /= max_magnitude;
        dz_vec /= max_magnitude;
        double max_magnitude_inv = 1.0 / max_magnitude;
        if (max_magnitude_inv > 1.0) {
            max_magnitude_inv = 1.0;
        }
        dx_vec *= max_magnitude_inv;
        dz_vec *= max_magnitude_inv;
        return Optional.of(new class_243(dx_vec *= 0.05, 0.0, dz_vec *= 0.05));
    }

    public boolean method_30949(class_1297 otherEntity) {
        if (this.dogPushAvoidManager.shouldBlockPush(otherEntity)) {
            return false;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return false;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(otherEntity)) {
            return false;
        }
        if (otherEntity.method_5854() == this || this.method_5854() == otherEntity) {
            return false;
        }
        return super.method_30949(otherEntity);
    }

    public class_7 getBlockPathTypeViaAlterations(class_2338 pos) {
        class_7 blockType = class_14.method_23476((class_1922)this.method_37908(), (class_2338.class_2339)pos.method_25503());
        blockType = this.inferType(blockType, InferTypeContext.getDefault());
        return blockType;
    }

    public class_7 inferType(class_7 type, InferTypeContext context) {
        if (this.method_5753()) {
            if (type == class_7.field_9) {
                return class_7.field_12;
            }
            if (type == class_7.field_14) {
                return class_7.field_22;
            }
        }
        if (this.canSwimUnderwater() && this.alterationProps.canBreatheUnderwater() && type == class_7.field_18) {
            return class_7.field_12;
        }
        for (IDogAlteration alt : this.alterations) {
            class_1271<class_7> result = alt.inferType(this, type, context);
            if (!result.method_5467().method_23666()) continue;
            type = (class_7)result.method_5466();
            break;
        }
        return type;
    }

    public boolean canDogPassGate() {
        for (IDogAlteration alt : this.alterations) {
            if (!alt.canDogPassGate(this).method_23666()) continue;
            return true;
        }
        return false;
    }

    public float getTimeDogIsShaking() {
        return this.timeWolfIsShaking;
    }

    public float getUrgentSpeedModifier() {
        if (this.method_26825(class_5134.field_23719) <= 0.3) {
            return 1.5f;
        }
        return 1.0f;
    }

    public StatsTracker getStatTracker() {
        return this.statsTracker;
    }

    public DogGroupsManager getGroups() {
        return this.dogGroupsManager;
    }

    public void setAnim(DogAnimation animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation.getId());
    }

    @Override
    public DogAnimation getAnim() {
        return DogAnimation.byId((Integer)this.field_6011.method_12789(ANIMATION));
    }

    public DogAnimationManager.DogAnimDebugState getDogAnimDebugState() {
        return this.dogFabricHelper.getDogAnimDebugState();
    }

    public void setDogAnimDebugState(DogAnimationManager.DogAnimDebugState state) {
        if (state.isNone()) {
            state = DogAnimationManager.DogAnimDebugState.NONE;
        }
        this.dogFabricHelper.setDogAnimDebugState(state);
    }

    public boolean isDogInAnimDebug() {
        return !this.getDogAnimDebugState().isNone();
    }

    public void setAnimSyncTime(int val) {
        this.field_6011.method_12778(ANIM_SYNC_TIME, (Object)val);
    }

    public int getAnimSyncTime() {
        return (Integer)this.field_6011.method_12789(ANIM_SYNC_TIME);
    }

    public void triggerAnimationAction(AnimationAction action) {
        if (this.animAction != null) {
            this.animAction.stop();
        }
        this.animAction = action;
        if (this.animAction != null) {
            this.method_5942().method_6340();
            this.method_20417();
            this.forceStopAllGoalWithFlag(class_1352.class_4134.field_18405);
            this.forceStopAllGoalWithFlag(class_1352.class_4134.field_18406);
            this.animAction.start();
        }
    }

    private void forceStopAllGoalWithFlag(class_1352.class_4134 flag) {
        this.dogAi.forceStopAllGoalWithFlag(flag);
    }

    protected void tickAnimAction() {
        if (this.animAction == null) {
            return;
        }
        switch (this.animAction.getState()) {
            case FINISHED: {
                this.triggerAnimationAction(null);
                break;
            }
            default: {
                this.animAction.tick();
            }
        }
    }

    public DogPose getDogPose() {
        return this.activePose;
    }

    private void setDogPose(DogPose pose) {
        this.activePose = pose;
    }

    public void updateDogPose() {
        if (this.isDefeated() && !this.incapacitatedMananger.canMove()) {
            this.setDogPose(this.incapacitatedMananger.getPose());
            return;
        }
        if (this.isInDrunkPose()) {
            this.setDogPose(DogPose.REST_BELLY);
            return;
        }
        if (this.method_6172()) {
            RestingState restState = this.getDogRestingState();
            if (restState == RestingState.LYING) {
                this.setDogPose(DogPose.REST);
                return;
            }
            if (restState == RestingState.BELLY) {
                this.setDogPose(DogPose.REST_BELLY);
                return;
            }
            this.setDogPose(this.isLying() ? DogPose.LYING_2 : DogPose.SIT);
            return;
        }
        if (this.isDogFlying() && !this.forcedWhenNoneAnim()) {
            this.setDogPose(DogPose.FLYING);
            return;
        }
        this.setDogPose(DogPose.STAND);
    }

    @Override
    public float getClientAnimatedYBodyRotInRadians() {
        if (!this.method_37908().field_9236) {
            return this.field_6283 * ((float)Math.PI / 180);
        }
        return this.field_6283 * ((float)Math.PI / 180) + ClientEventHandler.getAnimatedYRot(this);
    }

    public DogSkin getClientSkin() {
        if (((Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_CLASSICAL.get()).booleanValue()) {
            return DogSkin.CLASSICAL;
        }
        return this.clientSkin;
    }

    @Override
    public boolean isDogVariantRenderEffective() {
        DogSkin skin = this.getClientSkin();
        return skin == null || !skin.isCustom();
    }

    public void setClientSkin(DogSkin skin) {
        this.clientSkin = skin == null ? DogSkin.CLASSICAL : skin;
    }

    public List<AccessoryInstance> getClientSortedAccessories() {
        return this.clientAccessories;
    }

    public Optional<class_1799> getMouthItemForRender() {
        if (this.hasBone()) {
            class_1799 customStack;
            class_1799 renderStack = this.getBoneVariant();
            IThrowableItem throwableItem = this.getThrowableItem();
            if (throwableItem != null && (customStack = throwableItem.getCustomRenderStack(renderStack)) != null) {
                renderStack = customStack;
            }
            return Optional.of(renderStack);
        }
        class_1799 stack = this.method_6047();
        if (stack != null && !stack.method_7960()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public class_243 calcDogViewVec(float xrot, float yrot) {
        return this.method_5631(xrot, yrot);
    }

    public DogFabricHelper getDogFabricHelper() {
        return this.dogFabricHelper;
    }

    public void onFabricDataUpdated(SyncTypes.SyncType<?> type) {
        if (type == SyncTypes.ARTIFACTS) {
            this.refreshAlterations();
        }
        if (type == SyncTypes.DOG_PETTING_STATE && this.method_37908().field_9236) {
            DTNClientPettingManager.get().onPettingUpdate(this, this.getPettingState());
        }
        if (type == SyncTypes.DOG_VARIANT) {
            this.refreshAlterations();
        }
        if (type == SyncTypes.DOG_LEVEL) {
            this.spendablePoints.markForRefresh();
            float h = this.getDogLevel().getMaxHealth();
            if (h != this.method_6063()) {
                this.method_5996(class_5134.field_23716).method_6192((double)h);
            }
        }
        if (type == SyncTypes.DOG_SIZE) {
            this.method_18382();
        }
        if (this.method_37908().field_9236 && type == SyncTypes.DOG_SKIN) {
            this.setClientSkin(DogTextureManager.INSTANCE.getDogSkin(this.getSkinData().getHash()));
        }
        if (!this.method_37908().field_9236 && type == SyncTypes.DOG_MODE) {
            DogMode mode = this.getMode();
            this.incapacitatedMananger.onModeUpdate(mode);
            if (mode == DogMode.INJURED) {
                this.hungerManager.onBeingIncapacitated();
            }
            this.updateWanderState(mode);
        }
        if (type == SyncTypes.DOG_ANIM_DEBUG_STATE) {
            DogAnimationManager.DogAnimDebugState debug_state = this.getDogAnimDebugState();
            if (!debug_state.isNone() && !this.method_37908().field_9236) {
                this.dogAi.forceStopAllGoal();
            }
            this.animationManager.onDebugUpdate(debug_state);
        }
        if (type == SyncTypes.DOG_SLEEP_ON_STATE) {
            DogSleepOnManager.onDogSleepOnDataUpdated(this, this.getSleepOnState());
        }
    }

    public boolean isAddedToWorld() {
        return this.isAddedToWorld;
    }

    public void setAddedToWorld(boolean val) {
        this.isAddedToWorld = val;
    }

    public Optional<class_6862<class_3611>> getMaxFluidHeight() {
        return this.field_5964.object2DoubleEntrySet().stream().max(Comparator.comparingDouble(Object2DoubleMap.Entry::getDoubleValue)).map(Map.Entry::getKey);
    }

    protected class_5454 method_30329(class_3218 serverLevel) {
        class_1309 owner = this.method_35057();
        this.field_5991 = owner != null ? owner.method_24515() : class_2338.field_10980;
        double tpScale = class_2874.method_31109((class_2874)this.method_37908().method_8597(), (class_2874)serverLevel.method_8597());
        class_2338 destPos = serverLevel.method_8621().method_39538(this.method_23317() * tpScale, this.method_23318(), this.method_23321() * tpScale);
        return new class_5454(class_243.method_24955((class_2382)destPos), this.method_18798(), this.method_36454(), this.method_36455());
    }

    public static enum LowHealthStrategy {
        NONE(0),
        RUN_AWAY(1),
        STICK_TO_OWNER(2);

        public static final LowHealthStrategy[] VALUES;
        private final byte id;

        private LowHealthStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.low_health_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.low_health_strategy." + this.getId() + ".help";
        }

        public static LowHealthStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public LowHealthStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public LowHealthStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (LowHealthStrategy[])Arrays.stream(LowHealthStrategy.values()).sorted(Comparator.comparingInt(LowHealthStrategy::getId)).toArray(LowHealthStrategy[]::new);
        }
    }

    public static enum CombatReturnStrategy {
        STANDARD(0),
        FAR(1),
        NONE(2);

        public static final CombatReturnStrategy[] VALUES;
        private final byte id;

        private CombatReturnStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.combat_return_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.combat_return_strategy." + this.getId() + ".help";
        }

        public static CombatReturnStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public CombatReturnStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public CombatReturnStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (CombatReturnStrategy[])Arrays.stream(CombatReturnStrategy.values()).sorted(Comparator.comparingInt(CombatReturnStrategy::getId)).toArray(CombatReturnStrategy[]::new);
        }
    }

    public static enum RestingState {
        NONE,
        LYING,
        BELLY;

    }
}

