/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_270;

public class DogAllyCheck {
    public static boolean isAlliedToDog(Dog dog, class_1297 entity) {
        return DogAllyCheck.isAlliedToDog(dog, entity, dog.method_35057());
    }

    public static boolean isAlliedToDog(Dog dog, class_1297 entity, @Nullable class_1309 owner) {
        boolean ally_check;
        if (dog == null || entity == null) {
            return false;
        }
        if (entity == dog) {
            return true;
        }
        UUID owner_uuid = dog.method_6139();
        if (owner_uuid == null) {
            return false;
        }
        boolean bl = ally_check = owner != null ? DogAllyCheck.checkOwnerAvailable(dog, entity, owner_uuid, owner) : DogAllyCheck.checkOwnerNotAvailable(dog, entity, owner_uuid);
        if (ally_check) {
            return true;
        }
        boolean all_player_ally_to_dog = DogAllyCheck.checkAllPlayerCannotHitDog(dog, entity);
        return all_player_ally_to_dog;
    }

    private static boolean checkOwnerAvailable(Dog dog, class_1297 entity, UUID owner_uuid, class_1309 owner) {
        if (entity == owner) {
            return true;
        }
        if (owner.method_5722(entity)) {
            return true;
        }
        if (entity instanceof class_1321) {
            class_1321 other_dog = (class_1321)entity;
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            class_1309 owner_other = other_dog.method_35057();
            if (owner_other != null) {
                return owner.method_5722((class_1297)owner_other);
            }
            if (entity instanceof Dog) {
                Dog other_dog_actual = (Dog)entity;
                return DogAllyCheck.checkSameTeamWithOfflineOwner(other_dog_actual, (class_1297)owner);
            }
            return false;
        }
        return false;
    }

    private static boolean checkOwnerNotAvailable(Dog dog, class_1297 entity, UUID owner_uuid) {
        if (entity instanceof class_1321) {
            class_1321 other_dog = (class_1321)entity;
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            class_1309 owner_other = other_dog.method_35057();
            return owner_other != null && DogAllyCheck.checkSameTeamWithOfflineOwner(dog, (class_1297)owner_other);
        }
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, entity);
    }

    private static boolean checkSameTeamWithOfflineOwner(Dog dog, class_1297 entity) {
        Optional<class_2561> owner_name_optional = dog.getOwnersName();
        if (!owner_name_optional.isPresent()) {
            return false;
        }
        String owner_name = owner_name_optional.get().getString();
        if (owner_name == null || owner_name.isEmpty()) {
            return false;
        }
        class_270 team = entity.method_5781();
        if (team == null) {
            return false;
        }
        return team.method_1204().contains(owner_name);
    }

    private static boolean checkSameOwnerUUIDWithDog(UUID dog_owner_uuid, class_1321 entity) {
        UUID other_owner_uuid = entity.method_6139();
        if (other_owner_uuid == null) {
            return false;
        }
        return dog_owner_uuid.equals(other_owner_uuid);
    }

    private static boolean checkAllPlayerCannotHitDog(Dog dog, class_1297 entity) {
        if (!((Boolean)ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG.get()).booleanValue()) {
            return false;
        }
        if (entity instanceof class_1657) {
            return true;
        }
        if (entity instanceof class_1321) {
            class_1321 other_dog = (class_1321)entity;
            return other_dog.method_6139() != null;
        }
        return false;
    }
}

