/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import net.minecraft.class_1309;

public class DogAttackManager {
    private final Dog dog;
    public boolean attacking = false;
    private int tacticalTimeout = 10;
    private boolean hasTaticalTarget = false;
    private boolean isDogFarChasingTarget = false;

    public DogAttackManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        this.invalidateTacticalTarget();
    }

    private void invalidateTacticalTarget() {
        if (!this.hasTaticalTarget) {
            return;
        }
        class_1309 target = this.dog.method_5968();
        if (target == null) {
            this.hasTaticalTarget = false;
            return;
        }
        if (!target.method_5805()) {
            this.dog.method_5980(null);
            this.hasTaticalTarget = false;
            return;
        }
        if (!this.attacking) {
            if (this.tacticalTimeout <= 0) {
                this.dog.method_5980(null);
                this.hasTaticalTarget = false;
                return;
            }
            --this.tacticalTimeout;
        }
    }

    public boolean hasTaticalTarget() {
        return this.hasTaticalTarget;
    }

    public boolean setDogTaticalTarget(class_1309 target) {
        if (target == null) {
            return false;
        }
        if (this.dog.getMode() != DogMode.TACTICAL) {
            return false;
        }
        this.dog.method_5980(target);
        this.tacticalTimeout = 10;
        this.hasTaticalTarget = true;
        return false;
    }

    public boolean isDogFarChasingTarget() {
        return this.isDogFarChasingTarget;
    }

    public void setDogFarChasingTarget(boolean val) {
        this.isDogFarChasingTarget = val;
    }

    public void onTargetChange() {
        this.hasTaticalTarget = false;
    }

    public int getStandardFollowRange() {
        return 16;
    }

    public int getFarFollowRange() {
        return 32;
    }
}

