/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5134;

public class DogGoBackToSitAfterFinishAction
extends class_1352 {
    private final Dog dog;
    private double oldRangeSense = 16.0;
    private static final double TEMP_HIGH_SENSE = 32.0;
    private Optional<Integer> lastPathCalcAt = Optional.empty();
    private int pathCalcDelay = 0;
    private boolean hasDelayCalc = false;
    private Optional<class_2338> delayedCalcTo = Optional.empty();

    public DogGoBackToSitAfterFinishAction(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        Optional<class_2338> sit_pos_optional = this.checkAndInvalidateSitPos();
        if (!sit_pos_optional.isPresent()) {
            return false;
        }
        return !this.dog.dogAi.getActiveAction().isPresent();
    }

    private Optional<class_2338> checkAndInvalidateSitPos() {
        Optional<class_2338> sit_pos_optional = this.dog.getDogSitOverridePos();
        if (!sit_pos_optional.isPresent()) {
            return Optional.empty();
        }
        class_2338 sit_pos = sit_pos_optional.get();
        int sit_timestamp = this.dog.getDogSitOverridePosTimestamp();
        int time_since_save = this.dog.field_6012 - sit_timestamp;
        if (time_since_save > 600) {
            this.dog.clearDogSitOverridePos();
            return Optional.empty();
        }
        double max_validated_dist = 20.0;
        if (this.dog.method_5707(class_243.method_24955((class_2382)sit_pos)) > 400.0) {
            this.dog.clearDogSitOverridePos();
            return Optional.empty();
        }
        return Optional.of(sit_pos);
    }

    public boolean method_6266() {
        return this.hasDelayCalc || !this.dog.method_5942().method_6357();
    }

    public void method_6269() {
        Optional<class_2338> sit_pos_optional;
        class_1324 attrib = this.dog.method_5996(class_5134.field_23717);
        if (attrib != null) {
            this.oldRangeSense = attrib.method_6194();
            attrib.method_6192(32.0);
        }
        if (!(sit_pos_optional = this.dog.getDogSitOverridePos()).isPresent()) {
            return;
        }
        class_2338 sit_pos = sit_pos_optional.get();
        if (!this.maySetCalcPathDelayed(sit_pos)) {
            this.calcPath(sit_pos);
        }
    }

    private boolean maySetCalcPathDelayed(class_2338 pos) {
        if (!this.lastPathCalcAt.isPresent()) {
            return false;
        }
        int time_since_last = this.dog.field_6012 - this.lastPathCalcAt.get();
        if (time_since_last > 20) {
            return false;
        }
        this.hasDelayCalc = true;
        this.delayedCalcTo = Optional.of(pos);
        this.pathCalcDelay = Math.max(0, 20 - time_since_last);
        return true;
    }

    public void method_6268() {
        if (!this.hasDelayCalc) {
            return;
        }
        if (this.pathCalcDelay > 0) {
            --this.pathCalcDelay;
        }
        if (this.pathCalcDelay <= 0) {
            this.hasDelayCalc = false;
            this.delayedCalcTo.ifPresent(x -> this.calcPath((class_2338)x));
        }
    }

    public void calcPath(class_2338 pos) {
        class_1408 nav = this.dog.method_5942();
        nav.method_6337((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 1.0);
        if (nav instanceof DogPathNavigation) {
            DogPathNavigation dog_nav = (DogPathNavigation)nav;
            dog_nav.setDogMoveInTargetNode();
        }
        this.lastPathCalcAt = Optional.of(this.dog.field_6012);
    }

    public void method_6270() {
        class_1324 attrib = this.dog.method_5996(class_5134.field_23717);
        if (attrib != null) {
            attrib.method_6192(this.oldRangeSense);
        }
        this.dog.method_24346(true);
        this.dog.clearDogSitOverridePos();
    }

    public boolean method_38846() {
        return true;
    }
}

