/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_5134;
import net.minecraft.class_7;

public class DogFetchAction
extends TriggerableAction {
    @Nonnull
    private final class_1542 fetchTarget;
    @Nonnull
    private final class_1309 owner;
    private final int MIN_DIST = 2;
    private final int MAX_DIST = 32;
    private boolean isBringingBack = false;
    private int tickTillPathRecalc = 1;
    private float oldWaterCost;
    private double oldRangeSense = 16.0;
    private boolean initFetch;

    public DogFetchAction(Dog dog, @Nonnull class_1309 owner, @Nonnull class_1542 fetchTarget) {
        super(dog, true, true);
        this.fetchTarget = fetchTarget;
        this.owner = owner;
    }

    @Override
    public void onStart() {
        if (this.dog.hasBone() || this.dog.getMode() != DogMode.DOCILE) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.tickTillPathRecalc = 3;
        this.isBringingBack = false;
        this.initFetch();
    }

    @Override
    public void tick() {
        if (!this.owner.method_5805() || this.owner.method_7325()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.isBringingBack) {
            if (!this.canFetchStack(this.fetchTarget)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.hasBone()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        } else if (!this.dog.hasBone()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (--this.tickTillPathRecalc < 0) {
            this.tickTillPathRecalc = 20;
        }
        if (!this.isBringingBack) {
            this.goGetFetchItem();
        } else if (this.bringBackFetchItem()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void onStop() {
        this.dropFetchItem();
        this.finishFetch();
    }

    private void initFetch() {
        this.tickTillPathRecalc = 1;
        this.oldWaterCost = this.dog.method_5944(class_7.field_18);
        this.dog.setDogFollowingSomeone(true);
        class_1324 attrib = this.dog.method_5996(class_5134.field_23717);
        if (attrib == null) {
            return;
        }
        this.oldRangeSense = attrib.method_6194();
        attrib.method_6192((double)this.MAX_DIST);
        this.initFetch = true;
    }

    private void finishFetch() {
        if (!this.initFetch) {
            return;
        }
        this.dog.method_5942().method_6340();
        this.dog.setDogFollowingSomeone(false);
        class_1324 attrib = this.dog.method_5996(class_5134.field_23717);
        if (attrib == null) {
            return;
        }
        attrib.method_6192(this.oldRangeSense);
    }

    private void goGetFetchItem() {
        this.dog.method_5988().method_6226((class_1297)this.fetchTarget, 10.0f, (float)this.dog.method_5978());
        if (this.tickTillPathRecalc <= 0) {
            this.dog.method_5942().method_6335((class_1297)this.fetchTarget, 1.0);
        }
        this.checkAndGetFetchItem();
    }

    private boolean bringBackFetchItem() {
        this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
        if (this.dog.method_5858((class_1297)this.owner) <= 4.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return true;
        }
        if (this.tickTillPathRecalc > 0) {
            return false;
        }
        this.dog.method_5942().method_6335((class_1297)this.owner, 1.0);
        return false;
    }

    private boolean checkAndGetFetchItem() {
        if (!this.dog.hasBone() && this.dog.method_5858((class_1297)this.fetchTarget) < (double)(this.MIN_DIST * this.MIN_DIST) && this.fetchTarget.method_5805() && !this.fetchTarget.method_6977()) {
            this.dog.setBoneVariant(this.fetchTarget.method_6983());
            this.fetchTarget.method_31472();
            this.isBringingBack = true;
            this.tickTillPathRecalc = 1;
            this.dog.method_5942().method_6340();
            return true;
        }
        return false;
    }

    private void dropFetchItem() {
        if (this.dog.hasBone()) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            class_1799 fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.method_5699(fetchItem, 0.0f);
            this.dog.setBoneVariant(class_1799.field_8037);
        }
    }

    private boolean canFetchStack(class_1542 e) {
        if (!e.method_5805() || e.method_5767()) {
            return false;
        }
        double follow_range = this.dog.method_26825(class_5134.field_23717);
        if (e.method_5858((class_1297)this.dog) > follow_range * follow_range) {
            return false;
        }
        return e.method_6983().method_7909() instanceof IThrowableItem;
    }
}

