/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class DogGreetOwnerAction
extends TriggerableAction {
    private class_1309 owner;
    private static final int GREET_TICK_PER_LEFT_DAY = 20;
    private static final int MAX_GREET_TIME = 400;
    private static final int MAY_CANCEL_GREET_TIME = 100;
    private static final int START_GREET_DISTANCE_SQR = 4;
    private static final int GREET_RADIUS = 1;
    private static final int JUMP_BASE_INTERVAL = 7;
    private static final int WHINE_BASE_INTERVAL = 50;
    private static final int HEART_CHANCE_WINDOW = 8;
    private static final float MSG_CHANCE = 0.75f;
    private int greetTime;
    private int tickTillPathRecalc;
    private class_2338 rbAroundOwner;
    private int tickTillWhine;
    private int tickTillJump;
    private boolean tellOwner;
    private boolean isDoingAnim = false;
    private final int greetStopTime;

    public DogGreetOwnerAction(Dog dog, @Nonnull class_1309 owner, long ownerLeftInterval) {
        super(dog, true, true);
        this.owner = owner;
        this.greetStopTime = this.calculateGreetTime(ownerLeftInterval);
    }

    private int calculateGreetTime(long ownerLeftInterval) {
        int a = class_3532.method_15375((float)(ownerLeftInterval / 24000L * 20L));
        return Math.min(a, 400);
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 0;
        this.greetTime = 0;
        this.tickTillWhine = this.dog.method_6051().method_43048(5) * 10;
        this.tellOwner = true;
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    @Override
    public void tick() {
        if (this.greetTime >= this.greetStopTime && !this.isDoingAnim) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.owner.method_5805() || this.owner.method_7325()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        double d0 = this.dog.method_5858((class_1297)this.owner);
        this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
        if (d0 > 4.0 && !this.isDoingAnim) {
            this.doGoToOwner();
        } else {
            this.tellOwner();
            this.doGreet();
        }
    }

    private void doGoToOwner() {
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 400.0, false, false, 400.0, this.dog.method_5850());
        }
    }

    private void tellOwner() {
        if (!this.tellOwner) {
            return;
        }
        this.tellOwner = false;
        float r = this.dog.method_6051().method_43057();
        if (r >= 0.75f) {
            return;
        }
        int MSG_COUNT = 5;
        float msg_id_step = 0.15f;
        int msg_id = class_3532.method_15375((float)(r / msg_id_step));
        msg_id = class_3532.method_15340((int)msg_id, (int)0, (int)4);
        this.owner.method_43496((class_2561)class_2561.method_43469((String)("dog.msg.greet_owner." + msg_id), (Object[])new Object[]{this.dog.method_5477().getString()}));
    }

    private void doGreet() {
        class_1937 class_19372;
        ++this.greetTime;
        if (this.isDoingAnim) {
            this.tickAnim();
        } else {
            this.jumpOrDoAnim();
        }
        if (!this.isDoingAnim) {
            this.runAround();
        }
        if (--this.tickTillWhine <= 0) {
            this.tickTillWhine = 50 + this.dog.method_6051().method_43048(3) * 20;
            class_3414 sound = this.dog.dogMood.getGreetWhine();
            this.dog.dogSoundManager.playInterruptible(sound, this.dog.method_6107(), this.dog.method_6017());
        }
        if (this.dog.method_6051().method_43048(8) == 0 && (class_19372 = this.dog.method_37908()) instanceof class_3218) {
            class_3218 sLevel = (class_3218)class_19372;
            sLevel.method_14199((class_2394)class_2398.field_11201, this.dog.method_23317(), this.dog.method_23318(), this.dog.method_23321(), 1, (double)this.dog.method_17681(), (double)0.8f, (double)this.dog.method_17681(), 0.1);
        }
    }

    private void runAround() {
        class_1408 n = this.dog.method_5942();
        if (n.method_6357() && this.dog.field_6012 % 2 != 0) {
            this.rbAroundOwner = this.getRandomPosAroundOwner(this.owner);
            n.method_6337((double)this.rbAroundOwner.method_10263(), (double)this.rbAroundOwner.method_10264(), (double)this.rbAroundOwner.method_10260(), 1.0);
        }
    }

    private void jumpOrDoAnim() {
        if (this.tickTillJump > 0) {
            --this.tickTillJump;
        }
        if (!this.canJump()) {
            return;
        }
        if (this.tickTillJump <= 0) {
            this.tickTillJump = 7;
            if (this.canDoAnimInsteadOfJump() && this.dog.method_6051().method_43057() <= 0.7f) {
                this.startDoingAnim();
            } else {
                this.dog.method_5993().method_6233();
            }
        }
    }

    private void startDoingAnim() {
        this.isDoingAnim = true;
        this.dog.method_5942().method_6340();
        this.dog.setAnim(DogAnimation.GREET);
    }

    private void tickAnim() {
        if (this.dog.getAnim() != DogAnimation.GREET) {
            this.isDoingAnim = false;
        }
    }

    private boolean canJump() {
        return this.dog.method_24828();
    }

    private boolean canDoAnimInsteadOfJump() {
        if (this.dog.method_5858((class_1297)this.owner) > 2.25) {
            return false;
        }
        double dy = this.owner.method_23320() - this.dog.method_23320();
        return !(dy < 0.3);
    }

    @Override
    public void onStop() {
        if (this.isStarted() && this.dog.getAnim() == DogAnimation.GREET) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.dogOwnerDistanceManager.onGreetingActionStop(this.owner);
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    @Override
    public boolean canPreventSit() {
        return this.greetTime < 100;
    }

    private class_2338 getRandomPosAroundOwner(class_1309 owner) {
        class_2338 owner_b0 = owner.method_24515();
        class_5819 r = owner.method_6051();
        int rX = r.method_39332(-1, 1);
        int rY = r.method_39332(-1, 1);
        int rZ = r.method_39332(-1, 1);
        return owner_b0.method_10069(rX, rY, rZ);
    }
}

