/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3414;

public class DogWantAttentionAction
extends TriggerableAction {
    private Phase phase = Phase.GO_TO_OWNER;
    @Nonnull
    private final class_1309 owner;
    private int goToOwnerTimeout;
    private int tickTillPathRecalc;
    private boolean whinedToAttention;
    private int tickAnim;
    private int stopTick;

    public DogWantAttentionAction(Dog dog, @Nonnull class_1309 owner) {
        super(dog, true, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 5;
        this.phase = Phase.GO_TO_OWNER;
        this.goToOwnerTimeout = 200;
        this.whinedToAttention = false;
        this.tickAnim = 0;
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    @Override
    public void tick() {
        if (this.phase == Phase.GO_TO_OWNER) {
            if (this.goToOwnerTimeout <= 0) {
                this.stopAndMaySitDown();
                return;
            }
        } else {
            if (this.dog.field_6012 >= this.stopTick) {
                this.stopAndMaySitDown();
                return;
            }
            if (this.dog.getAnim() != DogAnimation.PLAY_WITH_MEH) {
                this.stopAndMaySitDown();
                return;
            }
            if (this.dog.method_5858((class_1297)this.owner) > 16.0) {
                this.stopAndMaySitDown();
                return;
            }
        }
        if (this.phase == Phase.GO_TO_OWNER) {
            this.tickGoToOwner();
        } else {
            this.tickBegForAttention();
        }
    }

    private void stopAndMaySitDown() {
        this.setState(TriggerableAction.ActionState.FINISHED);
    }

    private void tickGoToOwner() {
        boolean closeEnough;
        this.dog.method_5988().method_35111((class_1297)this.owner);
        if (--this.goToOwnerTimeout <= 0) {
            this.goToOwnerTimeout = 0;
            return;
        }
        double d0 = this.dog.method_5858((class_1297)this.owner);
        boolean bl = closeEnough = d0 <= 2.25;
        if (--this.tickTillPathRecalc <= 0) {
            if (!closeEnough) {
                this.dog.method_5942().method_6335((class_1297)this.owner, 1.0);
            }
            this.tickTillPathRecalc = 20;
        }
        if (closeEnough) {
            if (!this.dog.method_5942().method_6357()) {
                this.dog.method_5942().method_6340();
            }
            if (!this.whinedToAttention) {
                this.whinedToAttention = true;
                class_3414 sound = this.dog.dogMood.getWhineAttentionSound();
                this.dog.dogSoundManager.playInterruptible(sound, this.dog.method_6107() + 0.2f, this.dog.method_6017());
                int r = this.dog.method_6051().method_43048(3);
                this.owner.method_43496((class_2561)class_2561.method_43469((String)("dog.msg.want_attention." + r), (Object[])new Object[]{this.dog.method_5477().getString()}));
            }
            this.checkAndSwitchToAttention();
        }
    }

    private void checkAndSwitchToAttention() {
        if (!DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
            return;
        }
        this.phase = Phase.BEG_FOR_ATTENTION;
        this.tickAnim = 0;
        this.stopTick = this.dog.field_6012 + DogAnimation.PLAY_WITH_MEH.getLengthTicks();
        this.dog.setAnim(DogAnimation.PLAY_WITH_MEH);
    }

    private void tickBegForAttention() {
        this.dog.method_5988().method_35111((class_1297)this.owner);
        ++this.tickAnim;
        if (this.tickAnim == 30) {
            class_3414 sound = this.dog.dogMood.getJealousSound();
            this.dog.method_5783(sound, this.dog.method_6107(), this.dog.method_6017());
        }
    }

    @Override
    public void onStop() {
        if (this.dog.getAnim() == DogAnimation.PLAY_WITH_MEH) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.dogSoundManager.interuptPlaying();
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    private static enum Phase {
        GO_TO_OWNER,
        BEG_FOR_ATTENTION;

    }
}

