/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAllyCheck;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_7923;

public class DogArrow
extends class_1665 {
    private static final int NULL_COLOR = -1;
    private PotionContents potionContents = PotionContents.EMPTY;
    private static final class_2940<Integer> EFFECT_COLOR = class_2945.method_12791(DogArrow.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_SPECTRAL = class_2945.method_12791(DogArrow.class, (class_2941)class_2943.field_13323);
    private Optional<UUID> dogOwnerUUID = Optional.empty();

    public DogArrow(class_1299<DogArrow> p_36858_, class_1937 p_36859_) {
        super(p_36858_, p_36859_);
    }

    public DogArrow(class_1937 p_36861_, AbstractDog dog, class_1799 stack) {
        super(DoggyEntityTypes.DOG_ARROW_PROJ.get(), (class_1309)dog, p_36861_);
        class_1309 owner;
        this.setEffectsFromItem_1_20_1_and_under(stack);
        this.updateColor();
        if (stack.method_31574(class_1802.field_8236)) {
            this.field_6011.method_12778(IS_SPECTRAL, (Object)true);
        }
        if ((owner = dog.method_35057()) != null) {
            this.dogOwnerUUID = Optional.ofNullable(owner.method_5667());
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(EFFECT_COLOR, (Object)-1);
        this.field_6011.method_12784(IS_SPECTRAL, (Object)false);
    }

    private PotionContents getPotionContents() {
        return this.potionContents;
    }

    private boolean hasPotionContents() {
        PotionContents data = this.getPotionContents();
        return data != PotionContents.EMPTY;
    }

    private void clearPotionContents() {
        this.potionContents = PotionContents.EMPTY;
    }

    private void updateColor() {
        int update_color = -1;
        if (this.hasPotionContents()) {
            update_color = this.getPotionContents().getColor();
        }
        this.field_6011.method_12778(EFFECT_COLOR, (Object)update_color);
    }

    public void method_5773() {
        super.method_5773();
        if (this.isDogSpectralArrow()) {
            this.updateSpectralArrow();
        } else if (this.method_37908().field_9236) {
            this.makeClientArrowParticle();
        } else {
            this.updateEffectTimeout();
        }
    }

    private void makeClientArrowParticle() {
        int color = this.getColor();
        if (this.field_7588) {
            if (this.field_7576 % 5 == 0) {
                this.makeParticle(1, color);
            }
        } else {
            this.makeParticle(2, color);
        }
    }

    private void updateEffectTimeout() {
        boolean effect_expired;
        boolean bl = effect_expired = this.field_7588 && this.field_7576 >= 600 && this.hasPotionContents();
        if (effect_expired) {
            this.clearPotionContents();
        }
    }

    private void updateSpectralArrow() {
        if (this.method_37908().field_9236 && !this.field_7588) {
            this.method_37908().method_8406((class_2394)class_2398.field_11213, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    private void makeParticle(int amount, int color) {
        if (color == -1 || amount <= 0) {
            return;
        }
        double r = (double)(color >> 16 & 0xFF) / 255.0;
        double g = (double)(color >> 8 & 0xFF) / 255.0;
        double b = (double)(color >> 0 & 0xFF) / 255.0;
        for (int i = 0; i < amount; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), r, g, b);
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(EFFECT_COLOR);
    }

    public boolean isDogSpectralArrow() {
        return (Boolean)this.field_6011.method_12789(IS_SPECTRAL);
    }

    protected void method_7450(class_1309 target) {
        super.method_7450(target);
        if (this.isDogSpectralArrow()) {
            this.doDogSpectralArrowEffectHurt(target);
        } else {
            this.doNormalDogArrowEffectHurt(target);
        }
        this.killCreeperIfCreeperSweeper(target);
    }

    private void doNormalDogArrowEffectHurt(class_1309 target) {
        class_1297 effect_source = this.method_37225();
        PotionContents potion_contents = this.getPotionContents();
        if (potion_contents.potion.isPresent()) {
            for (class_1293 effect_inst : potion_contents.potion.get().method_8049()) {
                target.method_37222(new class_1293(effect_inst.method_5579(), Math.max(effect_inst.method_48558(x -> x / 8), 1), effect_inst.method_5578(), effect_inst.method_5591(), effect_inst.method_5581()), effect_source);
            }
        }
        for (class_1293 custom_effect_inst : potion_contents.customEffects()) {
            target.method_37222(custom_effect_inst, effect_source);
        }
    }

    private void doDogSpectralArrowEffectHurt(class_1309 target) {
        class_1293 glow_inst = new class_1293(class_1294.field_5912, 200, 0);
        target.method_37222(glow_inst, this.method_37225());
    }

    private void killCreeperIfCreeperSweeper(class_1309 target) {
        class_1297 owner = this.method_24921();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel(DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof class_1548)) {
            return;
        }
        class_1548 creeper = (class_1548)target;
        creeper.method_6033(0.0f);
        creeper.method_6078(dog.method_48923().method_48812((class_1309)dog));
    }

    protected class_1799 method_7445() {
        return this.getPickupItem_1_20_1_under();
    }

    protected boolean method_26958(class_1297 target) {
        class_1309 living;
        if (target instanceof class_1309 && this.checkAlliesToDog(living = (class_1309)target)) {
            return false;
        }
        return super.method_26958(target);
    }

    private boolean checkAlliesToDog(class_1309 target) {
        class_1297 owner = this.method_24921();
        if (!(owner instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)owner;
        return DogAllyCheck.isAlliedToDog(dog, (class_1297)target);
    }

    protected boolean method_34713(class_1657 picker) {
        if (this.shouldDogArrowBlockPickup(picker)) {
            return false;
        }
        return super.method_34713(picker);
    }

    private boolean shouldDogArrowBlockPickup(class_1657 picker) {
        if (picker.method_7337()) {
            return false;
        }
        if (!this.dogOwnerUUID.isPresent()) {
            return false;
        }
        return !this.dogOwnerUUID.get().equals(picker.method_5667());
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.dogOwnerUUID.ifPresent(x -> tag.method_25927("dtn_dog_owner_id", x));
        this.add_1_20_under_PotionData(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_25928("dtn_dog_owner_id")) {
            UUID uuid = tag.method_25926("dtn_dog_owner_id");
            this.dogOwnerUUID = Optional.ofNullable(uuid);
        }
        this.read1_20_under_PotionData(tag);
    }

    public void setEffectsFromItem_1_20_1_and_under(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8087)) {
            class_1842 potion = class_1844.method_8063((class_1799)stack);
            List customEffectsList = class_1844.method_8068((class_1799)stack);
            HashSet<class_1293> customEffectSet = null;
            if (!customEffectsList.isEmpty()) {
                customEffectSet = new HashSet<class_1293>(customEffectsList.size());
                for (class_1293 effectInst : customEffectsList) {
                    customEffectSet.add(new class_1293(effectInst));
                }
            }
            this.potionContents = PotionContents.from(potion, customEffectSet);
        } else {
            this.potionContents = PotionContents.EMPTY;
        }
        this.updateColor();
    }

    private void read1_20_under_PotionData(class_2487 compound) {
        class_1842 potion = null;
        if (compound.method_10573("Potion", 8)) {
            potion = class_1844.method_8057((class_2487)compound);
        }
        HashSet<class_1293> custom_set = new HashSet<class_1293>();
        for (class_1293 mobeffectinstance : class_1844.method_8060((class_2487)compound)) {
            custom_set.add(mobeffectinstance);
        }
        this.potionContents = PotionContents.from(potion, custom_set);
        this.updateColor();
    }

    public void add_1_20_under_PotionData(class_2487 compound) {
        if (this.potionContents.potion.isPresent()) {
            class_1842 potion = this.potionContents.potion.get();
            compound.method_10582("Potion", class_7923.field_41179.method_10221((Object)potion).toString());
        }
        if (this.potionContents.customEffects.isPresent()) {
            Set<class_1293> customEffects = this.potionContents.customEffects.get();
            class_2499 listtag = new class_2499();
            for (class_1293 mobeffectinstance : customEffects) {
                listtag.add((Object)mobeffectinstance.method_5582(new class_2487()));
            }
            compound.method_10566("CustomPotionEffects", (class_2520)listtag);
        }
    }

    private class_1799 getPickupItem_1_20_1_under() {
        if (this.potionContents == PotionContents.EMPTY) {
            return new class_1799((class_1935)class_1802.field_8107);
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8087);
        this.potionContents.potion.ifPresent(x -> class_1844.method_8061((class_1799)stack, (class_1842)x));
        this.potionContents.customEffects.ifPresent(x -> class_1844.method_8056((class_1799)stack, (Collection)x));
        return stack;
    }

    private static class PotionContents {
        public final Optional<class_1842> potion;
        public final Optional<Set<class_1293>> customEffects;
        public final int color;
        public static PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty());

        private PotionContents(Optional<class_1842> potion, Optional<Set<class_1293>> customEffects) {
            this.potion = potion;
            this.customEffects = customEffects;
            this.color = this.initColor();
        }

        public static PotionContents from(class_1842 potion, Set<class_1293> custom) {
            boolean empty_condition;
            boolean bl = empty_condition = !(potion != null && potion != class_1847.field_8984 || custom != null && !custom.isEmpty());
            if (empty_condition) {
                return EMPTY;
            }
            if (potion == null) {
                potion = class_1847.field_8984;
            }
            if (custom == null) {
                custom = Set.of();
            }
            return new PotionContents(Optional.of(potion), Optional.of(custom));
        }

        public int initColor() {
            if (!this.potion.isPresent() && !this.customEffects.isPresent()) {
                return -1;
            }
            return class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion.get(), (Collection)this.customEffects.get()));
        }

        public int getColor() {
            return this.color;
        }

        public Set<class_1293> customEffects() {
            return this.customEffects.orElse(Set.of());
        }
    }
}

