/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.screen.DogAnimDebugScreen;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3532;

public class DogAnimDebugItem
extends class_1792
implements IDogItem {
    public static final String SELECT_ANIM_ID = "dtn_selected_id";
    public static final String ITEM_MODE_ID = "dtn_item_mode";

    public DogAnimDebugItem(class_1792.class_1793 p_41383_) {
        super(p_41383_.method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (level.field_9236) {
            DogAnimDebugScreen.open(player);
        }
        return class_1271.method_22427((Object)stack);
    }

    @Override
    public class_1269 processInteract(AbstractDog dogIn, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (!dogIn.method_37908().field_9236) {
            this.useActionOnDog(dogIn, playerIn);
        }
        return class_1269.field_5812;
    }

    private void useActionOnDog(AbstractDog dogIn, class_1657 player) {
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (!player.method_5687(4)) {
            return;
        }
        if (!player.method_7337()) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7909() != this) {
            return;
        }
        ItemMode item_mode = DogAnimDebugItem.getItemMode(stack);
        DogAnimationManager anim_manager = dog.animationManager;
        switch (item_mode) {
            case ANIM: {
                if (player.method_5715()) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.NONE);
                    return;
                }
                DogAnimation anim = DogAnimDebugItem.getSelectedAnimation(stack);
                if (anim.isNone()) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.NONE);
                    return;
                }
                DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
                if (debug_state.anim() != anim) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.of(anim, 0, 0.0f));
                    dog.setAnim(anim);
                    return;
                }
                if (dog.getAnim().isNone()) {
                    dog.setAnim(anim);
                } else {
                    anim_manager.setDogAnimDebugState(dog.animationManager.getFreezeDebugState(anim));
                    dog.setAnim(DogAnimation.NONE);
                }
                return;
            }
            case TIME_SET: {
                if (!dog.isDogInAnimDebug()) {
                    return;
                }
                DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
                DogAnimation anim = debug_state.anim();
                if (anim.isNone()) {
                    return;
                }
                int new_timestamp = debug_state.timestamp() + (player.method_5715() ? -1 : 1);
                new_timestamp = class_3532.method_15340((int)new_timestamp, (int)0, (int)anim.getLengthTicks());
                anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.of(anim, new_timestamp, debug_state.yRot()));
                return;
            }
            case YROT: {
                anim_manager.setDebugFreezeYRot(player.field_6241);
                return;
            }
        }
    }

    public boolean method_7886(class_1799 p_41453_) {
        return true;
    }

    public static DogAnimation getSelectedAnimation(class_1799 stack) {
        class_2487 tag = ItemUtil.getTag(stack);
        if (!tag.method_10573(SELECT_ANIM_ID, 3)) {
            return DogAnimation.NONE;
        }
        int anim_id = tag.method_10550(SELECT_ANIM_ID);
        DogAnimation anim = DogAnimation.byId(anim_id);
        return anim;
    }

    public static ItemMode getItemMode(class_1799 stack) {
        class_2487 tag = ItemUtil.getTag(stack);
        if (!tag.method_10573(ITEM_MODE_ID, 3)) {
            return ItemMode.ANIM;
        }
        int mode_id = tag.method_10550(ITEM_MODE_ID);
        ItemMode mode = ItemMode.fromId(mode_id);
        return mode;
    }

    public static void editDebugAnimStack(class_1799 stack, @Nullable DogAnimation selected, @Nullable ItemMode mode) {
        if (stack.method_7909() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        class_2487 tag = ItemUtil.getTag(stack);
        if (selected != null) {
            tag.method_10569(SELECT_ANIM_ID, selected.getId());
        }
        if (mode != null) {
            tag.method_10569(ITEM_MODE_ID, mode.getId());
        }
        ItemUtil.putTag(stack, tag);
    }

    public void method_7851(class_1799 stack, class_1937 context, List<class_2561> components, class_1836 flags) {
        String desc_id = "item.doggytalents.dog_anim_debug_stick.help";
        components.add((class_2561)class_2561.method_43471((String)desc_id).method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
    }

    public static enum ItemMode {
        ANIM(0),
        TIME_SET(1),
        YROT(2);

        private final int id;

        private ItemMode(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ItemMode fromId(int id) {
            ItemMode[] values = ItemMode.values();
            if (id < 0 || id >= values.length) {
                return ANIM;
            }
            return values[id];
        }

        public ItemMode cycleMode() {
            ItemMode[] modes = ItemMode.values();
            int current_id = this.getId();
            int new_id = current_id + 1;
            if (new_id >= modes.length) {
                new_id = 0;
            }
            ItemMode new_mode = ItemMode.fromId(new_id);
            return new_mode;
        }
    }
}

