/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.item.IDyeableArmorItem;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5250;

public class DogPlushieItem
extends class_1792
implements IDyeableArmorItem,
IDogItem {
    public DogPlushieItem(class_1792.class_1793 itemProps) {
        super(itemProps.method_7889(1));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.field_9236 || !(level instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        class_2338 pos = context.method_8037();
        class_2350 face = context.method_8038();
        class_2680 state = level.method_8320(pos);
        class_2338 spawnAt = state.method_26220((class_1922)level, pos).method_1110() ? pos : pos.method_10093(face);
        DogPlushie plush = (DogPlushie)DoggyEntityTypes.DOG_PLUSHIE_TOY.get().method_5888((class_3218)level, null, null, spawnAt, class_3730.field_16461, !Objects.equals(pos, spawnAt) && face == class_2350.field_11036, false);
        if (plush != null) {
            plush.method_36456(face.method_10153().method_10144());
            int color = this.method_7800(stack);
            plush.setCollarColor(color);
            DogVariant variant = DogPlushieItem.getDogVariant(stack);
            plush.setDogVariant(variant);
            boolean collar_thicc = DogPlushieItem.getCollarThicc(stack);
            plush.setCollarThicc(collar_thicc);
            level.method_8649((class_1297)plush);
        }
        if (player != null && !player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        if (player != null) {
            player.method_7357().method_7906((class_1792)this, 20);
        }
        return class_1269.field_5812;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> components, class_1836 flags) {
        boolean is_thicc_collar;
        String desc_id = "item.doggytalents.dog_plushie_toy_item.description";
        components.add((class_2561)class_2561.method_43471((String)desc_id).method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        DogVariant variant = DogPlushieItem.getDogVariant(stack);
        if (variant != DogVariantUtil.getDefault()) {
            String variant_str = class_2561.method_43471((String)"doggui.classical.variant").getString() + " " + ClientEventHandler.getTranslatedVariantStr(variant);
            class_5250 variant_c1 = class_2561.method_43470((String)variant_str).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(variant.guiColor()));
            components.add((class_2561)variant_c1);
        }
        if (is_thicc_collar = DogPlushieItem.getCollarThicc(stack)) {
            components.add((class_2561)class_2561.method_43471((String)DoggyItems.WOOL_COLLAR_THICC.get().method_7876()).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        }
    }

    @Override
    public int getDefaultColor(class_1799 stack) {
        return 11546150;
    }

    public static void setDogVariant(class_1799 stack, DogVariant variant) {
        if (stack.method_7909() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return;
        }
        class_2487 tag = ItemUtil.getTag(stack);
        tag.method_10582("dogVariant", DogVariantUtil.toSaveString(variant));
        ItemUtil.putTag(stack, tag);
    }

    public static DogVariant getDogVariant(class_1799 stack) {
        if (stack.method_7909() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return DogVariantUtil.getDefault();
        }
        class_2487 tag = ItemUtil.getTag(stack);
        if (!tag.method_10573("dogVariant", 8)) {
            return DogVariantUtil.getDefault();
        }
        String variant_str = tag.method_10558("dogVariant");
        return DogVariantUtil.fromSaveString(variant_str);
    }

    public static void setCollarThicc(class_1799 stack, boolean val) {
        if (stack.method_7909() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return;
        }
        class_2487 tag = ItemUtil.getTag(stack);
        tag.method_10556("collarThicc", val);
        ItemUtil.putTag(stack, tag);
    }

    public static boolean getCollarThicc(class_1799 stack) {
        if (stack.method_7909() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return false;
        }
        class_2487 tag = ItemUtil.getTag(stack);
        return tag.method_10577("collarThicc");
    }

    @Override
    public class_1269 processInteract(AbstractDog dogIn, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (!(dogIn instanceof Dog)) {
            return class_1269.field_5811;
        }
        Dog dog = (Dog)dogIn;
        class_1799 stack = playerIn.method_5998(handIn);
        if (this.copyDogToStack(dog, stack, playerIn.method_5715())) {
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private boolean copyDogToStack(Dog dog, class_1799 stack, boolean copy_color) {
        boolean collar_thicc_stack;
        boolean collar_thicc_dog;
        DogVariant variant_stack;
        boolean changed = false;
        DogVariant variant_dog = dog.dogVariant();
        if (variant_dog != (variant_stack = DogPlushieItem.getDogVariant(stack))) {
            if (!dog.method_37908().field_9236) {
                DogPlushieItem.setDogVariant(stack, variant_dog);
            }
            changed = true;
        }
        if ((collar_thicc_dog = dog.getAccessory(DoggyAccessories.DYEABLE_COLLAR_THICC.get()).isPresent()) != (collar_thicc_stack = DogPlushieItem.getCollarThicc(stack))) {
            if (!dog.method_37908().field_9236) {
                DogPlushieItem.setCollarThicc(stack, collar_thicc_dog);
            }
            changed = true;
        }
        if (copy_color && this.copyCollarColor(dog, stack)) {
            return true;
        }
        return changed;
    }

    private boolean copyCollarColor(Dog dog, class_1799 stack) {
        int collar_color_stack = ItemUtil.getDyeColorForStack(stack);
        int collar_color_dog = dog.getAccessory(DoggyAccessoryTypes.COLLAR.get()).filter(x -> x instanceof DyeableAccessory.DyeableAccessoryInstance).map(x -> ((DyeableAccessory.DyeableAccessoryInstance)x).getColorInteger()).orElse(this.getDefaultColor(stack));
        if (collar_color_dog == collar_color_stack) {
            return false;
        }
        ItemUtil.setDyeColorForStack(stack, collar_color_dog);
        return true;
    }
}

