/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.AllStandSwitchModeScreen;
import doggytalents.client.screen.CarryMeScreen;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.client.screen.HeelByNameScreen;
import doggytalents.client.screen.WhistleScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGoBehindOwnerAction;
import doggytalents.common.entity.ai.triggerable.DogHowlAction;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.entity.misc.DoggyBeamEntity;
import doggytalents.common.talent.BedDogTalent;
import doggytalents.common.talent.MobRetrieverTalent;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5321;

public class WhistleItem
extends class_1792
implements IDogItem {
    public WhistleItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 processInteract(AbstractDog dogIn, class_1937 worldIn, class_1657 player, class_1268 hand) {
        WhistleMode mode;
        class_1799 stack = player.method_5998(hand);
        int id_mode = 0;
        if (stack.method_7985() && stack.method_7969().method_10573("mode", 99)) {
            id_mode = stack.method_7969().method_10571("mode");
        }
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        return (mode = WhistleMode.VALUES[id_mode]) == WhistleMode.MOB_RETRIEVER || mode == WhistleMode.RIDE_WITH_ME || mode == WhistleMode.HOWL || mode == WhistleMode.BED_DOG_WHISTLE ? class_1269.field_5814 : class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (world.field_9236) {
                WhistleScreen.open(stack);
            }
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        byte id_mode = 0;
        boolean on_duty_only = false;
        if (stack.method_7985() && stack.method_7969().method_10573("mode", 99)) {
            id_mode = stack.method_7969().method_10571("mode");
        }
        if (stack.method_7985()) {
            on_duty_only = stack.method_7969().method_10577("dog_on_duty_only");
        }
        List dogsList = world.method_8390(Dog.class, player.method_5829().method_1009(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.method_6171((class_1309)player));
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        WhistleMode mode = WhistleMode.VALUES[id_mode];
        this.useMode(mode, on_duty_only, dogsList, world, player, hand, false);
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    public void useMode(WhistleMode mode, boolean dogOnDutyOnly, List<Dog> dogsList, class_1937 world, class_1657 player, class_1268 hand, boolean isKeyBind) {
        if (mode == null) {
            return;
        }
        switch (mode.getSound()) {
            case NONE: {
                break;
            }
            case LONG: {
                world.method_8396(null, player.method_24515(), DoggySounds.WHISTLE_LONG.get(), class_3419.field_15248, 0.6f + world.field_9229.method_43057() * 0.1f, 0.8f + world.field_9229.method_43057() * 0.2f);
                break;
            }
            case SHORT: {
                world.method_8396(null, player.method_24515(), DoggySounds.WHISTLE_SHORT.get(), class_3419.field_15248, 0.6f + world.field_9229.method_43057() * 0.1f, 0.8f + world.field_9229.method_43057() * 0.2f);
            }
        }
        boolean successful = false;
        switch (mode) {
            case STAND: {
                if (world.field_9236) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.method_24346(false);
                    dog.method_5942().method_6340();
                    dog.method_5980(null);
                    successful = true;
                }
                if (successful) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.come"));
                }
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HEEL: {
                if (world.field_9236) {
                    return;
                }
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                List<Dog> heel_list = dogsList.stream().filter(filter_dog -> {
                    if (dogOnDutyOnly && !filter_dog.dogOnDuty()) {
                        return false;
                    }
                    if (filter_dog.method_24345()) {
                        return false;
                    }
                    if (!filter_dog.getMode().shouldFollowOwner()) {
                        return false;
                    }
                    return filter_dog.method_5858((class_1297)filter_dog.method_35057()) > 9.0;
                }).collect(Collectors.toList());
                if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
                    Collections.sort(heel_list, new EntityUtil.Sorter((class_1297)player));
                    heel_list = heel_list.subList(0, max_heel_count);
                }
                if (heel_list.isEmpty()) {
                    return;
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(world, heel_list, (class_1309)player, 3);
                player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.heel"));
                return;
            }
            case STAY: {
                if (world.field_9236) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.method_24346(true);
                    dog.method_5942().method_6340();
                    dog.method_5980(null);
                    successful = true;
                }
                if (successful) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.stay"));
                }
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case STOP_ATTACKING: {
                if (world.field_9236) {
                    return;
                }
                for (Dog dog : dogsList) {
                    successful = true;
                    dog.method_5980(null);
                }
                if (successful) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.stop_attacking"));
                }
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case SHELPERD: {
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case TACTICAL: {
                if (world.field_9236) {
                    return;
                }
                DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (class_1309)player);
                doggyBeam.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 2.0f, 1.0f);
                world.method_8649((class_1297)doggyBeam);
                player.method_7357().method_7906((class_1792)this, 10);
                return;
            }
            case ROAR: {
                Optional<Integer> cooldown_optional = RoaringGaleTalent.roar(dogsList, world, player);
                cooldown_optional.ifPresent(x -> player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), x.intValue()));
                return;
            }
            case HEEL_BY_NAME: {
                if (world.field_9236) {
                    HeelByNameScreen.open(isKeyBind ? 200 : 0);
                }
                return;
            }
            case TO_BED: {
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                if (dogsList.isEmpty()) {
                    return;
                }
                if (player.method_37908().field_9236) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    class_2338 bedPos;
                    noDogs = false;
                    if (!dog.readyForNonTrivialAction() || (bedPos = (class_2338)dog.getBedPos((class_5321<class_1937>)player.method_37908().method_27983()).orElse(null)) == null || dog.method_24515().equals((Object)bedPos) && dog.method_6172() || !(dog.method_5707(class_243.method_24955((class_2382)bedPos)) < 400.0)) continue;
                    dog.triggerActionDelayed(2, new DogMoveToBedAction(dog, bedPos, false));
                }
                return;
            }
            case GO_BEHIND: {
                if (player.method_37908().field_9236) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    class_1309 owner;
                    if (dogOnDutyOnly && !dog.dogOnDuty() || !dog.getMode().shouldFollowOwner() || dog.method_24345() || (owner = dog.method_35057()) == null || dog.method_5858((class_1297)owner) > 400.0) continue;
                    dog.method_5980(null);
                    dog.clearTriggerableAction();
                    dog.triggerAction(new DogGoBehindOwnerAction(dog, owner));
                    noDogs = false;
                }
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HEEL_BY_GROUP: {
                if (world.field_9236) {
                    HeelByGroupScreen.open();
                }
                return;
            }
            case MOB_RETRIEVER: {
                class_238 search_area;
                class_243 view_vec;
                class_243 max_reach_vec;
                class_243 max_pos;
                if (world.field_9236) {
                    return;
                }
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                Optional<Dog> retrieverOptional = MobRetrieverTalent.chooseNearestDog(player, world);
                if (retrieverOptional.isEmpty()) {
                    return;
                }
                Dog retriever = retrieverOptional.get();
                Optional<TalentInstance> talentOptional = retriever.getTalent(DoggyTalents.MOB_RETRIEVER.get());
                if (talentOptional.isEmpty()) {
                    return;
                }
                MobRetrieverTalent talentInst = (MobRetrieverTalent)talentOptional.get();
                int reach_range = MobRetrieverTalent.getSelectTargetRange();
                class_243 eye_pos = player.method_33571();
                class_3966 hitResult = class_1675.method_18075((class_1297)player, (class_243)eye_pos, (class_243)(max_pos = eye_pos.method_1019(max_reach_vec = (view_vec = player.method_5828(1.0f)).method_1021((double)reach_range))), (class_238)(search_area = player.method_5829().method_18804(max_reach_vec).method_1009(1.0, 1.0, 1.0)), e -> {
                    if (!(e instanceof class_1309)) {
                        return false;
                    }
                    class_1309 living = (class_1309)e;
                    return talentInst.isValidTarget(retriever, living);
                }, (double)(reach_range * reach_range));
                if (hitResult == null) {
                    return;
                }
                class_1297 entity = hitResult.method_17782();
                if (entity == null) {
                    return;
                }
                talentInst.setTarget(retriever, (class_1309)entity);
                return;
            }
            case HEEL_BY_LOOK: {
                this.heelByLook(world, player);
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case RIDE_WITH_ME: {
                this.rideWithMe(world, player);
                player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HOWL: {
                this.howl(world, player);
                return;
            }
            case ALL_STAND_SWITCH_MODE: {
                if (world.field_9236) {
                    AllStandSwitchModeScreen.open(player);
                }
                return;
            }
            case SSSSSHHHH: {
                this.sssshhhh(world, player, dogsList);
                return;
            }
            case CROSS_ORIGIN_TP: {
                this.crossOriginTpForDogs(world, player, dogsList);
                return;
            }
            case BED_DOG_WHISTLE: {
                BedDogTalent.useBedDog(world, player);
                return;
            }
            case DUTY_WHISTLE: {
                this.allStandOnDuty(world, player, dogsList);
                return;
            }
            case CARRY_ME: {
                if (world.field_9236) {
                    CarryMeScreen.open(player);
                }
                return;
            }
        }
    }

    private void rideWithMe(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.method_5765()) {
            dog.method_18375();
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle == null) {
            return;
        }
        dog.authorizeRiding();
        boolean result = dog.method_5804(vehicle);
        if (result) {
            player.method_43496((class_2561)class_2561.method_43469((String)"dogcommand.ride_with_me", (Object[])new Object[]{dog.method_5477().getString()}));
        }
    }

    private void heelByLook(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (class_1309)player, 2);
        player.method_43496((class_2561)class_2561.method_43469((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.method_5477().getString()}));
        dog.method_24346(false);
    }

    private void howl(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30);
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (!dog.readyForNonTrivialAction()) {
            return;
        }
        dog.triggerAction(new DogHowlAction(dog));
        player.method_37908().method_8396(null, player.method_24515(), DoggySounds.WHISTLE_SHORT.get(), class_3419.field_15248, 0.6f + player.method_37908().field_9229.method_43057() * 0.1f, 0.8f + player.method_37908().field_9229.method_43057() * 0.2f);
    }

    private void sssshhhh(class_1937 level, class_1657 player, List<Dog> dogs) {
        if (level.field_9236) {
            return;
        }
        player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
        boolean shh_ed = false;
        for (Dog dog : dogs) {
            if (!this.canShh(player, dog)) continue;
            shh_ed = true;
            dog.setSilentTickLeft(400);
        }
        if (shh_ed) {
            player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.ssshhh"));
            level.method_8396(null, player.method_24515(), DoggySounds.WHISTLE_LONG.get(), class_3419.field_15248, 0.1f, 0.8f + level.field_9229.method_43057() * 0.2f);
        }
    }

    private void crossOriginTpForDogs(class_1937 level, class_1657 player, List<Dog> dogs) {
        if (level.field_9236) {
            return;
        }
        player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
        dogs = dogs.stream().filter(x -> !x.method_6172()).collect(Collectors.toList());
        if (dogs.isEmpty()) {
            return;
        }
        boolean all_cross_origin = true;
        for (Dog dog : dogs) {
            if (dog.crossOriginTp()) continue;
            all_cross_origin = false;
            break;
        }
        boolean switch_to = !all_cross_origin;
        for (Dog dog : dogs) {
            dog.setCrossOriginTp(switch_to);
        }
        if (switch_to) {
            player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.cross_origin.set"));
        } else {
            player.method_43496((class_2561)class_2561.method_43471((String)"dogcommand.cross_origin.unset"));
        }
    }

    private void allStandOnDuty(class_1937 level, class_1657 player, List<Dog> dogs) {
        if (level.field_9236) {
            return;
        }
        player.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 20);
        for (Dog dog : dogs) {
            dog.setDogOnDuty(!dog.method_24345());
        }
    }

    private boolean canShh(class_1657 player, Dog dog) {
        return !(dog.method_5858((class_1297)player) > 256.0);
    }

    public static boolean isDogOnDutyOnly(class_1799 stack) {
        class_2487 tag = ItemUtil.getTag(stack);
        return tag.method_10577("dog_on_duty_only");
    }

    public static boolean isHoldingDutyWhistle(class_1309 entity) {
        class_1799 stack = entity.method_6047();
        if (!stack.method_31574((class_1792)DoggyItems.WHISTLE.get())) {
            return false;
        }
        int mode = 0;
        class_2487 tag = ItemUtil.getTag(stack);
        if (tag.method_10573("mode", 99)) {
            mode = (byte)class_3532.method_15340((int)tag.method_10571("mode"), (int)0, (int)(WhistleMode.VALUES.length - 1));
        }
        return WhistleMode.VALUES[mode] == WhistleMode.DUTY_WHISTLE;
    }

    public String method_7866(class_1799 stack) {
        byte mode = 0;
        if (stack.method_7985() && stack.method_7969().method_10573("mode", 99)) {
            mode = stack.method_7969().method_10571("mode");
        }
        return this.method_7876() + "." + mode;
    }

    public class_1814 method_7862(class_1799 stack) {
        return class_1814.field_8907;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> components, class_1836 flags) {
        String desc_id = this.method_7876() + ".description";
        components.add((class_2561)class_2561.method_43471((String)desc_id).method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
    }

    public static enum WhistleMode {
        STAND(0, WhistleSound.LONG),
        HEEL(1, WhistleSound.LONG),
        STAY(2, WhistleSound.SHORT),
        STOP_ATTACKING(3, WhistleSound.SHORT),
        SHELPERD(4, WhistleSound.SHORT),
        TACTICAL(5, WhistleSound.NONE),
        ROAR(6, WhistleSound.NONE),
        HEEL_BY_NAME(7, WhistleSound.NONE),
        TO_BED(8, WhistleSound.LONG),
        GO_BEHIND(9, WhistleSound.SHORT),
        HEEL_BY_GROUP(10, WhistleSound.NONE),
        MOB_RETRIEVER(11, WhistleSound.SHORT),
        HEEL_BY_LOOK(12, WhistleSound.SHORT),
        RIDE_WITH_ME(13, WhistleSound.SHORT),
        HOWL(14, WhistleSound.NONE),
        ALL_STAND_SWITCH_MODE(15, WhistleSound.NONE),
        SSSSSHHHH(16, WhistleSound.NONE),
        CROSS_ORIGIN_TP(17, WhistleSound.SHORT),
        BED_DOG_WHISTLE(18, WhistleSound.NONE),
        DUTY_WHISTLE(19, WhistleSound.SHORT),
        CARRY_ME(20, WhistleSound.NONE);

        public static final WhistleMode[] VALUES;
        private int id;
        private WhistleSound sound;

        private WhistleMode(int id, WhistleSound sound) {
            this.id = id;
            this.sound = sound;
        }

        public int getIndex() {
            return this.id;
        }

        public WhistleSound getSound() {
            return this.sound;
        }

        public String getUnlocalisedTitle() {
            return "item.doggytalents.whistle." + this.getIndex();
        }

        public String getHelpMsg() {
            return this.getUnlocalisedTitle() + ".help";
        }

        static {
            VALUES = (WhistleMode[])Arrays.stream(WhistleMode.values()).sorted(Comparator.comparingInt(WhistleMode::getIndex)).toArray(WhistleMode[]::new);
        }
    }

    public static enum WhistleSound {
        NONE,
        SHORT,
        LONG;

    }
}

