/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item.itemgroup;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.item.EmptyLocatorOrbItem;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.DogBedUtil;
import doggytalents.forge_imitate.registry.RegistryObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class DTNItemCategory {
    private static Set<class_1792> main;
    private static Set<class_1792> agri_base;

    public static void init() {
        main = new HashSet<class_1792>(List.of(DoggyItems.DOGGY_CHARM.get(), DoggyItems.TRAINING_TREAT.get(), DoggyItems.SUPER_TREAT.get(), DoggyItems.MASTER_TREAT.get(), DoggyItems.KAMI_TREAT.get(), DoggyItems.CONDUCTING_BONE.get(), DoggyItems.CANINE_TRACKER.get(), DoggyItems.WHISTLE.get(), DoggyItems.SCENT_TREAT.get(), DoggyItems.AMNESIA_BONE.get(), DoggyItems.THROW_BONE.get(), DoggyItems.THROW_STICK.get(), DoggyItems.BREEDING_BONE.get(), DoggyItems.TREAT_BAG.get(), DoggyItems.GENDER_BONE.get(), DoggyItems.STARTER_BUNDLE.get(), DoggyItems.MAGNIFYING_BONE.get(), DoggyItems.SHRINKING_MALLET.get(), DoggyItems.BANDAID.get(), DoggyItems.FRISBEE.get(), DoggyBlocks.FOOD_BOWL.get().method_8389(), DoggyBlocks.DOG_BATH.get().method_8389()));
        agri_base = new HashSet<class_1792>(List.of(DoggyItems.RICE_GRAINS.get(), DoggyItems.RICE_WHEAT.get(), DoggyBlocks.RICE_MILL.get().method_8389(), DoggyItems.UNCOOKED_RICE_BOWL.get(), DoggyItems.UNCOOKED_RICE.get(), DoggyItems.KOJI.get(), DoggyItems.UNCOOKED_RICE.get(), DoggyItems.SOY_BEANS_DRIED.get(), DoggyItems.SOY_PODS_DRIED.get(), DoggyItems.SOY_PODS.get(), DoggyItems.SOY_BEANS.get(), DoggyItems.MISO_PASTE.get(), DoggyItems.EDAMAME.get()));
    }

    public static boolean isMain(class_1792 item) {
        if (main == null || item == null) {
            return false;
        }
        return main.contains(item);
    }

    public static boolean isStyle(class_1792 item) {
        if (item == null) {
            return false;
        }
        if (item instanceof AccessoryItem) {
            return true;
        }
        return item instanceof EmptyLocatorOrbItem;
    }

    public static boolean isAgri(class_1792 item) {
        if (item == null) {
            return false;
        }
        if (item instanceof IDogEddible) {
            return true;
        }
        return agri_base != null && agri_base.contains(item);
    }

    public static boolean isDogBed(class_1792 item) {
        if (!(item instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)item;
        return blockItem.method_7711() instanceof DogBedBlock;
    }

    public static boolean isMisc(class_1792 item) {
        if (DTNItemCategory.isMain(item)) {
            return false;
        }
        if (DTNItemCategory.isAgri(item)) {
            return false;
        }
        if (DTNItemCategory.isStyle(item)) {
            return false;
        }
        if (DTNItemCategory.isDogBed(item)) {
            return false;
        }
        return !DTNItemCategory.isHidden(item);
    }

    public static boolean isHidden(class_1792 item) {
        return item == DoggyItems.DOG_ANIM_DEBUG.get();
    }

    public static Stream<class_1792> getAllItemOfCategory(Predicate<class_1792> pred) {
        Collection<RegistryObject<class_1792>> all_items = DoggyItems.ITEMS.getEntries();
        ArrayList<class_1792> item_list = new ArrayList<class_1792>();
        for (RegistryObject<class_1792> item_holder : all_items) {
            class_1792 item = item_holder.get();
            if (item == null || item_list.contains(item) || !pred.test(item)) continue;
            item_list.add(item);
        }
        return item_list.stream();
    }

    public static Stream<class_1799> getRandomBedsForTab() {
        int maxBeddingEntries = 13;
        int maxCasingEntries = 13;
        List beddingList = DogBedMaterialManager.getBeddings().entrySet().stream().map(x -> (IBeddingMaterial)x.getValue()).filter(x -> !(x instanceof DogBedMaterialManager.NaniBedding)).collect(Collectors.toList());
        List casingList = DogBedMaterialManager.getCasings().entrySet().stream().map(x -> (ICasingMaterial)x.getValue()).filter(x -> !(x instanceof DogBedMaterialManager.NaniCasing)).collect(Collectors.toList());
        Collections.shuffle(beddingList);
        Collections.shuffle(casingList);
        ArrayList<class_1799> bed_list = new ArrayList<class_1799>();
        for (int i = 0; i < Math.min(13, casingList.size()); ++i) {
            for (int j = 0; j < Math.min(13, beddingList.size()); ++j) {
                IBeddingMaterial beddingId = (IBeddingMaterial)beddingList.get(j);
                ICasingMaterial casingId = (ICasingMaterial)casingList.get(i);
                class_1799 created = DogBedUtil.createItemStack(casingId, beddingId);
                bed_list.add(created);
            }
        }
        return bed_list.stream();
    }
}

