/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogInterruptibleSoundData;
import doggytalents.common.util.NetworkUtil;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3414;

public class DogInterruptibleSoundPacket
implements IPacket<DogInterruptibleSoundData> {
    @Override
    public void encode(DogInterruptibleSoundData data, class_2540 buf) {
        buf.writeInt(data.dogId());
        if (!data.sound().isPresent()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeFloat(data.volume());
            buf.writeFloat(data.pitch());
            NetworkUtil.writeSoundEventToBuf(buf, data.sound().get());
        }
    }

    @Override
    public DogInterruptibleSoundData decode(class_2540 buf) {
        int dog_id = buf.readInt();
        boolean play = buf.readBoolean();
        if (!play) {
            return DogInterruptibleSoundData.stop(dog_id);
        }
        float vol = buf.readFloat();
        float pitch = buf.readFloat();
        class_3414 sound = NetworkUtil.readSoundEventFromBuf(buf);
        return new DogInterruptibleSoundData(dog_id, Optional.ofNullable(sound), vol, pitch);
    }

    @Override
    public void handle(DogInterruptibleSoundData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                return;
            }
            class_310 mc = class_310.method_1551();
            class_1297 e = mc.field_1687.method_8469(data.dogId());
            if (!(e instanceof Dog)) {
                return;
            }
            Dog dog = (Dog)e;
            dog.dogSoundManager.onDogInterruptableSoundUpdate(data);
        });
        ctx.get().setPacketHandled(true);
    }
}

